/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.Explain;

abstract class AbstractCreateViewDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String viewName;
    private final List<FieldSchema> schema;
    private final String originalText;
    private final String expandedText;

    AbstractCreateViewDesc(String viewName, List<FieldSchema> schema, String originalText, String expandedText) {
        this.viewName = viewName;
        this.schema = schema;
        this.originalText = originalText;
        this.expandedText = expandedText;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewName() {
        return this.viewName;
    }

    @Explain(displayName="original text", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getOriginalText() {
        return this.originalText;
    }

    @Explain(displayName="expanded text")
    public String getExpandedText() {
        return this.expandedText;
    }

    @Explain(displayName="columns")
    public List<String> getSchemaString() {
        return Utilities.getFieldSchemaString(this.schema);
    }

    public List<FieldSchema> getSchema() {
        return this.schema;
    }
}

