/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger.pool.add;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Trigger to pool mappings", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterPoolAddTriggerDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 383046258694558029L;
    private final String resourcePlanName;
    private final String triggerName;
    private final String poolPath;

    public AlterPoolAddTriggerDesc(String resourcePlanName, String triggerName, String poolPath) {
        this.resourcePlanName = resourcePlanName;
        this.triggerName = triggerName;
        this.poolPath = poolPath;
    }

    @Explain(displayName="Resource plan name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getResourcePlanName() {
        return this.resourcePlanName;
    }

    @Explain(displayName="Trigger name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTriggerName() {
        return this.triggerName;
    }

    public String getPoolPath() {
        return this.poolPath;
    }

    @Explain(displayName="Pool path", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getPoolPathForExplain() {
        return this.poolPath == null ? "<unmanaged queries>" : this.poolPath;
    }
}

