/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.runtime.api.events.InputInitializerEvent;

public class AppMasterEventOperator
extends Operator<AppMasterEventDesc> {
    protected transient AbstractSerDe serializer;
    protected transient DataOutputBuffer buffer;
    protected transient boolean hasReachedMaxSize = false;
    protected transient long MAX_SIZE;

    protected AppMasterEventOperator() {
    }

    public AppMasterEventOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.MAX_SIZE = HiveConf.getLongVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING_MAX_EVENT_SIZE);
        this.serializer = (AbstractSerDe)ReflectionUtils.newInstance(((AppMasterEventDesc)this.conf).getTable().getSerDeClass(), null);
        try {
            this.serializer.initialize(null, ((AppMasterEventDesc)this.conf).getTable().getProperties(), null);
        }
        catch (SerDeException e) {
            this.LOG.error("Initialization failed for serializer", (Throwable)e);
            throw new HiveException(e.getMessage());
        }
        this.initDataBuffer(false);
    }

    protected void initDataBuffer(boolean skipPruning) throws HiveException {
        this.buffer = new DataOutputBuffer();
        try {
            ((AppMasterEventDesc)this.getConf()).writeEventHeader(this.buffer);
            this.buffer.writeBoolean(skipPruning);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (this.hasReachedMaxSize) {
            return;
        }
        ObjectInspector rowInspector = this.inputObjInspectors[0];
        try {
            Writable writableRow = this.serializer.serialize(row, rowInspector);
            writableRow.write((DataOutput)this.buffer);
            if ((long)this.buffer.getLength() > this.MAX_SIZE) {
                this.LOG.info("Disabling AM events. Buffer size too large: " + this.buffer.getLength());
                this.hasReachedMaxSize = true;
                this.buffer = null;
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        this.LOG.debug("AppMasterEvent: {}", row);
        this.forward(row, rowInspector);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            TezContext context = (TezContext)TezContext.get();
            String vertexName = ((AppMasterEventDesc)this.getConf()).getVertexName();
            String inputName = ((AppMasterEventDesc)this.getConf()).getInputName();
            byte[] payload = null;
            if (this.hasReachedMaxSize) {
                this.initDataBuffer(true);
            }
            payload = new byte[this.buffer.getLength()];
            System.arraycopy(this.buffer.getData(), 0, payload, 0, this.buffer.getLength());
            InputInitializerEvent event = InputInitializerEvent.create((String)vertexName, (String)inputName, (ByteBuffer)ByteBuffer.wrap(payload, 0, payload.length));
            this.LOG.info("Sending Tez event to vertex = " + vertexName + ", input = " + inputName + ". Payload size = " + payload.length);
            context.getTezProcessorContext().sendEvents(Collections.singletonList(event));
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.EVENT;
    }

    @Override
    public String getName() {
        return AppMasterEventOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "EVENT";
    }
}

