/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.RangerDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ranger.NoOpRangerRestClient;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerExportPolicyList;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerPolicy;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClient;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClientImpl;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.RangerDumpLogger;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDumpTask
extends Task<RangerDumpWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RangerDumpTask.class);
    private transient RangerRestClient rangerRestClient;
    private transient ReplLogger replLogger;

    public RangerDumpTask() {
    }

    @VisibleForTesting
    RangerDumpTask(RangerRestClient rangerRestClient, HiveConf conf, RangerDumpWork work) {
        this.conf = conf;
        this.work = work;
        this.rangerRestClient = rangerRestClient;
    }

    public String getName() {
        return "RANGER_DUMP";
    }

    @Override
    public int execute() {
        try {
            URL url;
            long exportCount = 0L;
            Path filePath = null;
            LOG.info("Exporting Ranger Metadata");
            SecurityUtils.reloginExpiringKeytabUser();
            HashMap<String, Long> metricMap = new HashMap<String, Long>();
            metricMap.put(ReplUtils.MetricName.POLICIES.name(), 0L);
            ((RangerDumpWork)this.work).getMetricCollector().reportStageStart(this.getName(), metricMap);
            this.replLogger = new RangerDumpLogger(((RangerDumpWork)this.work).getDbName(), ((RangerDumpWork)this.work).getCurrentDumpPath().toString());
            this.replLogger.startLog();
            if (this.rangerRestClient == null) {
                this.rangerRestClient = this.getRangerRestClient();
            }
            if ((url = ((RangerDumpWork)this.work).getRangerConfigResource()) == null) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Ranger configuration is not valid ranger-hive-security.xml", "ranger"}));
            }
            this.conf.addResource(url);
            String rangerHiveServiceName = this.conf.get("ranger.plugin.hive.service.name");
            String rangerEndpoint = this.conf.get("ranger.plugin.hive.policy.rest.url");
            if (StringUtils.isEmpty((CharSequence)rangerEndpoint)) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Ranger endpoint is not valid " + rangerEndpoint, "ranger"}));
            }
            if (!this.rangerRestClient.checkConnection(rangerEndpoint, this.conf)) {
                throw new SemanticException(ErrorMsg.REPL_EXTERNAL_SERVICE_CONNECTION_ERROR.format(new String[]{"ranger", "Ranger endpoint is not reachable " + rangerEndpoint}));
            }
            RangerExportPolicyList rangerExportPolicyList = this.rangerRestClient.exportRangerPolicies(rangerEndpoint, ((RangerDumpWork)this.work).getDbName(), rangerHiveServiceName, this.conf);
            List<RangerPolicy> rangerPolicies = rangerExportPolicyList.getPolicies();
            if (rangerPolicies.isEmpty()) {
                LOG.info("Ranger policy export request returned empty list or failed, Please refer Ranger admin logs.");
                rangerExportPolicyList = new RangerExportPolicyList();
            } else {
                rangerPolicies = this.rangerRestClient.removeMultiResourcePolicies(rangerPolicies);
            }
            if (!CollectionUtils.isEmpty(rangerPolicies)) {
                rangerExportPolicyList.setPolicies(rangerPolicies);
                filePath = this.rangerRestClient.saveRangerPoliciesToFile(rangerExportPolicyList, ((RangerDumpWork)this.work).getCurrentDumpPath(), "ranger_policies.json", this.conf);
                if (filePath != null) {
                    LOG.info("Ranger policy export finished successfully");
                    exportCount = rangerExportPolicyList.getListSize();
                    ((RangerDumpWork)this.work).getMetricCollector().reportStageProgress(this.getName(), ReplUtils.MetricName.POLICIES.name(), exportCount);
                }
            }
            this.replLogger.endLog(exportCount);
            ((RangerDumpWork)this.work).getMetricCollector().reportStageEnd(this.getName(), Status.SUCCESS);
            LOG.debug("Ranger policy export filePath:" + filePath);
            LOG.info("Number of ranger policies exported {}", (Object)exportCount);
            return 0;
        }
        catch (RuntimeException e) {
            LOG.error("RuntimeException during Ranger dump", (Throwable)e);
            this.setException(e);
            try {
                ReplUtils.handleException(true, e, ((RangerDumpWork)this.work).getCurrentDumpPath().getParent().toString(), ((RangerDumpWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            LOG.error("Ranger Dump Failed: ", (Throwable)e);
            this.setException(e);
            int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
            try {
                return ReplUtils.handleException(true, e, ((RangerDumpWork)this.work).getCurrentDumpPath().getParent().toString(), ((RangerDumpWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                return errorCode;
            }
        }
    }

    private RangerRestClient getRangerRestClient() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL) || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            return new NoOpRangerRestClient();
        }
        return new RangerRestClientImpl();
    }

    @Override
    public StageType getType() {
        return StageType.RANGER_DUMP;
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }
}

