/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.wm.Action;
import org.apache.hadoop.hive.ql.wm.Trigger;
import org.apache.hadoop.hive.ql.wm.TriggerActionHandler;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillTriggerActionHandler
implements TriggerActionHandler<TezSessionState> {
    private static final Logger LOG = LoggerFactory.getLogger(KillTriggerActionHandler.class);
    private final HiveConf conf = new HiveConf();

    @Override
    public void applyAction(Map<TezSessionState, Trigger> queriesViolated) {
        for (Map.Entry<TezSessionState, Trigger> entry : queriesViolated.entrySet()) {
            if (entry.getValue().getAction().getType() == Action.Type.KILL_QUERY) {
                TezSessionState sessionState = entry.getKey();
                String queryId = sessionState.getWmContext().getQueryId();
                try {
                    UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                    DriverUtils.setUpAndStartSessionState(this.conf, ugi.getShortUserName());
                    KillQuery killQuery = sessionState.getKillQuery();
                    if (killQuery == null) continue;
                    sessionState.getKillQuery().killQuery(queryId, entry.getValue().getViolationMsg(), sessionState.getConf());
                }
                catch (IOException | HiveException e) {
                    LOG.warn("Unable to kill query {} for trigger violation", (Object)queryId);
                }
                continue;
            }
            throw new RuntimeException("Unsupported action: " + entry.getValue());
        }
    }
}

