/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.common.format.datetime.HiveSqlDateTimeFormatter;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToTimestamp;

public class CastStringToTimestampWithFormat
extends CastStringToTimestamp {
    private static final long serialVersionUID = 1L;
    private HiveSqlDateTimeFormatter formatter;

    public CastStringToTimestampWithFormat() {
    }

    public CastStringToTimestampWithFormat(int inputColumn, byte[] patternBytes, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
        if (patternBytes == null) {
            throw new IllegalStateException("Tried to cast (<string> to timestamp with format<pattern>), but <pattern> not found");
        }
        this.formatter = new HiveSqlDateTimeFormatter(new String(patternBytes, StandardCharsets.UTF_8), true);
    }

    @Override
    protected void evaluate(TimestampColumnVector outputColVector, BytesColumnVector inputColVector, int i) {
        String inputString = new String(inputColVector.vector[i], inputColVector.start[i], inputColVector.length[i], StandardCharsets.UTF_8);
        Timestamp timestamp = this.formatter.parseTimestamp(inputString.replaceAll("\u0000", ""));
        if (timestamp != null) {
            outputColVector.set(i, timestamp.toSqlTimestamp());
        } else {
            super.setNull(outputColVector, i);
        }
    }
}

