/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class LongColModuloDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public LongColModuloDoubleColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(colNum1, colNum2, outputColumnNum);
    }

    public LongColModuloDoubleColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        DoubleColumnVector inputColVector2 = (DoubleColumnVector)batch.cols[this.inputColumnNum[1]];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        long[] vector1 = inputColVector1.vector;
        double[] vector2 = inputColVector2.vector;
        double[] outputVector = outputColVector.vector;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        boolean hasDivBy0 = false;
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            double denom = vector2[0];
            hasDivBy0 = hasDivBy0 || denom == 0.0;
            outputVector[0] = (double)vector1[0] % denom;
        } else if (inputColVector1.isRepeating) {
            long vector1Value = vector1[0];
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    double denom = vector2[i];
                    hasDivBy0 = hasDivBy0 || denom == 0.0;
                    outputVector[i] = (double)vector1Value % denom;
                }
            } else {
                int i;
                for (i = 0; i != n; ++i) {
                    outputVector[i] = (double)vector1Value % vector2[i];
                }
                for (i = 0; i != n; ++i) {
                    hasDivBy0 = hasDivBy0 || vector2[i] == 0.0;
                }
            }
        } else if (inputColVector2.isRepeating) {
            double vector2Value = vector2[0];
            if (vector2Value == 0.0) {
                outputColVector.noNulls = false;
                outputColVector.isRepeating = true;
                outputColVector.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (double)vector1[i] % vector2Value;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (double)vector1[i] % vector2Value;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                double denom = vector2[i];
                hasDivBy0 = hasDivBy0 || denom == 0.0;
                outputVector[i] = (double)vector1[i] % denom;
            }
        } else {
            int i;
            for (i = 0; i != n; ++i) {
                outputVector[i] = (double)vector1[i] % vector2[i];
            }
            for (i = 0; i != n; ++i) {
                hasDivBy0 = hasDivBy0 || vector2[i] == 0.0;
            }
        }
        if (!hasDivBy0) {
            NullUtil.setNullDataEntriesDouble(outputColVector, batch.selectedInUse, sel, n);
        } else {
            NullUtil.setNullAndDivBy0DataEntriesDouble(outputColVector, batch.selectedInUse, sel, n, inputColVector2);
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

