/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.BytesBytesMultiHashMap;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerDirectAccess;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.persistence.ReusableGetAdaptorDirectAccess;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedMultiKeyHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinOptimizedHashTable
implements VectorMapJoinHashTable,
VectorMapJoinBytesHashTable {
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinOptimizedMultiKeyHashMap.class.getName());
    protected final MapJoinTableContainer originalTableContainer;
    protected final MapJoinTableContainerDirectAccess containerDirectAccess;
    protected final ReusableGetAdaptorDirectAccess adapterDirectAccess;

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int spillPartitionId() {
        return this.adapterDirectAccess.directSpillPartitionId();
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws SerDeException, HiveException, IOException {
        throw new UnsupportedEncodingException();
    }

    @Override
    public boolean containsLongKey(long currentKey) {
        throw new UnsupportedOperationException();
    }

    protected void putRowInternal(BytesWritable key, BytesWritable value) throws SerDeException, HiveException, IOException {
        this.containerDirectAccess.put((Writable)key, (Writable)value);
    }

    public JoinUtil.JoinResult doLookup(byte[] keyBytes, int keyOffset, int keyLength, BytesBytesMultiHashMap.Result bytesBytesMultiHashMapResult, VectorMapJoinHashTableResult hashTableResult, MatchTracker matchTracker) {
        hashTableResult.forget();
        JoinUtil.JoinResult joinResult = this.adapterDirectAccess.setDirect(keyBytes, keyOffset, keyLength, bytesBytesMultiHashMapResult, matchTracker);
        if (joinResult == JoinUtil.JoinResult.SPILL) {
            hashTableResult.setSpillPartitionId(this.adapterDirectAccess.directSpillPartitionId());
        }
        hashTableResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinOptimizedHashTable(MapJoinTableContainer originalTableContainer, MapJoinTableContainer.ReusableGetAdaptor hashMapRowGetter) {
        this.originalTableContainer = originalTableContainer;
        this.containerDirectAccess = (MapJoinTableContainerDirectAccess)((Object)originalTableContainer);
        this.adapterDirectAccess = (ReusableGetAdaptorDirectAccess)((Object)hashMapRowGetter);
    }

    @Override
    public int size() {
        return this.originalTableContainer.size();
    }

    public long getEstimatedMemorySize() {
        long size = 0L;
        size += this.originalTableContainer == null ? 0L : this.originalTableContainer.getEstimatedMemorySize();
        return size += (long)(2 * JavaDataModel.get().object());
    }

    @Override
    public MatchTracker createMatchTracker() {
        return this.adapterDirectAccess.createMatchTracker();
    }

    public static class SerializedBytes {
        byte[] bytes;
        int offset;
        int length;
    }
}

