/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import com.cronutils.utils.StringUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.ddl.database.lock.LockDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.database.unlock.UnlockDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.table.lock.LockTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.lock.UnlockTableDesc;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManagerImpl;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class DbTxnManager
extends HiveTxnManagerImpl {
    private static final String CLASS_NAME = DbTxnManager.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    public static final String GLOBAL_LOCKS = "__GLOBAL_LOCKS";
    private volatile DbLockManager lockMgr = null;
    private volatile long txnId = 0L;
    private Map<String, Long> tableWriteIds = new HashMap<String, Long>();
    private boolean shouldReallocateWriteIds = false;
    private int stmtId = -1;
    private int numStatements = 0;
    private boolean isExplicitTransaction = false;
    private int startTransactionCount = 0;
    private String queryId;
    private static ScheduledExecutorService heartbeatExecutorService = null;
    private ScheduledFuture<?> heartbeatTask = null;
    private static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private String replPolicy;

    IMetaStoreClient getMS() throws LockException {
        try {
            return Hive.get(this.conf).getMSC();
        }
        catch (MetaException | HiveException e) {
            String msg = "Unable to reach Hive Metastore: " + e.getMessage();
            LOG.error(msg, e);
            throw new LockException(e);
        }
    }

    DbTxnManager() {
    }

    @Override
    void setHiveConf(HiveConf conf) {
        if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
            throw new RuntimeException(ErrorMsg.DBTXNMGR_REQUIRES_CONCURRENCY.getMsg());
        }
        super.setHiveConf(conf);
    }

    @Override
    public List<Long> replOpenTxn(String replPolicy, List<Long> srcTxnIds, String user) throws LockException {
        try {
            return this.getMS().replOpenTxn(replPolicy, srcTxnIds, user, TxnType.REPL_CREATED);
        }
        catch (TException e) {
            throw new LockException(e, ErrorMsg.METASTORE_COMMUNICATION_FAILED);
        }
    }

    @Override
    public long openTxn(Context ctx, String user) throws LockException {
        return this.openTxn(ctx, user, TxnType.DEFAULT, 0L);
    }

    @Override
    public long openTxn(Context ctx, String user, TxnType txnType) throws LockException {
        return this.openTxn(ctx, user, txnType, 0L);
    }

    @Override
    public void clearCaches() {
        LOG.info("Clearing writeId cache for {}", (Object)JavaUtils.txnIdToString((long)this.txnId));
        this.tableWriteIds.clear();
        this.shouldReallocateWriteIds = true;
    }

    @VisibleForTesting
    long openTxn(Context ctx, String user, TxnType txnType, long delay) throws LockException {
        this.init();
        this.getLockManager();
        if (this.isTxnOpen()) {
            throw new LockException("Transaction already opened. " + JavaUtils.txnIdToString((long)this.txnId));
        }
        try {
            this.replPolicy = ctx.getReplPolicy();
            this.txnId = this.replPolicy != null ? ((Long)this.getMS().replOpenTxn(this.replPolicy, null, user, txnType).get(0)).longValue() : this.getMS().openTxn(user, txnType);
            this.stmtId = 0;
            this.numStatements = 0;
            this.tableWriteIds.clear();
            this.shouldReallocateWriteIds = false;
            this.isExplicitTransaction = false;
            this.startTransactionCount = 0;
            this.queryId = ctx.getConf().get(HiveConf.ConfVars.HIVE_QUERY_ID.varname);
            LOG.info("Opened " + JavaUtils.txnIdToString((long)this.txnId));
            ctx.setHeartbeater(this.startHeartbeat(delay));
            return this.txnId;
        }
        catch (TException e) {
            throw new LockException(e, ErrorMsg.METASTORE_COMMUNICATION_FAILED);
        }
    }

    @Override
    public HiveLockManager getLockManager() {
        this.init();
        if (this.lockMgr == null) {
            this.lockMgr = new DbLockManager(this.conf, this);
        }
        return this.lockMgr;
    }

    @Override
    public void acquireLocks(QueryPlan plan, Context ctx, String username) throws LockException {
        try {
            this.acquireLocksWithHeartbeatDelay(plan, ctx, username, 0L);
        }
        catch (LockException e) {
            if (e.getCause() instanceof TxnAbortedException) {
                this.resetTxnInfo();
            }
            throw e;
        }
    }

    private static String getQueryIdWaterMark(QueryPlan queryPlan) {
        return "queryId=" + queryPlan.getQueryId();
    }

    private void markExplicitTransaction(QueryPlan queryPlan) throws LockException {
        this.isExplicitTransaction = true;
        if (++this.startTransactionCount > 1) {
            throw new LockException(null, ErrorMsg.OP_NOT_ALLOWED_IN_TXN, queryPlan.getOperationName(), JavaUtils.txnIdToString((long)this.getCurrentTxnId()), queryPlan.getQueryId());
        }
    }

    private void verifyState(QueryPlan queryPlan) throws LockException {
        if (!this.isTxnOpen() && queryPlan.isRequiresOpenTransaction()) {
            throw new LockException("No transaction context for operation: " + queryPlan.getOperationName() + " for " + DbTxnManager.getQueryIdWaterMark(queryPlan));
        }
        if (queryPlan.getOperation() == null) {
            throw new IllegalStateException("Unknown HiveOperation(null) for " + DbTxnManager.getQueryIdWaterMark(queryPlan));
        }
        ++this.numStatements;
        switch (queryPlan.getOperation()) {
            case START_TRANSACTION: {
                this.markExplicitTransaction(queryPlan);
                break;
            }
            case COMMIT: 
            case ROLLBACK: {
                if (this.isExplicitTransaction) break;
                throw new LockException(null, ErrorMsg.OP_NOT_ALLOWED_IN_IMPLICIT_TXN, queryPlan.getOperationName());
            }
            default: {
                if (queryPlan.getOperation().isAllowedInTransaction() || !this.isExplicitTransaction || this.allowOperationInATransaction(queryPlan)) break;
                throw new LockException(null, ErrorMsg.OP_NOT_ALLOWED_IN_TXN, queryPlan.getOperationName(), JavaUtils.txnIdToString((long)this.getCurrentTxnId()), queryPlan.getQueryId());
            }
        }
    }

    private boolean allowOperationInATransaction(QueryPlan queryPlan) {
        WriteEntity writeEntity;
        if (queryPlan.getOperation() == HiveOperation.LOAD && queryPlan.getOutputs() != null && queryPlan.getOutputs().size() == 1 && AcidUtils.isTransactionalTable((writeEntity = queryPlan.getOutputs().iterator().next()).getTable())) {
            switch (writeEntity.getWriteType()) {
                case INSERT: {
                    return true;
                }
                case INSERT_OVERWRITE: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void addWriteIdsToMinHistory(QueryPlan plan, ValidTxnWriteIdList txnWriteIds) {
        if (plan.getInputs().isEmpty()) {
            return;
        }
        Map writeIds = plan.getInputs().stream().filter(input -> !input.isDummy() && AcidUtils.isTransactionalTable(input.getTable())).map(input -> input.getTable().getFullyQualifiedName()).distinct().collect(Collectors.toMap(Function.identity(), arg_0 -> ((ValidTxnWriteIdList)txnWriteIds).getMinOpenWriteId(arg_0)));
        if (!writeIds.isEmpty()) {
            try {
                this.getMS().addWriteIdsToMinHistory(this.txnId, writeIds);
            }
            catch (LockException | TException e) {
                throw new RuntimeException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    LockState acquireLocks(QueryPlan plan, Context ctx, String username, boolean isBlocking) throws LockException {
        this.init();
        this.getLockManager();
        this.verifyState(plan);
        this.queryId = plan.getQueryId();
        if (plan.getOperation() == HiveOperation.SET_AUTOCOMMIT) {
            return null;
        }
        LOG.info("Setting lock request transaction to " + JavaUtils.txnIdToString((long)this.txnId) + " for queryId=" + this.queryId);
        if (plan.getInputs().isEmpty() && plan.getOutputs().isEmpty()) {
            LOG.debug("No locks needed for queryId=" + this.queryId);
            return null;
        }
        List<LockComponent> lockComponents = AcidUtils.makeLockComponents(plan.getOutputs(), plan.getInputs(), ctx.getOperation(), this.conf);
        lockComponents.addAll(this.getGlobalLocks(ctx.getConf()));
        if (lockComponents.isEmpty()) {
            LOG.debug("No locks needed for queryId=" + this.queryId);
            return null;
        }
        LockRequest lockRqst = new LockRequestBuilder(this.queryId).setTransactionId(this.txnId).setUser(username).setExclusiveCTAS(AcidUtils.isExclusiveCTAS(plan.getOutputs(), this.conf)).setZeroWaitReadEnabled(!this.conf.getBoolVar(HiveConf.ConfVars.TXN_OVERWRITE_X_LOCK) || !this.conf.getBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK)).addLockComponents(lockComponents).build();
        ArrayList<HiveLock> locks = new ArrayList<HiveLock>(1);
        LockState lockState = this.lockMgr.lock(lockRqst, this.queryId, isBlocking, locks);
        ctx.setHiveLocks(locks);
        return lockState;
    }

    private Collection<LockComponent> getGlobalLocks(Configuration conf) {
        String lockNames = conf.get("hive.query.exclusive.lock");
        if (StringUtils.isEmpty((CharSequence)lockNames)) {
            return Collections.emptyList();
        }
        ArrayList<LockComponent> globalLocks = new ArrayList<LockComponent>();
        for (String lockName : lockNames.split(",")) {
            if (StringUtils.isEmpty((CharSequence)(lockName = lockName.trim()))) continue;
            LockComponentBuilder compBuilder = new LockComponentBuilder();
            compBuilder.setExclusive();
            compBuilder.setOperationType(DataOperationType.NO_TXN);
            compBuilder.setDbName(GLOBAL_LOCKS);
            compBuilder.setTableName(lockName);
            globalLocks.add(compBuilder.build());
            LOG.debug("Adding global lock: " + lockName);
        }
        return globalLocks;
    }

    @VisibleForTesting
    void acquireLocksWithHeartbeatDelay(QueryPlan plan, Context ctx, String username, long delay) throws LockException {
        LockState ls = this.acquireLocks(plan, ctx, username, true);
        if (ls != null && !this.isTxnOpen()) {
            ctx.setHeartbeater(this.startHeartbeat(delay));
        }
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) {
        if (this.lockMgr != null) {
            this.stopHeartbeat();
            this.lockMgr.releaseLocks(hiveLocks);
        }
    }

    private void clearLocksAndHB() {
        this.lockMgr.clearLocalLockRecords();
        this.stopHeartbeat();
    }

    private void resetTxnInfo() {
        this.txnId = 0L;
        this.stmtId = -1;
        this.numStatements = 0;
        this.tableWriteIds.clear();
        this.shouldReallocateWriteIds = false;
        this.queryId = null;
        this.replPolicy = null;
    }

    @Override
    public void replCommitTxn(CommitTxnRequest rqst) throws LockException {
        try {
            if (rqst.isSetReplLastIdInfo()) {
                if (!this.isTxnOpen()) {
                    throw new RuntimeException("Attempt to commit before opening a transaction");
                }
                this.clearLocksAndHB();
            }
            this.getMS().commitTxn(rqst);
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString((long)rqst.getTxnid()));
            throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString((long)rqst.getTxnid()));
        }
        catch (TxnAbortedException e) {
            LockException le = new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString((long)rqst.getTxnid()), e.getMessage());
            LOG.error(le.getMessage());
            throw le;
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            if (rqst.isSetReplLastIdInfo()) {
                this.resetTxnInfo();
            }
        }
    }

    @Override
    public void commitTxn() throws LockException {
        if (!this.isTxnOpen()) {
            throw new RuntimeException("Attempt to commit before opening a transaction");
        }
        try {
            this.clearLocksAndHB();
            LOG.debug("Committing txn " + JavaUtils.txnIdToString((long)this.txnId));
            CommitTxnRequest commitTxnRequest = new CommitTxnRequest(this.txnId);
            commitTxnRequest.setExclWriteEnabled(this.conf.getBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK));
            if (this.replPolicy != null) {
                commitTxnRequest.setReplPolicy(this.replPolicy);
                commitTxnRequest.setTxn_type(TxnType.DEFAULT);
            }
            this.getMS().commitTxn(commitTxnRequest);
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString((long)this.txnId));
            throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString((long)this.txnId));
        }
        catch (TxnAbortedException e) {
            LockException le = new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString((long)this.txnId), e.getMessage());
            LOG.error(le.getMessage());
            throw le;
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            this.resetTxnInfo();
        }
    }

    @Override
    public void replRollbackTxn(String replPolicy, long srcTxnId) throws LockException {
        try {
            this.getMS().replRollbackTxn(srcTxnId, replPolicy, TxnType.REPL_CREATED);
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString((long)srcTxnId));
            throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString((long)srcTxnId));
        }
        catch (TxnAbortedException e) {
            LockException le = new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString((long)srcTxnId), e.getMessage());
            LOG.error(le.getMessage());
            throw le;
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public void rollbackTxn() throws LockException {
        if (!this.isTxnOpen()) {
            throw new RuntimeException("Attempt to rollback before opening a transaction");
        }
        try {
            this.clearLocksAndHB();
            LOG.debug("Rolling back " + JavaUtils.txnIdToString((long)this.txnId));
            if (this.replPolicy != null) {
                this.getMS().replRollbackTxn(this.txnId, this.replPolicy, TxnType.DEFAULT);
            } else {
                AbortTxnRequest abortTxnRequest = new AbortTxnRequest(this.txnId);
                abortTxnRequest.setErrorCode(TxnErrorMsg.ABORT_ROLLBACK.getErrorCode());
                this.getMS().rollbackTxn(abortTxnRequest);
            }
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString((long)this.txnId));
            throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString((long)this.txnId));
        }
        catch (TxnAbortedException e) {
            throw new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString((long)this.txnId));
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            this.resetTxnInfo();
        }
    }

    @Override
    public void replTableWriteIdState(String validWriteIdList, String dbName, String tableName, List<String> partNames) throws LockException {
        try {
            this.getMS().replTableWriteIdState(validWriteIdList, dbName, tableName, partNames);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public void heartbeat() throws LockException {
        List<HiveLock> locks = this.isTxnOpen() ? Collections.singletonList(new DbLockManager.DbHiveLock(0L)) : this.lockMgr.getLocks(false, false);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("Sending heartbeat for ").append(JavaUtils.txnIdToString((long)this.txnId)).append(" and");
            for (HiveLock lock : locks) {
                sb.append(" ").append(lock.toString());
            }
            LOG.info(sb.toString());
        }
        if (!this.isTxnOpen() && locks.isEmpty()) {
            LOG.debug("No need to send heartbeat as there is no transaction and no locks.");
            return;
        }
        for (HiveLock lock : locks) {
            long lockId = ((DbLockManager.DbHiveLock)lock).lockId;
            try {
                this.getMS().heartbeat(this.txnId, lockId);
            }
            catch (NoSuchLockException e) {
                LOG.error("Unable to find lock " + JavaUtils.lockIdToString((long)lockId));
                throw new LockException(e, ErrorMsg.LOCK_NO_SUCH_LOCK, JavaUtils.lockIdToString((long)lockId));
            }
            catch (NoSuchTxnException e) {
                LOG.error("Unable to find transaction " + JavaUtils.txnIdToString((long)this.txnId));
                throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString((long)this.txnId));
            }
            catch (TxnAbortedException e) {
                LockException le = new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString((long)this.txnId), e.getMessage());
                LOG.error(le.getMessage());
                throw le;
            }
            catch (TException e) {
                throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg() + "(" + JavaUtils.txnIdToString((long)this.txnId) + "," + lock.toString() + ")", e);
            }
        }
    }

    private Heartbeater startHeartbeat(long initialDelay) throws LockException {
        UserGroupInformation currentUser;
        long heartbeatInterval = DbTxnManager.getHeartbeatInterval((Configuration)this.conf);
        assert (heartbeatInterval > 0L);
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new LockException("error while getting current user,", e);
        }
        Heartbeater heartbeater = new Heartbeater(this, this.conf, this.queryId, currentUser);
        this.heartbeatTask = this.startHeartbeat(initialDelay, heartbeatInterval, heartbeater);
        LOG.debug("Started heartbeat with delay/interval = " + initialDelay + "/" + heartbeatInterval + " " + TimeUnit.MILLISECONDS + " for query: " + this.queryId);
        return heartbeater;
    }

    private ScheduledFuture<?> startHeartbeat(long initialDelay, long heartbeatInterval, Runnable heartbeater) {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_HEARTBEATER)) {
            initialDelay = 0L;
        } else if (initialDelay == 0L) {
            initialDelay = (long)Math.floor((double)heartbeatInterval * 0.75 * Math.random());
        }
        ScheduledFuture<?> task = heartbeatExecutorService.scheduleAtFixedRate(heartbeater, initialDelay, heartbeatInterval, TimeUnit.MILLISECONDS);
        return task;
    }

    private synchronized void stopHeartbeat() {
        if (this.heartbeatTask != null) {
            this.heartbeatTask.cancel(true);
            long startTime = System.currentTimeMillis();
            long sleepInterval = 100L;
            while (!this.heartbeatTask.isCancelled() && !this.heartbeatTask.isDone()) {
                long now = System.currentTimeMillis();
                if (now - startTime > 30000L) {
                    LOG.error("Heartbeat task cannot be cancelled for unknown reason. QueryId: " + this.queryId);
                    break;
                }
                try {
                    Thread.sleep(sleepInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sleepInterval *= 2L;
            }
            if (this.heartbeatTask.isCancelled() || this.heartbeatTask.isDone()) {
                LOG.info("Stopped heartbeat for query: " + this.queryId);
            }
            this.heartbeatTask = null;
            this.queryId = null;
        }
    }

    @Override
    public GetOpenTxnsResponse getOpenTxns() throws LockException {
        try {
            return this.getMS().getOpenTxns();
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public ValidTxnList getValidTxns() throws LockException {
        assert (this.isTxnOpen());
        this.init();
        try {
            return this.getMS().getValidTxns(this.txnId);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public ValidTxnList getValidTxns(List<TxnType> excludeTxnTypes) throws LockException {
        assert (this.isTxnOpen());
        this.init();
        try {
            return this.getMS().getValidTxns(this.txnId, excludeTxnTypes);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public ValidTxnWriteIdList getValidWriteIds(List<String> tableList, String validTxnList) throws LockException {
        assert (this.isTxnOpen());
        if (!StringUtils.isEmpty((CharSequence)validTxnList)) {
            try {
                return TxnCommonUtils.createValidTxnWriteIdList((Long)this.txnId, (List)this.getMS().getValidWriteIds(tableList, validTxnList));
            }
            catch (TException e) {
                throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
            }
        }
        return null;
    }

    @Override
    public String getTxnManagerName() {
        return CLASS_NAME;
    }

    @Override
    public boolean supportsExplicitLock() {
        return false;
    }

    @Override
    public int lockTable(Hive db, LockTableDesc lockTbl) throws HiveException {
        super.lockTable(db, lockTbl);
        throw new UnsupportedOperationException();
    }

    @Override
    public int unlockTable(Hive hiveDB, UnlockTableDesc unlockTbl) throws HiveException {
        super.unlockTable(hiveDB, unlockTbl);
        throw new UnsupportedOperationException();
    }

    @Override
    public int lockDatabase(Hive hiveDB, LockDatabaseDesc lockDb) throws HiveException {
        super.lockDatabase(hiveDB, lockDb);
        throw new UnsupportedOperationException();
    }

    @Override
    public int unlockDatabase(Hive hiveDB, UnlockDatabaseDesc unlockDb) throws HiveException {
        super.unlockDatabase(hiveDB, unlockDb);
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean useNewShowLocksFormat() {
        return true;
    }

    @Override
    public boolean supportsAcid() {
        return true;
    }

    @Override
    public boolean recordSnapshot(QueryPlan queryPlan) {
        if (!this.isTxnOpen()) {
            return false;
        }
        assert (this.numStatements > 0) : "was acquireLocks() called already?";
        if (queryPlan.getOperation() == HiveOperation.START_TRANSACTION) {
            assert (this.isExplicitTransaction);
            assert (this.numStatements == 1);
            return true;
        }
        if (!this.isExplicitTransaction) {
            assert (this.numStatements == 1) : "numStatements=" + this.numStatements + " in implicit txn";
            if (queryPlan.hasAcidResourcesInQuery()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isImplicitTransactionOpen() {
        return this.isImplicitTransactionOpen(null);
    }

    @Override
    public boolean isImplicitTransactionOpen(Context ctx) {
        if (!this.isTxnOpen()) {
            return false;
        }
        if (!this.isExplicitTransaction) {
            if (ctx == null || !ctx.isExplainSkipExecution()) assert (this.numStatements == 1) : "numStatements=" + this.numStatements;
            return true;
        }
        return false;
    }

    @Override
    protected void destruct() {
        try {
            this.stopHeartbeat();
            if (this.isTxnOpen()) {
                this.rollbackTxn();
            }
            if (this.lockMgr != null) {
                this.lockMgr.close();
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception " + e.getClass().getName() + " with message <" + e.getMessage() + ">, swallowing as there is nothing we can do with it.");
        }
    }

    private void init() {
        if (this.conf == null) {
            throw new RuntimeException("Must call setHiveConf before any other methods.");
        }
        DbTxnManager.initHeartbeatExecutorService(this.conf.getIntVar(HiveConf.ConfVars.HIVE_TXN_HEARTBEAT_THREADPOOL_SIZE));
    }

    private static synchronized void initHeartbeatExecutorService(int corePoolSize) {
        if (heartbeatExecutorService != null) {
            return;
        }
        heartbeatExecutorService = Executors.newScheduledThreadPool(corePoolSize, new ThreadFactory(){
            private final AtomicInteger threadCounter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new HeartbeaterThread(r, "Heartbeater-" + this.threadCounter.getAndIncrement());
            }
        });
        ((ScheduledThreadPoolExecutor)heartbeatExecutorService).setRemoveOnCancelPolicy(true);
        ShutdownHookManager.addShutdownHook(DbTxnManager::shutdownHeartbeatExecutorService, (int)0);
    }

    private static synchronized void shutdownHeartbeatExecutorService() {
        if (heartbeatExecutorService != null && !heartbeatExecutorService.isShutdown()) {
            LOG.info("Shutting down Heartbeater thread pool.");
            heartbeatExecutorService.shutdown();
        }
    }

    @Override
    public boolean isTxnOpen() {
        return this.txnId > 0L;
    }

    @Override
    public long getCurrentTxnId() {
        return this.txnId;
    }

    @Override
    public int getStmtIdAndIncrement() {
        assert (this.isTxnOpen());
        return this.stmtId++;
    }

    @Override
    public int getCurrentStmtId() {
        assert (this.isTxnOpen());
        return this.stmtId;
    }

    @Override
    public long getTableWriteId(String dbName, String tableName) throws LockException {
        assert (this.isTxnOpen());
        return this.getTableWriteId(dbName, tableName, true, this.shouldReallocateWriteIds);
    }

    @Override
    public long getAllocatedTableWriteId(String dbName, String tableName) throws LockException {
        assert (this.isTxnOpen());
        return this.getTableWriteId(dbName, tableName, false, false);
    }

    @Override
    public void setTableWriteId(String dbName, String tableName, long writeId) throws LockException {
        String fullTableName = AcidUtils.getFullTableName(dbName, tableName);
        if (writeId > 0L) {
            this.tableWriteIds.put(fullTableName, writeId);
        } else {
            this.getTableWriteId(dbName, tableName);
        }
    }

    private long getTableWriteId(String dbName, String tableName, boolean allocateIfNotYet, boolean shouldReallocate) throws LockException {
        String fullTableName = AcidUtils.getFullTableName(dbName, tableName);
        if (this.tableWriteIds.containsKey(fullTableName)) {
            return this.tableWriteIds.get(fullTableName);
        }
        if (!allocateIfNotYet) {
            return 0L;
        }
        try {
            long writeId = this.getMS().allocateTableWriteId(this.txnId, dbName, tableName, shouldReallocate);
            LOG.info("Allocated write ID {} for {}.{} and {} (shouldReallocate: {}) ", new Object[]{writeId, dbName, tableName, JavaUtils.txnIdToString((long)this.txnId), shouldReallocate});
            this.tableWriteIds.put(fullTableName, writeId);
            return writeId;
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public LockResponse acquireMaterializationRebuildLock(String dbName, String tableName, long txnId) throws LockException {
        LockResponse lockResponse;
        try {
            lockResponse = this.getMS().lockMaterializationRebuild(dbName, tableName, txnId);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        if (lockResponse.getState() == LockState.ACQUIRED) {
            this.init();
            long initialDelay = 0L;
            long heartbeatInterval = DbTxnManager.getHeartbeatInterval((Configuration)this.conf);
            assert (heartbeatInterval > 0L);
            MaterializationRebuildLockHeartbeater heartbeater = new MaterializationRebuildLockHeartbeater(this, dbName, tableName, this.queryId, txnId);
            ScheduledFuture<?> task = this.startHeartbeat(initialDelay, heartbeatInterval, heartbeater);
            heartbeater.task.set(task);
            LOG.debug("Started heartbeat for materialization rebuild lock for {} with delay/interval = {}/{} {} for query: {}", new Object[]{AcidUtils.getFullTableName(dbName, tableName), initialDelay, heartbeatInterval, TimeUnit.MILLISECONDS, this.queryId});
        }
        return lockResponse;
    }

    @Override
    public long getLatestTxnIdInConflict() throws LockException {
        try {
            return this.getMS().getLatestTxnIdInConflict(this.txnId);
        }
        catch (TException e) {
            throw new LockException(e);
        }
    }

    private boolean heartbeatMaterializationRebuildLock(String dbName, String tableName, long txnId) throws LockException {
        try {
            return this.getMS().heartbeatLockMaterializationRebuild(dbName, tableName, txnId);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public void replAllocateTableWriteIdsBatch(String dbName, String tableName, String replPolicy, List<TxnToWriteId> srcTxnToWriteIdList) throws LockException {
        try {
            this.getMS().replAllocateTableWriteIdsBatch(dbName, tableName, replPolicy, srcTxnToWriteIdList);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    public static long getHeartbeatInterval(Configuration conf) throws LockException {
        long interval = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) / 2L;
        if (interval == 0L) {
            throw new LockException(HiveConf.ConfVars.HIVE_TXN_TIMEOUT.toString() + " not set, heartbeats won't be sent");
        }
        return interval;
    }

    @Override
    public String getQueryid() {
        return this.queryId;
    }

    public static class Heartbeater
    implements Runnable {
        private HiveTxnManager txnMgr;
        private HiveConf conf;
        private UserGroupInformation currentUser;
        LockException lockException;
        private final String queryId;

        public LockException getLockException() {
            return this.lockException;
        }

        Heartbeater(HiveTxnManager txnMgr, HiveConf conf, String queryId, UserGroupInformation currentUser) {
            this.txnMgr = txnMgr;
            this.conf = conf;
            this.currentUser = currentUser;
            this.lockException = null;
            this.queryId = queryId;
        }

        @Override
        public void run() {
            try {
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_HEARTBEATER)) {
                    throw new LockException(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_HEARTBEATER.name() + "=true");
                }
                LOG.debug("Heartbeating...for currentUser: " + this.currentUser);
                this.currentUser.doAs(() -> {
                    this.txnMgr.heartbeat();
                    return null;
                });
            }
            catch (LockException e) {
                LOG.error("Failed trying to heartbeat queryId=" + this.queryId + ", currentUser: " + this.currentUser + ": " + e.getMessage());
                this.lockException = e;
            }
            catch (Throwable t) {
                String errorMsg = "Failed trying to heartbeat queryId=" + this.queryId + ", currentUser: " + this.currentUser + ": " + t.getMessage();
                LOG.error(errorMsg, t);
                this.lockException = new LockException(errorMsg, t);
            }
        }
    }

    private static class MaterializationRebuildLockHeartbeater
    implements Runnable {
        private final DbTxnManager txnMgr;
        private final String dbName;
        private final String tableName;
        private final String queryId;
        private final long txnId;
        private final AtomicReference<ScheduledFuture<?>> task;

        MaterializationRebuildLockHeartbeater(DbTxnManager txnMgr, String dbName, String tableName, String queryId, long txnId) {
            this.txnMgr = txnMgr;
            this.queryId = queryId;
            this.dbName = dbName;
            this.tableName = tableName;
            this.txnId = txnId;
            this.task = new AtomicReference();
        }

        @Override
        public void run() {
            ScheduledFuture<?> t;
            boolean refreshed;
            LOG.trace("Heartbeating materialization rebuild lock for {} for query: {}", (Object)AcidUtils.getFullTableName(this.dbName, this.tableName), (Object)this.queryId);
            try {
                refreshed = this.txnMgr.heartbeatMaterializationRebuildLock(this.dbName, this.tableName, this.txnId);
            }
            catch (LockException e) {
                LOG.error("Failed trying to acquire lock", (Throwable)((Object)e));
                throw new RuntimeException((Throwable)((Object)e));
            }
            if (!refreshed && (t = this.task.get()) != null) {
                t.cancel(false);
                LOG.debug("Stopped heartbeat for materialization rebuild lock for {} for query: {}", (Object)AcidUtils.getFullTableName(this.dbName, this.tableName), (Object)this.queryId);
            }
        }
    }

    public static class HeartbeaterThread
    extends Thread {
        HeartbeaterThread(Runnable target, String name) {
            super(target, name);
            this.setDaemon(true);
        }
    }
}

