/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;

public class PrimaryKeyInfo
implements Serializable {
    private Map<Integer, String> colNames;
    private String constraintName;
    private String tableName;
    private String databaseName;
    private String enable;
    private String validate;
    private String rely;

    public PrimaryKeyInfo() {
    }

    public PrimaryKeyInfo(List<SQLPrimaryKey> pks, String tableName, String databaseName) {
        this.tableName = tableName;
        this.databaseName = databaseName;
        this.colNames = new TreeMap<Integer, String>();
        if (pks == null) {
            return;
        }
        if (!pks.isEmpty()) {
            this.enable = pks.get(0).isEnable_cstr() ? "ENABLE" : "DISABLE";
            this.validate = pks.get(0).isValidate_cstr() ? "VALIDATE" : "NOVALIDATE";
            this.rely = pks.get(0).isRely_cstr() ? "RELY" : "NORELY";
        }
        for (SQLPrimaryKey pk : pks) {
            if (!pk.getTable_db().equalsIgnoreCase(databaseName) || !pk.getTable_name().equalsIgnoreCase(tableName)) continue;
            this.colNames.put(pk.getKey_seq(), pk.getColumn_name());
            this.constraintName = pk.getPk_name();
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<Integer, String> getColNames() {
        return this.colNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setColNames(Map<Integer, String> colNames) {
        this.colNames = colNames;
    }

    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public String getRely() {
        return this.rely;
    }

    public void setRely(String rely) {
        this.rely = rely;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Primary Key for " + this.databaseName + "." + this.tableName + ":");
        sb.append("[");
        if (this.colNames != null && this.colNames.size() > 0) {
            for (Map.Entry<Integer, String> me : this.colNames.entrySet()) {
                sb.append(me.getValue() + ",");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append("], Constraint Name: " + this.constraintName);
        return sb.toString();
    }

    public static boolean isNotEmpty(PrimaryKeyInfo info) {
        return info != null && !info.getColNames().isEmpty();
    }
}

