/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.HiveSqlCountAggFunction;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCAggregationPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCAggregationPushDownRule.class);
    public static final JDBCAggregationPushDownRule INSTANCE = new JDBCAggregationPushDownRule();

    public JDBCAggregationPushDownRule() {
        super(JDBCAggregationPushDownRule.operand(HiveAggregate.class, (RelOptRuleOperand)JDBCAggregationPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCAggregationPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveAggregate agg = (HiveAggregate)call.rel(0);
        HiveJdbcConverter converter = (HiveJdbcConverter)call.rel(1);
        if (agg.getGroupType() != Aggregate.Group.SIMPLE) {
            return false;
        }
        for (AggregateCall relOptRuleOperand : agg.getAggCallList()) {
            HiveSqlCountAggFunction countAgg;
            SqlAggFunction f = relOptRuleOperand.getAggregation();
            if (f instanceof HiveSqlCountAggFunction && (countAgg = (HiveSqlCountAggFunction)f).isDistinct() && 1 < relOptRuleOperand.getArgList().size()) {
                return false;
            }
            SqlKind kind = f.getKind();
            if (converter.getJdbcDialect().supportsAggregateFunction(kind)) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        JdbcRules.JdbcAggregate jdbcAggregate;
        LOG.debug("JDBCAggregationPushDownRule has been called");
        HiveAggregate aggregate = (HiveAggregate)call.rel(0);
        HiveJdbcConverter converter = (HiveJdbcConverter)call.rel(1);
        try {
            RelOptCluster relOptCluster = aggregate.getCluster();
            RelTraitSet relTraitSet = aggregate.getTraitSet().replace((RelTrait)converter.getJdbcConvention());
            RelNode relNode = converter.getInput();
            Objects.requireNonNull(aggregate);
            jdbcAggregate = new JdbcRules.JdbcAggregate(relOptCluster, relTraitSet, relNode, false, aggregate.getGroupSet(), (List)aggregate.getGroupSets(), aggregate.getAggCallList());
        }
        catch (InvalidRelException e) {
            LOG.warn(e.toString());
            return;
        }
        call.transformTo(converter.copy(converter.getTraitSet(), (RelNode)jdbcAggregate));
    }
}

