/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveRelNodeVisitor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

class HiveUnionVisitor
extends HiveRelNodeVisitor<HiveUnion> {
    HiveUnionVisitor(HiveOpConverter hiveOpConverter) {
        super(hiveOpConverter);
    }

    @Override
    HiveOpConverter.OpAttr visit(HiveUnion unionRel) throws SemanticException {
        List<RelNode> inputsList = this.extractRelNodeFromUnion(unionRel);
        HiveOpConverter.OpAttr[] inputs = new HiveOpConverter.OpAttr[inputsList.size()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = this.hiveOpConverter.dispatch(inputsList.get(i));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + unionRel.getId() + ":" + unionRel.getRelTypeName() + " with row type: [" + unionRel.getRowType() + "]");
        }
        UnionDesc unionDesc = new UnionDesc();
        unionDesc.setNumInputs(inputs.length);
        String tableAlias = this.hiveOpConverter.getHiveDerivedTableAlias();
        ArrayList<ColumnInfo> cinfoLst = this.createColInfos((Operator)inputs[0].inputs.get(0), tableAlias);
        Operator[] children = new Operator[inputs.length];
        for (int i = 0; i < children.length; ++i) {
            if (i == 0) {
                children[i] = (Operator)inputs[i].inputs.get(0);
                continue;
            }
            Operator op = (Operator)inputs[i].inputs.get(0);
            children[i] = this.genInputSelectForUnion(op, cinfoLst);
        }
        Operator<UnionDesc> unionOp = OperatorFactory.getAndMakeChild(this.hiveOpConverter.getSemanticAnalyzer().getOpContext(), unionDesc, new RowSchema(cinfoLst), children);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + unionOp + " with row schema: [" + unionOp.getSchema() + "]");
        }
        return new HiveOpConverter.OpAttr(tableAlias, (Set<Integer>)inputs[0].vcolsInCalcite, unionOp);
    }

    private List<RelNode> extractRelNodeFromUnion(HiveUnion unionRel) {
        ArrayList<RelNode> ret = new ArrayList<RelNode>();
        for (RelNode input : unionRel.getInputs()) {
            if (input instanceof HiveUnion) {
                ret.addAll(this.extractRelNodeFromUnion((HiveUnion)input));
                continue;
            }
            ret.add(input);
        }
        return ret;
    }

    private ArrayList<ColumnInfo> createColInfos(Operator<?> input, String tableAlias) {
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            ColumnInfo copyOfColumnInfo = new ColumnInfo(ci);
            copyOfColumnInfo.setTabAlias(tableAlias);
            cInfoLst.add(copyOfColumnInfo);
        }
        return cInfoLst;
    }

    private Operator<? extends OperatorDesc> genInputSelectForUnion(Operator<? extends OperatorDesc> origInputOp, ArrayList<ColumnInfo> uColumnInfo) throws SemanticException {
        Iterator<ColumnInfo> oIter = origInputOp.getSchema().getSignature().iterator();
        Iterator<ColumnInfo> uIter = uColumnInfo.iterator();
        ArrayList<ExprNodeDesc> columns = new ArrayList<ExprNodeDesc>();
        ArrayList<String> colName = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        boolean needSelectOp = false;
        while (oIter.hasNext()) {
            ColumnInfo uInfo;
            ColumnInfo oInfo = oIter.next();
            if (!oInfo.isSameColumnForRR(uInfo = uIter.next())) {
                needSelectOp = true;
            }
            ExprNodeDesc column = new ExprNodeColumnDesc(oInfo.getType(), oInfo.getInternalName(), oInfo.getTabAlias(), oInfo.getIsVirtualCol(), oInfo.isSkewedCol());
            if (!oInfo.getType().equals((Object)uInfo.getType())) {
                column = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(column, (PrimitiveTypeInfo)uInfo.getType());
            }
            columns.add(column);
            colName.add(uInfo.getInternalName());
            columnExprMap.put(uInfo.getInternalName(), column);
        }
        if (needSelectOp) {
            return OperatorFactory.getAndMakeChild(new SelectDesc(columns, colName), new RowSchema(uColumnInfo), columnExprMap, origInputOp, new Operator[0]);
        }
        return origInputOp;
    }
}

