/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.correlation.AbstractCorrelationProcCtx;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationUtilities;
import org.apache.hadoop.hive.ql.optimizer.correlation.IntraQueryCorrelation;
import org.apache.hadoop.hive.ql.optimizer.correlation.QueryPlanTreeTransformation;
import org.apache.hadoop.hive.ql.optimizer.physical.CommonJoinTaskDispatcher;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrelationOptimizer
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger((String)CorrelationOptimizer.class.getName());
    private boolean abort = false;
    private ParseContext pCtx = null;
    private final Set<Operator<? extends OperatorDesc>> skipedJoinOperators = new HashSet<Operator<? extends OperatorDesc>>();

    private void findPossibleAutoConvertedJoinOperators() throws SemanticException {
        for (JoinOperator joinOp : this.pCtx.getJoinOps()) {
            boolean isAbleToGuess = true;
            boolean mayConvert = false;
            long aliasTotalKnownInputSize = 0L;
            HashMap<String, Long> aliasToSize = new HashMap<String, Long>();
            HashMap posToAliases = new HashMap();
            for (int pos = 0; pos < joinOp.getNumParent(); ++pos) {
                Operator<OperatorDesc> op = joinOp.getParentOperators().get(pos);
                Set<TableScanOperator> topOps = CorrelationUtilities.findTableScanOperators(op);
                if (topOps.isEmpty()) {
                    isAbleToGuess = false;
                    break;
                }
                LinkedHashSet<String> aliases = new LinkedHashSet<String>();
                for (TableScanOperator tsop : topOps) {
                    Table table = ((TableScanDesc)tsop.getConf()).getTableMetadata();
                    if (table == null) {
                        throw new SemanticException("The table of " + tsop.getName() + " " + tsop.getIdentifier() + " is null, which is not expected.");
                    }
                    String alias = ((TableScanDesc)tsop.getConf()).getAlias();
                    aliases.add(alias);
                    Path p = table.getPath();
                    ContentSummary resultCs = null;
                    try {
                        FileSystem fs = table.getPath().getFileSystem((Configuration)this.pCtx.getConf());
                        resultCs = fs.getContentSummary(p);
                    }
                    catch (IOException e) {
                        LOG.warn("Encounter a error while querying content summary of table " + table.getCompleteName() + " from FileSystem. Cannot guess if CommonJoinOperator will optimize " + joinOp.getName() + " " + joinOp.getIdentifier());
                    }
                    if (resultCs == null) {
                        isAbleToGuess = false;
                        break;
                    }
                    long size = resultCs.getLength();
                    aliasTotalKnownInputSize += size;
                    Long es = (Long)aliasToSize.get(alias);
                    if (es == null) {
                        es = 0L;
                    }
                    es = es + size;
                    aliasToSize.put(alias, es);
                }
                posToAliases.put(pos, aliases);
            }
            if (!isAbleToGuess) {
                LOG.info("Cannot guess if CommonJoinOperator will optimize " + joinOp.getName() + " " + joinOp.getIdentifier());
                continue;
            }
            JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
            Byte[] order = joinDesc.getTagOrder();
            int numAliases = order.length;
            Set<Integer> bigTableCandidates = MapJoinProcessor.getBigTableCandidates(joinDesc.getConds());
            if (bigTableCandidates.isEmpty()) continue;
            long ThresholdOfSmallTblSizeSum = HiveConf.getLongVar((Configuration)this.pCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SMALL_TABLES_FILESIZE);
            for (int i = 0; i < numAliases; ++i) {
                Set aliases;
                long aliasKnownSize;
                if (!bigTableCandidates.contains(i) || CommonJoinTaskDispatcher.cannotConvert(aliasKnownSize = Utilities.sumOf(aliasToSize, aliases = (Set)posToAliases.get(i)), aliasTotalKnownInputSize, ThresholdOfSmallTblSizeSum)) continue;
                mayConvert = true;
            }
            if (!mayConvert) continue;
            LOG.info(joinOp.getName() + " " + joinOp.getIdentifier() + " may be converted to MapJoin by CommonJoinResolver");
            this.skipedJoinOperators.add(joinOp);
        }
    }

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.pCtx = pctx;
        if (HiveConf.getBoolVar((Configuration)this.pCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CONVERT_JOIN)) {
            this.findPossibleAutoConvertedJoinOperators();
        }
        CorrelationNodeProcCtx corrCtx = new CorrelationNodeProcCtx(this.pCtx);
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        opRules.put(new RuleRegExp("R1", ReduceSinkOperator.getOperatorName() + "%"), new CorrelationNodeProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, corrCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        this.abort = corrCtx.isAbort();
        if (this.abort) {
            LOG.info("Abort. Reasons are ...");
            for (String reason : corrCtx.getAbortReasons()) {
                LOG.info("-- " + reason);
            }
        } else {
            LOG.info("Begin query plan transformation based on intra-query correlations. " + corrCtx.getCorrelations().size() + " correlation(s) to be applied");
            for (IntraQueryCorrelation correlation : corrCtx.getCorrelations()) {
                QueryPlanTreeTransformation.applyCorrelation(this.pCtx, corrCtx, correlation);
            }
        }
        return this.pCtx;
    }

    private SemanticNodeProcessor getDefaultProc() {
        return new SemanticNodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
                Operator op = (Operator)nd;
                LOG.info("Walk to operator " + op.getIdentifier() + " " + op.getName() + ". No actual work to do");
                CorrelationNodeProcCtx correlationCtx = (CorrelationNodeProcCtx)ctx;
                if (op.getName().equals(MapJoinOperator.getOperatorName())) {
                    correlationCtx.setAbort(true);
                    correlationCtx.getAbortReasons().add("Found MAPJOIN");
                }
                if (op.getName().equals(FileSinkOperator.getOperatorName())) {
                    correlationCtx.incrementFileSinkOperatorCount();
                }
                return null;
            }
        };
    }

    protected class CorrelationNodeProcCtx
    extends AbstractCorrelationProcCtx {
        private boolean abort;
        private final List<String> abortReasons;
        private final Set<ReduceSinkOperator> walked;
        private final List<IntraQueryCorrelation> correlations;
        private int fileSinkOperatorCount;

        public CorrelationNodeProcCtx(ParseContext pctx) {
            super(pctx);
            this.walked = new HashSet<ReduceSinkOperator>();
            this.correlations = new ArrayList<IntraQueryCorrelation>();
            this.abort = false;
            this.abortReasons = new ArrayList<String>();
            this.fileSinkOperatorCount = 0;
        }

        public void setAbort(boolean abort) {
            this.abort = abort;
        }

        public boolean isAbort() {
            return this.abort;
        }

        public List<String> getAbortReasons() {
            return this.abortReasons;
        }

        public void addCorrelation(IntraQueryCorrelation correlation) {
            this.correlations.add(correlation);
        }

        public List<IntraQueryCorrelation> getCorrelations() {
            return this.correlations;
        }

        public boolean isWalked(ReduceSinkOperator op) {
            return this.walked.contains(op);
        }

        public void addWalked(ReduceSinkOperator op) {
            this.walked.add(op);
        }

        public void addWalkedAll(Collection<ReduceSinkOperator> c) {
            this.walked.addAll(c);
        }

        public void removeWalked(ReduceSinkOperator op) {
            this.walked.remove(op);
        }

        public void removeWalkedAll(Collection<ReduceSinkOperator> c) {
            this.walked.removeAll(c);
        }

        public void incrementFileSinkOperatorCount() {
            ++this.fileSinkOperatorCount;
            if (this.fileSinkOperatorCount == 2) {
                this.abort = true;
                this.abortReasons.add("-- Currently, a query with multiple FileSinkOperators are not supported.");
            }
        }
    }

    private class CorrelationNodeProc
    implements SemanticNodeProcessor {
        private CorrelationNodeProc() {
        }

        private void analyzeReduceSinkOperatorsOfJoinOperator(JoinCondDesc[] joinConds, List<Operator<? extends OperatorDesc>> rsOps, Operator<? extends OperatorDesc> currentRsOp, Set<ReduceSinkOperator> correlatedRsOps) {
            if (correlatedRsOps.contains(currentRsOp)) {
                return;
            }
            correlatedRsOps.add((ReduceSinkOperator)currentRsOp);
            int pos = rsOps.indexOf(currentRsOp);
            for (int i = 0; i < joinConds.length; ++i) {
                Operator<? extends OperatorDesc> newCurrentRsOps;
                JoinCondDesc joinCond = joinConds[i];
                int type = joinCond.getType();
                if (pos == joinCond.getLeft()) {
                    if (type != 0 && type != 1 && type != 5 && type != 6) continue;
                    newCurrentRsOps = rsOps.get(joinCond.getRight());
                    this.analyzeReduceSinkOperatorsOfJoinOperator(joinConds, rsOps, newCurrentRsOps, correlatedRsOps);
                    continue;
                }
                if (pos != joinCond.getRight() || type != 0 && type != 2) continue;
                newCurrentRsOps = rsOps.get(joinCond.getLeft());
                this.analyzeReduceSinkOperatorsOfJoinOperator(joinConds, rsOps, newCurrentRsOps, correlatedRsOps);
            }
        }

        private boolean sameKeys(List<ExprNodeDesc> k1, List<ExprNodeDesc> k2) {
            if (k1.size() != k2.size()) {
                return false;
            }
            for (int i = 0; i < k1.size(); ++i) {
                ExprNodeDesc expr1 = k1.get(i);
                ExprNodeDesc expr2 = k2.get(i);
                if (expr1 == null) {
                    if (expr2 == null) continue;
                    return false;
                }
                if (expr1.isSame(expr2)) continue;
                return false;
            }
            return true;
        }

        private boolean sameOrder(String order1, String order2) {
            if (order1 == null || order1.trim().equals("")) {
                return order2 == null || order2.trim().equals("");
            }
            if (order2 == null || order2.trim().equals("")) {
                return false;
            }
            return (order1 = order1.trim()).equals(order2 = order2.trim());
        }

        private LinkedHashSet<ReduceSinkOperator> findCorrelatedReduceSinkOperators(Operator<? extends OperatorDesc> child, List<ExprNodeDesc> childKeyCols, List<ExprNodeDesc> childPartitionCols, String childRSOrder, Operator<? extends OperatorDesc> current, IntraQueryCorrelation correlation) throws SemanticException {
            LOG.info("now detecting operator " + current.getIdentifier() + " " + current.getName());
            LinkedHashSet<ReduceSinkOperator> correlatedReduceSinkOperators = new LinkedHashSet<ReduceSinkOperator>();
            if (CorrelationOptimizer.this.skipedJoinOperators.contains(current)) {
                LOG.info(current.getName() + " " + current.getIdentifier() + " may be converted to MapJoin by CommonJoinResolver. Correlation optimizer will not detect correlationsinvolved in this operator");
                return correlatedReduceSinkOperators;
            }
            if (current.getParentOperators() == null || current.getParentOperators().isEmpty()) {
                return correlatedReduceSinkOperators;
            }
            if (current instanceof PTFOperator) {
                LOG.info("Currently, correlation optimizer does not support PTF operator.");
                return correlatedReduceSinkOperators;
            }
            if (current instanceof UnionOperator) {
                LinkedHashSet<ReduceSinkOperator> corrRSs = new LinkedHashSet<ReduceSinkOperator>();
                for (Operator<OperatorDesc> parent : current.getParentOperators()) {
                    LinkedHashSet<ReduceSinkOperator> tmp = this.findCorrelatedReduceSinkOperators(current, childKeyCols, childPartitionCols, childRSOrder, parent, correlation);
                    if (tmp != null && tmp.size() > 0) {
                        corrRSs.addAll(tmp);
                        continue;
                    }
                    return correlatedReduceSinkOperators;
                }
                correlatedReduceSinkOperators.addAll(corrRSs);
                UnionOperator union = (UnionOperator)current;
                ((UnionDesc)union.getConf()).setAllInputsInSameReducer(true);
            } else if (current.getColumnExprMap() == null && !(current instanceof ReduceSinkOperator)) {
                for (Operator<OperatorDesc> parent : current.getParentOperators()) {
                    correlatedReduceSinkOperators.addAll(this.findCorrelatedReduceSinkOperators(current, childKeyCols, childPartitionCols, childRSOrder, parent, correlation));
                }
            } else if (current.getColumnExprMap() != null && !(current instanceof ReduceSinkOperator)) {
                ArrayList<ExprNodeDesc> backtrackedKeyCols = ExprNodeDescUtils.backtrack(childKeyCols, child, current);
                ArrayList<ExprNodeDesc> backtrackedPartitionCols = ExprNodeDescUtils.backtrack(childPartitionCols, child, current);
                RowSchema rowSchema = current.getSchema();
                HashSet<String> tableNeedToCheck = new HashSet<String>();
                for (ExprNodeDesc expr : childKeyCols) {
                    if (!(expr instanceof ExprNodeColumnDesc)) {
                        return correlatedReduceSinkOperators;
                    }
                    String colName = ((ExprNodeColumnDesc)expr).getColumn();
                    ColumnInfo columnInfo = rowSchema.getColumnInfo(colName);
                    if (columnInfo == null) continue;
                    tableNeedToCheck.add(columnInfo.getTabAlias());
                }
                if (current instanceof JoinOperator) {
                    boolean isCorrelated = true;
                    int expectedNumCorrelatedRsops = current.getParentOperators().size();
                    LinkedHashSet<ReduceSinkOperator> correlatedRsops = null;
                    for (Operator operator : current.getParentOperators()) {
                        Set<String> tableNames = operator.getSchema().getTableNames();
                        for (String tbl : tableNames) {
                            if (!tableNeedToCheck.contains(tbl) || (correlatedRsops = this.findCorrelatedReduceSinkOperators(current, backtrackedKeyCols, backtrackedPartitionCols, childRSOrder, operator, correlation)).size() == expectedNumCorrelatedRsops) continue;
                            isCorrelated = false;
                        }
                        if (isCorrelated) continue;
                        break;
                    }
                    if (isCorrelated && correlatedRsops != null) {
                        correlatedReduceSinkOperators.addAll(correlatedRsops);
                    } else {
                        correlatedReduceSinkOperators.clear();
                    }
                } else {
                    for (Operator<OperatorDesc> parent : current.getParentOperators()) {
                        correlatedReduceSinkOperators.addAll(this.findCorrelatedReduceSinkOperators(current, backtrackedKeyCols, backtrackedPartitionCols, childRSOrder, parent, correlation));
                    }
                }
            } else if (current.getColumnExprMap() != null && current instanceof ReduceSinkOperator) {
                ReduceSinkOperator rsop = (ReduceSinkOperator)current;
                ArrayList<ExprNodeDesc> backtrackedKeyCols = ExprNodeDescUtils.backtrack(childKeyCols, child, current);
                ArrayList<ExprNodeDesc> backtrackedPartitionCols = ExprNodeDescUtils.backtrack(childPartitionCols, child, current);
                List<ExprNodeDesc> rsKeyCols = ((ReduceSinkDesc)rsop.getConf()).getKeyCols();
                List<ExprNodeDesc> rsPartitionCols = ((ReduceSinkDesc)rsop.getConf()).getPartitionCols();
                boolean isCorrelated = this.sameKeys(rsKeyCols, backtrackedKeyCols) && this.sameOrder(((ReduceSinkDesc)rsop.getConf()).getOrder(), childRSOrder) && this.sameKeys(backtrackedPartitionCols, rsPartitionCols) && correlation.adjustNumReducers(((ReduceSinkDesc)rsop.getConf()).getNumReducers());
                GroupByOperator cGBY = CorrelationUtilities.getSingleChild(rsop, GroupByOperator.class);
                if (cGBY != null && (CorrelationUtilities.hasGroupingSet(rsop) || ((GroupByDesc)cGBY.getConf()).isGroupingSetsPresent())) {
                    isCorrelated = false;
                }
                if (isCorrelated) {
                    LOG.info("Operator " + current.getIdentifier() + " " + current.getName() + " is correlated");
                    Operator<?> childOperator = CorrelationUtilities.getSingleChild(current, true);
                    if (childOperator instanceof JoinOperator) {
                        JoinOperator joinOperator = (JoinOperator)childOperator;
                        JoinCondDesc[] joinConds = ((JoinDesc)joinOperator.getConf()).getConds();
                        List<Operator<? extends OperatorDesc>> rsOps = joinOperator.getParentOperators();
                        LinkedHashSet<ReduceSinkOperator> correlatedRsOps = new LinkedHashSet<ReduceSinkOperator>();
                        this.analyzeReduceSinkOperatorsOfJoinOperator(joinConds, rsOps, current, correlatedRsOps);
                        correlatedReduceSinkOperators.addAll(correlatedRsOps);
                    } else {
                        correlatedReduceSinkOperators.add(rsop);
                    }
                } else {
                    LOG.info("Operator " + current.getIdentifier() + " " + current.getName() + " is not correlated");
                    correlatedReduceSinkOperators.clear();
                }
            } else {
                LOG.error("ReduceSinkOperator " + current.getIdentifier() + " does not have ColumnExprMap");
                throw new SemanticException("CorrelationOptimizer cannot optimize this plan. ReduceSinkOperator " + current.getIdentifier() + " does not have ColumnExprMap");
            }
            return correlatedReduceSinkOperators;
        }

        private LinkedHashSet<ReduceSinkOperator> exploitJobFlowCorrelation(ReduceSinkOperator op, CorrelationNodeProcCtx correlationCtx, IntraQueryCorrelation correlation) throws SemanticException {
            correlationCtx.addWalked(op);
            correlation.addToAllReduceSinkOperators(op);
            boolean shouldDetect = true;
            LinkedHashSet<ReduceSinkOperator> reduceSinkOperators = new LinkedHashSet<ReduceSinkOperator>();
            List<ExprNodeDesc> keyCols = ((ReduceSinkDesc)op.getConf()).getKeyCols();
            List<ExprNodeDesc> partitionCols = ((ReduceSinkDesc)op.getConf()).getPartitionCols();
            for (ExprNodeDesc key : keyCols) {
                if (key instanceof ExprNodeColumnDesc) continue;
                shouldDetect = false;
            }
            for (ExprNodeDesc key : partitionCols) {
                if (key instanceof ExprNodeColumnDesc) continue;
                shouldDetect = false;
            }
            GroupByOperator cGBY = CorrelationUtilities.getSingleChild(op, GroupByOperator.class);
            if (cGBY != null && (CorrelationUtilities.hasGroupingSet(op) || ((GroupByDesc)cGBY.getConf()).isGroupingSetsPresent())) {
                shouldDetect = false;
            }
            if (shouldDetect) {
                LinkedHashSet<ReduceSinkOperator> newReduceSinkOperators = new LinkedHashSet<ReduceSinkOperator>();
                String sortOrder = ((ReduceSinkDesc)op.getConf()).getOrder();
                for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                    LOG.info("Operator " + op.getIdentifier() + ": start detecting correlation from this operator");
                    LinkedHashSet<ReduceSinkOperator> correlatedReduceSinkOperators = this.findCorrelatedReduceSinkOperators(op, keyCols, partitionCols, sortOrder, parent, correlation);
                    if (correlatedReduceSinkOperators.size() == 0) {
                        newReduceSinkOperators.add(op);
                        continue;
                    }
                    for (ReduceSinkOperator rsop : correlatedReduceSinkOperators) {
                        LinkedHashSet<ReduceSinkOperator> exploited = this.exploitJobFlowCorrelation(rsop, correlationCtx, correlation);
                        if (exploited.size() == 0) {
                            newReduceSinkOperators.add(rsop);
                            continue;
                        }
                        newReduceSinkOperators.addAll(exploited);
                    }
                }
                reduceSinkOperators.addAll(newReduceSinkOperators);
            }
            return reduceSinkOperators;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            CorrelationNodeProcCtx corrCtx = (CorrelationNodeProcCtx)ctx;
            ReduceSinkOperator op = (ReduceSinkOperator)nd;
            if (corrCtx.isWalked(op)) {
                return null;
            }
            LOG.info("Walk to operator " + op.getIdentifier() + " " + op.getName());
            Operator<?> child = CorrelationUtilities.getSingleChild(op, true);
            if (!(child instanceof JoinOperator) && !(child instanceof GroupByOperator)) {
                corrCtx.addWalked(op);
                return null;
            }
            IntraQueryCorrelation correlation = new IntraQueryCorrelation(corrCtx.minReducer());
            List<ReduceSinkOperator> topReduceSinkOperators = CorrelationUtilities.findSiblingReduceSinkOperators(op);
            ArrayList<ReduceSinkOperator> bottomReduceSinkOperators = new ArrayList<ReduceSinkOperator>();
            for (ReduceSinkOperator rsop : topReduceSinkOperators) {
                if (correlation.adjustNumReducers(((ReduceSinkDesc)rsop.getConf()).getNumReducers())) continue;
                corrCtx.addWalked(op);
                return null;
            }
            for (ReduceSinkOperator rsop : topReduceSinkOperators) {
                LinkedHashSet<ReduceSinkOperator> thisBottomReduceSinkOperators = this.exploitJobFlowCorrelation(rsop, corrCtx, correlation);
                if (thisBottomReduceSinkOperators.size() == 0) {
                    thisBottomReduceSinkOperators.add(rsop);
                }
                bottomReduceSinkOperators.addAll(thisBottomReduceSinkOperators);
            }
            if (!topReduceSinkOperators.containsAll(bottomReduceSinkOperators)) {
                LOG.info("has job flow correlation");
                correlation.setJobFlowCorrelation(true, bottomReduceSinkOperators);
            }
            if (correlation.hasJobFlowCorrelation()) {
                corrCtx.addCorrelation(correlation);
            } else {
                corrCtx.removeWalkedAll(correlation.getAllReduceSinkOperators());
            }
            corrCtx.addWalked(op);
            return null;
        }
    }
}

