/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheTableHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(CacheTableHelper.class);
    private static final Cache<String, Set<String>> underlyingTableHints = Caffeine.newBuilder().maximumSize(10000L).build();

    public void populateCache(List<Pair<String, String>> tables, HiveConf conf, HiveTxnManager txnMgr) {
        if (txnMgr == null || !txnMgr.isTxnOpen()) {
            return;
        }
        ArrayList<String> fullTableNamesList = new ArrayList<String>(this.getAllUniqueViewsAndTables(tables));
        LOG.debug("Populating query cache");
        for (String s : fullTableNamesList) {
            LOG.debug("Populating table " + s);
        }
        String validTxnList = conf.get("hive.txn.valid.txns");
        try {
            txnMgr.getValidWriteIds(fullTableNamesList, validTxnList);
        }
        catch (Exception e) {
            LOG.info("Population of valid write id list cache failed, will be done later in query.");
        }
    }

    public void populateCacheForView(List<Pair<String, String>> tables, HiveConf conf, HiveTxnManager txnMgr, String dbName, String viewName) {
        if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_VIEW_CACHE_ENABLED)) {
            return;
        }
        String completeViewName = dbName + "." + viewName;
        LOG.debug("Found view while parsing: " + completeViewName);
        Set<String> underlyingTablesAndViews = CacheTableHelper.getUniqueNames(tables);
        if (underlyingTablesAndViews.equals(underlyingTableHints.getIfPresent((Object)completeViewName))) {
            LOG.debug("View already cached.");
            return;
        }
        this.populateCache(tables, conf, txnMgr);
        underlyingTableHints.put((Object)completeViewName, underlyingTablesAndViews);
    }

    private Set<String> getAllUniqueViewsAndTables(List<Pair<String, String>> tables) {
        HashSet<String> fullTableNames = new HashSet<String>();
        LinkedList<Pair<String, String>> queue = new LinkedList<Pair<String, String>>(tables);
        LOG.debug("Getting all tables.");
        while (queue.peek() != null) {
            String tableOrView = CacheTableHelper.getTableName((Pair<String, String>)((Pair)queue.remove()));
            LOG.debug("Getting table " + tableOrView);
            Set underlyingTables = (Set)underlyingTableHints.getIfPresent((Object)tableOrView);
            if (underlyingTables != null) {
                if (fullTableNames.contains(tableOrView)) continue;
                LOG.debug("View in cache, adding its tables to queue.");
                for (String viewTable : underlyingTables) {
                    LOG.debug("View table is " + viewTable);
                    String[] dbTableArray = viewTable.split("\\.");
                    Preconditions.checkNotNull((Object)dbTableArray[0]);
                    Preconditions.checkNotNull((Object)dbTableArray[1]);
                    queue.offer((Pair<String, String>)new ImmutablePair((Object)dbTableArray[0], (Object)dbTableArray[1]));
                }
            }
            fullTableNames.add(tableOrView);
        }
        return fullTableNames;
    }

    public static Set<String> getUniqueNames(List<Pair<String, String>> tables) {
        HashSet<String> names = new HashSet<String>();
        for (Pair<String, String> table : tables) {
            names.add(CacheTableHelper.getTableName(table));
        }
        return names;
    }

    private static String getTableName(Pair<String, String> dbTablePair) {
        String dbName = dbTablePair.getLeft() == null ? SessionState.get().getCurrentDatabase() : (String)dbTablePair.getLeft();
        return dbName + "." + (String)dbTablePair.getRight();
    }
}

