/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.execute.AlterTableExecuteDesc;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTableExecuteSpec;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.RewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.DeleteStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.RewriterFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class DeleteSemanticAnalyzer
extends RewriteSemanticAnalyzer<DeleteStatement> {
    private DDLDesc.DDLDescWithWriteId acidDdlDesc;

    public DeleteSemanticAnalyzer(QueryState queryState, RewriterFactory<DeleteStatement> rewriterFactory) throws SemanticException {
        super(queryState, rewriterFactory);
        queryState.setSqlKind(SqlKind.DELETE);
    }

    @Override
    protected ASTNode getTargetTableNode(ASTNode tree) {
        ASTNode tabName = (ASTNode)tree.getChild(0);
        assert (tabName.getToken().getType() == 1273) : "Expected tablename as first child of " + Context.Operation.DELETE + " but found " + tabName.getName();
        return tabName;
    }

    @Override
    protected void analyze(ASTNode tree, Table table, ASTNode tableName) throws SemanticException {
        boolean shouldTruncate;
        List children = tree.getChildren();
        ASTNode where = null;
        if (children.size() > 1) {
            where = (ASTNode)children.get(1);
            assert (where.getToken().getType() == 1316) : "Expected where clause, but found " + where.getName();
        }
        boolean bl = shouldTruncate = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_REPLACE_DELETE_WITH_TRUNCATE) && where == null;
        if (shouldTruncate) {
            this.genTruncatePlan(table, tableName);
            return;
        }
        if (this.tryMetadataUpdate(table, tableName, where)) {
            return;
        }
        this.rewriteAndAnalyze(new DeleteStatement(table, where), null);
        this.updateOutputs(table);
    }

    private void genTruncatePlan(Table table, ASTNode tabNameNode) throws SemanticException {
        String rewrittenQueryStr = "truncate " + this.getFullTableNameForSQL(tabNameNode);
        ParseUtils.ReparseResult rr = ParseUtils.parseRewrittenQuery(this.ctx, rewrittenQueryStr);
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        BaseSemanticAnalyzer truncate = SemanticAnalyzerFactory.get(this.queryState, rewrittenTree);
        rewrittenCtx.setEnableUnparse(false);
        truncate.analyze(rewrittenTree, rewrittenCtx);
        this.acidDdlDesc = truncate.getAcidDdlDesc();
        this.rootTasks = truncate.getRootTasks();
        this.outputs = truncate.getOutputs();
        this.updateOutputs(table);
    }

    private boolean tryMetadataUpdate(Table table, ASTNode tabNameNode, ASTNode whereNode) throws SemanticException {
        ASTNode rewrittenTree;
        if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_METADATA_DELETE)) {
            return false;
        }
        if (whereNode == null || table.getStorageHandler() == null) {
            return false;
        }
        TableName tableName = DeleteSemanticAnalyzer.getQualifiedTableName(tabNameNode);
        String whereClause = this.ctx.getTokenRewriteStream().toString(whereNode.getChild(0).getTokenStartIndex(), whereNode.getChild(0).getTokenStopIndex());
        StringBuilder sb = new StringBuilder("select * from ").append(this.getFullTableNameForSQL(tabNameNode)).append(" where ").append(whereClause);
        Context context = new Context((Configuration)this.conf);
        try {
            rewrittenTree = ParseUtils.parse(sb.toString(), context);
        }
        catch (ParseException pe) {
            throw new SemanticException((Throwable)pe);
        }
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.queryState, rewrittenTree);
        sem.analyze(rewrittenTree, context);
        SearchArgument sarg = this.convertFilterExpressionInTS(table, sem);
        if (sarg == null) {
            return false;
        }
        if (!table.getStorageHandler().canPerformMetadataDelete(table, tableName.getTableMetaRef(), sarg)) {
            return false;
        }
        DDLWork ddlWork = this.createDDLWorkOfMetadataUpdate(tableName, sarg);
        this.rootTasks = Collections.singletonList(TaskFactory.get(ddlWork));
        this.inputs = sem.getInputs();
        this.outputs = sem.getOutputs();
        this.updateOutputs(table);
        return true;
    }

    private SearchArgument convertFilterExpressionInTS(Table table, BaseSemanticAnalyzer sem) {
        Map<String, TableScanOperator> topOps = sem.getParseContext().getTopOps();
        if (!topOps.containsKey(table.getTableName())) {
            return null;
        }
        ExprNodeGenericFuncDesc hiveFilter = ((TableScanDesc)topOps.get(table.getTableName()).getConf()).getFilterExpr();
        if (hiveFilter == null) {
            return null;
        }
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument(this.ctx.getConf(), hiveFilter);
        if (result.isPartial()) {
            return null;
        }
        return result.getSearchArgument();
    }

    private DDLWork createDDLWorkOfMetadataUpdate(TableName tableName, SearchArgument sarg) throws SemanticException {
        AlterTableExecuteSpec.DeleteMetadataSpec deleteMetadataSpec = new AlterTableExecuteSpec.DeleteMetadataSpec(tableName.getTableMetaRef(), sarg);
        AlterTableExecuteSpec<AlterTableExecuteSpec.DeleteMetadataSpec> executeSpec = new AlterTableExecuteSpec<AlterTableExecuteSpec.DeleteMetadataSpec>(AlterTableExecuteSpec.ExecuteOperationType.DELETE_METADATA, deleteMetadataSpec);
        AlterTableExecuteDesc desc = new AlterTableExecuteDesc(tableName, null, executeSpec);
        return new DDLWork(this.getInputs(), this.getOutputs(), desc);
    }

    @Override
    protected boolean enableColumnStatsCollecting() {
        return false;
    }

    @Override
    public DDLDesc.DDLDescWithWriteId getAcidDdlDesc() {
        return this.acidDdlDesc;
    }
}

