/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.TransformSpec;

public class PartitionTransform {
    private static final Map<Integer, TransformSpec.TransformType> TRANSFORMS = Stream.of({1049, TransformSpec.TransformType.IDENTITY}, {1324, TransformSpec.TransformType.YEAR}, {1093, TransformSpec.TransformType.MONTH}, {979, TransformSpec.TransformType.DAY}, {1048, TransformSpec.TransformType.HOUR}, {1290, TransformSpec.TransformType.TRUNCATE}, {931, TransformSpec.TransformType.BUCKET}).collect(Collectors.toMap(e -> (Integer)e[0], e -> (TransformSpec.TransformType)((Object)((Object)e[1]))));

    public static List<TransformSpec> getPartitionTransformSpec(List<FieldSchema> fields) {
        return fields.stream().map(field -> new TransformSpec(field.getName(), TransformSpec.TransformType.IDENTITY, Optional.empty())).collect(Collectors.toList());
    }

    public static List<TransformSpec> getPartitionTransformSpec(ASTNode node) {
        ArrayList<TransformSpec> partSpecList = new ArrayList<TransformSpec>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            TransformSpec spec = new TransformSpec();
            ASTNode child = (ASTNode)node.getChild(i);
            block5: for (int j = 0; j < child.getChildCount(); ++j) {
                ASTNode grandChild = (ASTNode)child.getChild(j);
                switch (grandChild.getToken().getType()) {
                    case 979: 
                    case 1048: 
                    case 1049: 
                    case 1093: 
                    case 1324: {
                        spec.setColumnName(grandChild.getChild(0).getText().toLowerCase());
                        spec.setTransformType(TRANSFORMS.get(grandChild.getToken().getType()));
                        continue block5;
                    }
                    case 931: 
                    case 1290: {
                        spec.setTransformType(TRANSFORMS.get(grandChild.getToken().getType()));
                        spec.setTransformParam(Optional.of(Integer.valueOf(grandChild.getChild(0).getText())));
                        spec.setColumnName(grandChild.getChild(1).getText().toLowerCase());
                    }
                }
            }
            partSpecList.add(spec);
        }
        return partSpecList;
    }
}

