/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ParsedQueryTables;

public class QueryTables
implements ParsedQueryTables {
    private final Map<String, Table> tableObjects = new HashMap<String, Table>();
    private Map<String, Table> parsedTableObjects;

    public QueryTables(boolean isEmptyMap) {
        if (isEmptyMap) {
            this.markParsingCompleted();
        }
    }

    public QueryTables() {
        this(false);
    }

    public boolean containsKey(String name) {
        return this.tableObjects.containsKey(name);
    }

    public void put(String name, Table table) {
        this.tableObjects.put(name, table);
    }

    public void markParsingCompleted() {
        this.parsedTableObjects = ImmutableMap.copyOf(this.tableObjects);
    }

    public Table get(String name) {
        return this.tableObjects.get(name);
    }

    @Override
    public Table getParsedTable(String name) {
        if (this.parsedTableObjects == null) {
            throw new RuntimeException("Cannot call getParsedTable() until parsing is marked completed.");
        }
        return this.parsedTableObjects.get(name);
    }
}

