/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateMaterializedViewDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.LoadDesc;

public class LoadFileDesc
extends LoadDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Path targetDir;
    private boolean isDfsDir;
    private String columns;
    private String columnTypes;
    private transient CreateTableDesc ctasCreateTableDesc;
    private transient CreateMaterializedViewDesc createViewDesc;
    private boolean isMmCtas;
    private String moveTaskId;

    public LoadFileDesc(LoadFileDesc o) {
        super(o.getSourcePath(), o.getWriteType());
        this.targetDir = o.targetDir;
        this.isDfsDir = o.isDfsDir;
        this.columns = o.columns;
        this.columnTypes = o.columnTypes;
        this.isMmCtas = o.isMmCtas;
        this.ctasCreateTableDesc = o.ctasCreateTableDesc;
        this.createViewDesc = o.createViewDesc;
    }

    public LoadFileDesc(CreateTableDesc createTableDesc, CreateMaterializedViewDesc createViewDesc, Path sourcePath, Path targetDir, boolean isDfsDir, String columns, String columnTypes, AcidUtils.Operation writeType, boolean isMmCtas) {
        this(sourcePath, targetDir, isDfsDir, columns, columnTypes, writeType, isMmCtas);
        if (createTableDesc != null && createTableDesc.isCTAS()) {
            this.ctasCreateTableDesc = createTableDesc;
        }
        if (createViewDesc != null) {
            this.createViewDesc = createViewDesc;
        }
    }

    public LoadFileDesc(Path sourcePath, Path targetDir, boolean isDfsDir, String columns, String columnTypes, boolean isMmCtas) {
        this(sourcePath, targetDir, isDfsDir, columns, columnTypes, AcidUtils.Operation.NOT_ACID, isMmCtas);
    }

    private LoadFileDesc(Path sourcePath, Path targetDir, boolean isDfsDir, String columns, String columnTypes, AcidUtils.Operation writeType, boolean isMmCtas) {
        super(sourcePath, writeType);
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("creating LFD from " + sourcePath + " to " + targetDir);
        }
        this.targetDir = targetDir;
        this.isDfsDir = isDfsDir;
        this.columns = columns;
        this.columnTypes = columnTypes;
        this.isMmCtas = isMmCtas;
    }

    @Explain(displayName="destination")
    public Path getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(Path targetDir) {
        this.targetDir = targetDir;
    }

    @Explain(displayName="hdfs directory")
    public boolean getIsDfsDir() {
        return this.isDfsDir;
    }

    public void setIsDfsDir(boolean isDfsDir) {
        this.isDfsDir = isDfsDir;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getColumnTypes() {
        return this.columnTypes;
    }

    public void setColumnTypes(String columnTypes) {
        this.columnTypes = columnTypes;
    }

    public CreateTableDesc getCtasCreateTableDesc() {
        return this.ctasCreateTableDesc;
    }

    public CreateMaterializedViewDesc getCreateViewDesc() {
        return this.createViewDesc;
    }

    public boolean isMmCtas() {
        return this.isMmCtas;
    }

    public String getMoveTaskId() {
        return this.moveTaskId;
    }

    public void setMoveTaskId(String moveTaskId) {
        this.moveTaskId = moveTaskId;
    }
}

