/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.ql.plan.CustomBucketFunction;

public class OpTraits {
    private final List<List<String>> bucketColNames;
    private final List<CustomBucketFunction> customBucketFunctions;
    private List<List<String>> sortColNames;
    private int numBuckets;
    private int numReduceSinks;

    public OpTraits(List<List<String>> bucketColNames, List<CustomBucketFunction> customBucketFunctions, int numBuckets, List<List<String>> sortColNames, int numReduceSinks) {
        if (bucketColNames == null) {
            Preconditions.checkArgument((customBucketFunctions == null ? 1 : 0) != 0);
        } else {
            Preconditions.checkArgument((bucketColNames.size() == customBucketFunctions.size() ? 1 : 0) != 0);
        }
        this.bucketColNames = bucketColNames;
        this.customBucketFunctions = customBucketFunctions;
        this.numBuckets = numBuckets;
        this.sortColNames = sortColNames;
        this.numReduceSinks = numReduceSinks;
    }

    public List<List<String>> getBucketColNames() {
        return this.bucketColNames;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    public void setSortColNames(List<List<String>> sortColNames) {
        this.sortColNames = sortColNames;
    }

    public List<List<String>> getSortCols() {
        return this.sortColNames;
    }

    public List<CustomBucketFunction> getCustomBucketFunctions() {
        return this.customBucketFunctions;
    }

    public boolean hasCustomBucketFunction() {
        return this.customBucketFunctions != null && this.customBucketFunctions.stream().anyMatch(Objects::nonNull);
    }

    public void setNumReduceSinks(int numReduceSinks) {
        this.numReduceSinks = numReduceSinks;
    }

    public int getNumReduceSinks() {
        return this.numReduceSinks;
    }

    public String toString() {
        return "{ bucket column names: " + this.bucketColNames + "; custom partition functions: " + this.customBucketFunctions + "; sort column names: " + this.sortColNames + "; bucket count: " + this.numBuckets + "; num reduce sinks: " + this.numReduceSinks + "}";
    }
}

