/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.common.util.ReflectionUtil;

public class TableDesc
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Class<? extends InputFormat> inputFileFormatClass;
    private Class<? extends OutputFormat> outputFileFormatClass;
    private Properties properties;
    private Map<String, String> jobProperties;
    private Map<String, String> jobSecrets;
    public static final String SECRET_PREFIX = "TABLE_SECRET";
    public static final String SECRET_DELIMIT = "#";

    public TableDesc() {
    }

    public TableDesc(Class<? extends InputFormat> inputFormatClass, Class<?> outputFormatClass, Properties properties) {
        this.inputFileFormatClass = inputFormatClass;
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFormatClass);
        this.setProperties(properties);
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        try {
            return Class.forName(this.getSerdeClassName(), true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends InputFormat> getInputFileFormatClass() {
        return this.inputFileFormatClass;
    }

    public AbstractSerDe getSerDe() throws Exception {
        return this.getDeserializer(null);
    }

    public AbstractSerDe getDeserializer(Configuration conf) throws Exception {
        return this.getSerDe(conf, false);
    }

    public AbstractSerDe getSerDe(Configuration conf, boolean ignoreError) throws Exception {
        AbstractSerDe de;
        block2: {
            de = (AbstractSerDe)ReflectionUtil.newInstance(this.getSerDeClass().asSubclass(AbstractSerDe.class), (Configuration)conf);
            try {
                de.initialize(conf, this.properties, null);
            }
            catch (SerDeException sde) {
                if (ignoreError) break block2;
                throw sde;
            }
        }
        return de;
    }

    public void setInputFileFormatClass(Class<? extends InputFormat> inputFileFormatClass) {
        this.inputFileFormatClass = inputFileFormatClass;
    }

    public Class<? extends OutputFormat> getOutputFileFormatClass() {
        return this.outputFileFormatClass;
    }

    public void setOutputFileFormatClass(Class<?> outputFileFormatClass) {
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFileFormatClass);
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Explain(displayName="properties", explainLevels={Explain.Level.EXTENDED})
    public Map getPropertiesExplain() {
        return PlanUtils.getPropertiesForExplain(this.getProperties());
    }

    public void setProperties(Properties properties) {
        StringInternUtils.internValuesInMap((Map)properties);
        this.properties = properties;
    }

    public void setJobProperties(Map<String, String> jobProperties) {
        this.jobProperties = jobProperties;
    }

    @Explain(displayName="jobProperties", explainLevels={Explain.Level.EXTENDED})
    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    public void setJobSecrets(Map<String, String> jobSecrets) {
        this.jobSecrets = jobSecrets;
    }

    public Map<String, String> getJobSecrets() {
        return this.jobSecrets;
    }

    @Explain(displayName="serde")
    public String getSerdeClassName() {
        return this.properties.getProperty("serialization.lib");
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.properties.getProperty("name");
    }

    public String getFullTableName() {
        String tableName = this.getTableName();
        String metaTable = this.properties.getProperty("metaTable");
        if (metaTable != null && tableName != null) {
            return tableName + "." + metaTable;
        }
        return tableName;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbName() {
        return this.properties.getProperty("db");
    }

    @Explain(displayName="input format")
    public String getInputFileFormatClassName() {
        return this.getInputFileFormatClass().getName();
    }

    @Explain(displayName="output format")
    public String getOutputFileFormatClassName() {
        return this.getOutputFileFormatClass().getName();
    }

    public boolean isNonNative() {
        return this.properties.getProperty("storage_handler") != null;
    }

    public boolean isSetBucketingVersion() {
        return this.properties.getProperty("bucketing_version") != null;
    }

    public int getBucketingVersion() {
        return Utilities.getBucketingVersion(this.properties.getProperty("bucketing_version"));
    }

    public Object clone() {
        TableDesc ret = new TableDesc();
        ret.setInputFileFormatClass(this.inputFileFormatClass);
        ret.setOutputFileFormatClass(this.outputFileFormatClass);
        Properties newProp = new Properties();
        Enumeration<Object> keysProp = this.properties.keys();
        while (keysProp.hasMoreElements()) {
            Object key = keysProp.nextElement();
            newProp.put(key, this.properties.get(key));
        }
        ret.setProperties(newProp);
        if (this.jobProperties != null) {
            ret.jobProperties = new LinkedHashMap<String, String>(this.jobProperties);
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputFileFormatClass == null ? 0 : this.inputFileFormatClass.hashCode());
        result = 31 * result + (this.outputFileFormatClass == null ? 0 : this.outputFileFormatClass.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.jobProperties == null ? 0 : this.jobProperties.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDesc)) {
            return false;
        }
        TableDesc target = (TableDesc)o;
        boolean ret = true;
        boolean bl = ret && (this.inputFileFormatClass == null ? target.inputFileFormatClass == null : this.inputFileFormatClass.equals(target.inputFileFormatClass)) ? true : (ret = false);
        boolean bl2 = ret && (this.outputFileFormatClass == null ? target.outputFileFormatClass == null : this.outputFileFormatClass.equals(target.outputFileFormatClass)) ? true : (ret = false);
        boolean bl3 = ret && (this.properties == null ? target.properties == null : this.properties.equals(target.properties)) ? true : (ret = false);
        ret = ret && (this.jobProperties == null ? target.jobProperties == null : this.jobProperties.equals(target.jobProperties));
        return ret;
    }

    public String toString() {
        return "TableDesc [inputFileFormatClass=" + this.inputFileFormatClass + ", outputFileFormatClass=" + this.outputFileFormatClass + ", properties=" + this.properties + ", jobProperties=" + this.jobProperties + "]";
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

