/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import java.util.Locale;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;

public enum SQLPrivilegeType {
    SELECT,
    INSERT,
    UPDATE,
    DELETE;


    public static SQLPrivilegeType getRequirePrivilege(String priv) throws HiveAuthzPluginException {
        SQLPrivilegeType reqPriv;
        if (priv == null) {
            throw new HiveAuthzPluginException("Null privilege obtained");
        }
        try {
            reqPriv = SQLPrivilegeType.valueOf(priv.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            throw new HiveAuthzPluginException("Unsupported privilege type " + priv, e);
        }
        return reqPriv;
    }
}

