/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprDynamicParamDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.stats.BasicStats;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.hive.ql.stats.estimator.StatEstimator;
import org.apache.hadoop.hive.ql.stats.estimator.StatEstimatorProvider;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.ql.util.NamedForkJoinWorkerThreadFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)StatsUtils.class.getName());
    private static final int DATE_RANGE_LOWER_LIMIT = 10593;
    private static final int DATE_RANGE_UPPER_LIMIT = 22279;
    private static final long TIMESTAMP_RANGE_LOWER_LIMIT = 915148800L;
    private static final long TIMESTAMP_RANGE_UPPER_LIMIT = 1924991999L;
    private static final ForkJoinPool statsForkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new NamedForkJoinWorkerThreadFactory("basic-stats-"), StatsUtils.getUncaughtExceptionHandler(), false);

    private static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return (t, e) -> LOG.error(String.format("Thread %s exited with error", t.getName()), e);
    }

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, ColumnStatsList colStatsCache, org.apache.hadoop.hive.ql.metadata.Table table, TableScanOperator tableScanOperator) throws HiveException {
        List<ColumnInfo> schema = tableScanOperator.getSchema().getSignature();
        List<String> neededColumns = tableScanOperator.getNeededColumns();
        List<String> referencedColumns = tableScanOperator.getReferencedColumns();
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, colStatsCache, referencedColumns);
    }

    private static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, org.apache.hadoop.hive.ql.metadata.Table table, List<ColumnInfo> schema, List<String> neededColumns, ColumnStatsList colStatsCache, List<String> referencedColumns) throws HiveException {
        boolean fetchColStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS);
        boolean testMode = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST);
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, colStatsCache, referencedColumns, fetchColStats, testMode);
    }

    public static long getNumRows(HiveConf conf, List<ColumnInfo> schema, org.apache.hadoop.hive.ql.metadata.Table table, PrunedPartitionList partitionList, AtomicInteger noColsMissingStats) {
        ArrayList<Partish> inputs = new ArrayList<Partish>();
        if (table.isPartitioned()) {
            for (Partition partition : partitionList.getNotDeniedPartns()) {
                inputs.add(Partish.buildFor(table, partition));
            }
        } else {
            inputs.add(Partish.buildFor(table));
        }
        BasicStats.Factory basicStatsFactory = new BasicStats.Factory(new BasicStats.IStatsEnhancer[0]);
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS)) {
            basicStatsFactory.addEnhancer(new BasicStats.DataSizeEstimator(conf));
            basicStatsFactory.addEnhancer(new BasicStats.RowNumEstimator(StatsUtils.estimateRowSizeFromSchema(conf, schema)));
        }
        for (Partish pi : inputs) {
            BasicStats bStats = new BasicStats(pi);
            long nr = bStats.getNumRows();
            if (nr > 0L) continue;
            noColsMissingStats.getAndIncrement();
        }
        List<BasicStats> list = basicStatsFactory.buildAll(conf, inputs);
        BasicStats aggregateStat = BasicStats.buildFrom(list);
        aggregateStat.apply(new BasicStats.SetMinRowNumber());
        return aggregateStat.getNumRows();
    }

    private static void estimateStatsForMissingCols(List<String> neededColumns, List<ColStatistics> columnStats, HiveConf conf, long nr, List<ColumnInfo> schema) {
        HashSet<String> neededCols = new HashSet<String>(neededColumns);
        HashSet<String> colsWithStats = new HashSet<String>();
        for (ColStatistics cstats : columnStats) {
            colsWithStats.add(cstats.getColumnName());
        }
        ArrayList<String> missingColStats = new ArrayList<String>((Collection<String>)Sets.difference(neededCols, colsWithStats));
        if (!missingColStats.isEmpty()) {
            columnStats.addAll(StatsUtils.estimateStats(schema, missingColStats, conf, nr));
        }
    }

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, org.apache.hadoop.hive.ql.metadata.Table table, List<ColumnInfo> schema, List<String> neededColumns, ColumnStatsList colStatsCache, List<String> referencedColumns, boolean needColStats) throws HiveException {
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, colStatsCache, referencedColumns, needColStats, false);
    }

    private static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, org.apache.hadoop.hive.ql.metadata.Table table, List<ColumnInfo> schema, List<String> neededColumns, ColumnStatsList colStatsCache, List<String> referencedColumns, boolean needColStats, boolean failIfCacheMiss) throws HiveException {
        boolean metaTable;
        Statistics stats = null;
        boolean fetchColStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS);
        boolean estimateStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS);
        boolean bl = metaTable = table.getMetaTable() != null;
        if (!table.isPartitioned() || !StatsUtils.checkCanProvidePartitionStats(table)) {
            BasicStats.Factory basicStatsFactory = new BasicStats.Factory(new BasicStats.IStatsEnhancer[0]);
            if (estimateStats) {
                basicStatsFactory.addEnhancer(new BasicStats.DataSizeEstimator(conf));
            }
            basicStatsFactory.addEnhancer(new BasicStats.RowNumEstimator(StatsUtils.estimateRowSizeFromSchema(conf, schema)));
            basicStatsFactory.addEnhancer(new BasicStats.SetMinRowNumber());
            BasicStats basicStats = basicStatsFactory.build(Partish.buildFor(table));
            long ds = basicStats.getDataSize();
            long nr = basicStats.getNumRows();
            long fs = basicStats.getTotalFileSize();
            List<ColStatistics> colStats = Collections.emptyList();
            long numErasureCodedFiles = StatsUtils.getErasureCodedFiles(table);
            if (needColStats && !metaTable) {
                colStats = StatsUtils.getTableColumnStats(table, neededColumns, colStatsCache, fetchColStats);
                if (estimateStats) {
                    StatsUtils.estimateStatsForMissingCols(neededColumns, colStats, conf, nr, schema);
                }
                if (neededColumns.size() == colStats.size()) {
                    long betterDS = StatsUtils.getDataSizeFromColumnStats(nr, colStats);
                    ds = betterDS < 1L || colStats.isEmpty() ? ds : betterDS;
                }
            }
            stats = new Statistics(nr, ds, fs, numErasureCodedFiles);
            StatsUtils.inferAndSetPrimaryKey(stats.getNumRows(), colStats);
            stats.setColumnStatsState(StatsUtils.deriveStatType(colStats, neededColumns));
            stats.addToColumnStats(colStats);
        } else if (partList != null) {
            BasicStats.Factory basicStatsFactory = new BasicStats.Factory(new BasicStats.IStatsEnhancer[0]);
            if (estimateStats) {
                basicStatsFactory.addEnhancer(new BasicStats.DataSizeEstimator(conf));
            }
            basicStatsFactory.addEnhancer(new BasicStats.RowNumEstimator(StatsUtils.estimateRowSizeFromSchema(conf, schema)));
            List partStats = null;
            try {
                partStats = (List)((ForkJoinTask)statsForkJoinPool.submit(() -> partList.getNotDeniedPartns().parallelStream().map(p -> basicStatsFactory.build(Partish.buildFor(table, p))).collect(Collectors.toList()))).get();
            }
            catch (Exception e) {
                throw new HiveException((Throwable)e);
            }
            BasicStats bbs = BasicStats.buildFrom(partStats);
            long nr = bbs.getNumRows();
            long ds = bbs.getDataSize();
            long fs = bbs.getTotalFileSize();
            List<Long> erasureCodedFiles = StatsUtils.getBasicStatForPartitions(partList.getNotDeniedPartns(), "numFilesErasureCoded");
            long numErasureCodedFiles = StatsUtils.getSumIgnoreNegatives(erasureCodedFiles);
            if (nr == 0L) {
                nr = 1L;
            }
            stats = new Statistics(nr, ds, fs, numErasureCodedFiles);
            stats.setBasicStatsState(bbs.getState());
            if (nr > 0L && Statistics.State.PARTIAL.morePreciseThan(bbs.getState())) {
                stats.setBasicStatsState(Statistics.State.PARTIAL);
            }
            if (needColStats) {
                boolean statsRetrieved;
                List<String> partitionCols = StatsUtils.getPartitionColumns(schema, neededColumns, referencedColumns);
                ArrayList<ColStatistics> columnStats = new ArrayList<ColStatistics>();
                List<String> neededColsToRetrieve = StatsUtils.extractColumnStates(table, neededColumns, colStatsCache, columnStats);
                List<String> partitionColsToRetrieve = StatsUtils.extractColumnStates(table, partitionCols, colStatsCache, columnStats);
                ArrayList<String> partNames = new ArrayList<String>(partList.getNotDeniedPartns().size());
                for (Partition part : partList.getNotDeniedPartns()) {
                    partNames.add(part.getName());
                }
                AggrStats aggrStats = null;
                if (fetchColStats && !neededColsToRetrieve.isEmpty() && !partNames.isEmpty()) {
                    aggrStats = Hive.get().getAggrColStatsFor(table, neededColsToRetrieve, partNames, false);
                }
                boolean bl2 = statsRetrieved = aggrStats != null && aggrStats.getColStats() != null && aggrStats.getColStatsSize() != 0;
                if (neededColumns.isEmpty() || !neededColsToRetrieve.isEmpty() && !statsRetrieved) {
                    StatsUtils.estimateStatsForMissingCols(neededColsToRetrieve, columnStats, conf, nr, schema);
                    StatsUtils.addPartitionColumnStats(conf, partitionColsToRetrieve, schema, partList, columnStats);
                    stats.addToDataSize(StatsUtils.getDataSizeFromColumnStats(nr, columnStats));
                    stats.updateColumnStatsState(StatsUtils.deriveStatType(columnStats, referencedColumns));
                    stats.addToColumnStats(columnStats);
                } else {
                    if (statsRetrieved) {
                        columnStats.addAll(StatsUtils.convertColStats(aggrStats.getColStats()));
                    }
                    int colStatsAvailable = neededColumns.size() + partitionCols.size() - partitionColsToRetrieve.size();
                    if (columnStats.size() != colStatsAvailable) {
                        LOG.debug("Column stats requested for : {} columns. Able to retrieve for {} columns", (Object)columnStats.size(), (Object)colStatsAvailable);
                    }
                    StatsUtils.addPartitionColumnStats(conf, partitionColsToRetrieve, schema, partList, columnStats);
                    long betterDS = StatsUtils.getDataSizeFromColumnStats(nr, columnStats);
                    stats.setDataSize(betterDS < 1L || columnStats.isEmpty() ? ds : betterDS);
                    StatsUtils.inferAndSetPrimaryKey(stats.getNumRows(), columnStats);
                    stats.addToColumnStats(columnStats);
                    stats.setColumnStatsState(StatsUtils.deriveStatType(columnStats, referencedColumns));
                    if (neededColumns.size() != neededColsToRetrieve.size() || partitionCols.size() != partitionColsToRetrieve.size()) {
                        stats.updateColumnStatsState(colStatsCache.getState());
                    }
                    if (aggrStats != null && aggrStats.getPartsFound() != (long)partNames.size() && stats.getColumnStatsState() != Statistics.State.NONE) {
                        stats.updateColumnStatsState(Statistics.State.PARTIAL);
                        LOG.debug("Column stats requested for : {} partitions. Able to retrieve for {} partitions", (Object)partNames.size(), (Object)aggrStats.getPartsFound());
                    }
                }
                if (partStats.isEmpty()) {
                    stats.setBasicStatsState(Statistics.State.COMPLETE);
                }
                if (colStatsCache != null && failIfCacheMiss && stats.getColumnStatsState().equals((Object)Statistics.State.COMPLETE) && (!neededColsToRetrieve.isEmpty() || !partitionColsToRetrieve.isEmpty())) {
                    throw new HiveException("Cache has been loaded in logical planning phase for all columns; however, stats for column some columns could not be retrieved from it (see messages above)");
                }
            }
        }
        return stats;
    }

    private static List<String> extractColumnStates(org.apache.hadoop.hive.ql.metadata.Table table, List<String> columns, ColumnStatsList colStatsCache, List<ColStatistics> columnStats) {
        if (colStatsCache == null) {
            return columns;
        }
        ArrayList<String> neededColsToRetrieve = new ArrayList<String>(columns.size());
        for (String colName : columns) {
            ColStatistics colStats = colStatsCache.getColStats().get(colName);
            if (colStats == null) {
                neededColsToRetrieve.add(colName);
                LOG.debug("Stats for column {} in table {} could not be retrieved from cache", (Object)colName, (Object)table.getCompleteName());
                continue;
            }
            columnStats.add(colStats);
            LOG.debug("Stats for column {} in table {} retrieved from cache", (Object)colName, (Object)table.getCompleteName());
        }
        return neededColsToRetrieve;
    }

    public static void inferAndSetPrimaryKey(long numRows, List<ColStatistics> colStats) {
        if (colStats != null) {
            for (ColStatistics cs : colStats) {
                if (cs != null && cs.getCountDistint() >= numRows) {
                    cs.setPrimaryKey(true);
                    continue;
                }
                if (cs == null || cs.getRange() == null || cs.getRange().minValue == null || cs.getRange().maxValue == null || numRows != cs.getRange().maxValue.longValue() - cs.getRange().minValue.longValue() + 1L) continue;
                cs.setPrimaryKey(true);
            }
        }
    }

    public static boolean inferForeignKey(ColStatistics csPK, ColStatistics csFK) {
        if (csPK != null && csFK != null && csPK.isPrimaryKey() && csPK.getRange() != null && csFK.getRange() != null) {
            ColStatistics.Range pkRange = csPK.getRange();
            ColStatistics.Range fkRange = csFK.getRange();
            return StatsUtils.isWithin(fkRange, pkRange);
        }
        return false;
    }

    public static float getScaledSelectivity(ColStatistics csPK, ColStatistics csFK) {
        float scaledSelectivity = 1.0f;
        if (csPK != null && csFK != null && csPK.isPrimaryKey() && csPK.getRange() != null && csFK.getRange() != null) {
            long pkRangeDelta = StatsUtils.getRangeDelta(csPK.getRange());
            long fkRangeDelta = StatsUtils.getRangeDelta(csFK.getRange());
            if (fkRangeDelta > 0L && pkRangeDelta > 0L && fkRangeDelta < pkRangeDelta) {
                scaledSelectivity = (float)pkRangeDelta / (float)fkRangeDelta;
            }
        }
        return scaledSelectivity;
    }

    public static long getRangeDelta(ColStatistics.Range range) {
        if (range.minValue != null && range.maxValue != null) {
            return range.maxValue.longValue() - range.minValue.longValue();
        }
        return 0L;
    }

    private static boolean isWithin(ColStatistics.Range range1, ColStatistics.Range range2) {
        return range1.minValue != null && range2.minValue != null && range1.maxValue != null && range2.maxValue != null && range1.minValue.longValue() >= range2.minValue.longValue() && range1.maxValue.longValue() <= range2.maxValue.longValue();
    }

    private static void addPartitionColumnStats(HiveConf conf, List<String> partitionCols, List<ColumnInfo> schema, PrunedPartitionList partList, List<ColStatistics> colStats) {
        for (String col : partitionCols) {
            for (ColumnInfo ci : schema) {
                if (!col.equals(ci.getInternalName())) continue;
                colStats.add(StatsUtils.getColStatsForPartCol(ci, new PartitionIterable(partList.getPartitions()), conf));
            }
        }
    }

    private static List<String> getPartitionColumns(List<ColumnInfo> schema, List<String> neededColumns, List<String> referencedColumns) {
        ArrayList<String> partitionCols = new ArrayList<String>(referencedColumns.size());
        ArrayList extraCols = Lists.newArrayList(referencedColumns);
        if (referencedColumns.size() > neededColumns.size()) {
            extraCols.removeAll(neededColumns);
            for (String col : extraCols) {
                for (ColumnInfo ci : schema) {
                    if (!col.equals(ci.getInternalName()) || !ci.getIsVirtualCol() || ci.isHiddenVirtualCol()) continue;
                    partitionCols.add(col);
                }
            }
        }
        return partitionCols;
    }

    public static ColStatistics getColStatsForPartCol(ColumnInfo ci, PartitionIterable partList, HiveConf conf) {
        ColStatistics partCS = new ColStatistics(ci.getInternalName(), ci.getType().getTypeName());
        long numPartitions = StatsUtils.getNDVPartitionColumn(partList, ci.getInternalName());
        partCS.setCountDistint(numPartitions);
        partCS.setAvgColLen(StatsUtils.getAvgColLenOf(conf, ci.getObjectInspector(), partCS.getColumnType()));
        partCS.setRange(StatsUtils.getRangePartitionColumn(partList, ci.getInternalName(), ci.getType().getTypeName()));
        return partCS;
    }

    public static int getNDVPartitionColumn(PartitionIterable partitions, String partColName) {
        HashSet<String> distinctVals = new HashSet<String>();
        for (Partition partition : partitions) {
            distinctVals.add(partition.getSpec().get(partColName));
        }
        return distinctVals.size();
    }

    private static ColStatistics.Range getRangePartitionColumn(PartitionIterable partitions, String partColName, String colType) {
        ColStatistics.Range range = null;
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("bigint")) {
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            for (Partition partition : partitions) {
                String partVal = partition.getSpec().get(partColName);
                if (!NumberUtils.isCreatable((String)partVal)) continue;
                long value = Long.parseLong(partVal);
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            range = new ColStatistics.Range(min, max);
        } else if (colTypeLowerCase.equals("float") || colTypeLowerCase.equals("double") || colTypeLowerCase.startsWith("decimal")) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (Partition partition : partitions) {
                String partVal = partition.getSpec().get(partColName);
                if (!NumberUtils.isCreatable((String)partVal)) continue;
                double value = Double.parseDouble(partVal);
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            range = new ColStatistics.Range(min, max);
        } else {
            return null;
        }
        return range;
    }

    private static long getAvgColSize(ColumnInfo columnInfo, HiveConf conf) {
        ObjectInspector oi = columnInfo.getObjectInspector();
        String colTypeLowerCase = columnInfo.getTypeName().toLowerCase();
        if (colTypeLowerCase.equals("string") || colTypeLowerCase.equals("binary") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("array") || colTypeLowerCase.startsWith("map") || colTypeLowerCase.startsWith("struct") || colTypeLowerCase.startsWith("uniontype")) {
            return StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase);
        }
        return StatsUtils.getAvgColLenOfFixedLengthTypes(colTypeLowerCase);
    }

    public static long estimateRowSizeFromSchema(HiveConf conf, List<ColumnInfo> schema) {
        long avgRowSize = 0L;
        for (ColumnInfo ci : schema) {
            avgRowSize += StatsUtils.getAvgColSize(ci, conf);
        }
        return avgRowSize;
    }

    public static long estimateRowSizeFromSchema(HiveConf conf, List<ColumnInfo> schema, List<String> neededColumns) {
        long avgRowSize = 0L;
        for (String neededCol : neededColumns) {
            ColumnInfo ci = StatsUtils.getColumnInfoForColumn(neededCol, schema);
            if (ci == null) continue;
            avgRowSize += StatsUtils.getAvgColSize(ci, conf);
        }
        return avgRowSize;
    }

    private static ColumnInfo getColumnInfoForColumn(String neededCol, List<ColumnInfo> schema) {
        for (ColumnInfo ci : schema) {
            if (!ci.getInternalName().equalsIgnoreCase(neededCol)) continue;
            return ci;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static List<Long> getFileSizeForPartitions(final HiveConf conf, List<Partition> parts) {
        LOG.info("Number of partitions : " + parts.size());
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
        int threads = Math.max(1, conf.getIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT));
        ExecutorService pool = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Get-Partitions-Size-%d").build());
        ArrayList<Long> sizes = new ArrayList<Long>(parts.size());
        for (Partition part : parts) {
            final Path path = part.getDataLocation();
            futures.add(pool.submit(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    try {
                        LOG.debug("Partition path : " + path);
                        FileSystem fs = path.getFileSystem((Configuration)conf);
                        return fs.getContentSummary(path).getLength();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }
            }));
        }
        try {
            for (int i = 0; i < futures.size(); ++i) {
                sizes.add(i, (Long)((Future)futures.get(i)).get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Exception in processing files ", (Throwable)e);
        }
        finally {
            pool.shutdownNow();
        }
        return sizes;
    }

    public static long getSumIgnoreNegatives(List<Long> vals) {
        long result = 0L;
        for (Long l : vals) {
            if (l <= 0L) continue;
            result = StatsUtils.safeAdd(result, l);
        }
        return result;
    }

    private static Statistics.State deriveStatType(List<ColStatistics> colStats, List<String> neededColumns) {
        boolean hasNull;
        boolean hasStats = false;
        boolean bl = hasNull = colStats == null || colStats.size() < neededColumns.size();
        if (colStats != null) {
            ColStatistics cs;
            boolean isNull;
            Iterator<ColStatistics> iterator = colStats.iterator();
            while (!(!iterator.hasNext() || (hasNull |= (isNull = (cs = iterator.next()) == null || cs.isEstimated())) && (hasStats |= !isNull))) {
            }
        }
        Statistics.State result = hasStats ? (hasNull ? Statistics.State.PARTIAL : Statistics.State.COMPLETE) : (neededColumns.isEmpty() ? Statistics.State.COMPLETE : Statistics.State.NONE);
        return result;
    }

    public static ColStatistics getColStatistics(ColumnStatisticsObj cso, String colName) {
        String colTypeLowerCase = cso.getColType().toLowerCase();
        ColStatistics cs = new ColStatistics(colName, colTypeLowerCase);
        ColumnStatisticsData csd = cso.getStatsData();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(csd.getLongStats().getLowValue(), csd.getLongStats().getHighValue());
            cs.setBitVectors(csd.getLongStats().getBitVectors());
            cs.setHistogram(csd.getLongStats().getHistogram());
        } else if (colTypeLowerCase.equals("bigint")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(csd.getLongStats().getLowValue(), csd.getLongStats().getHighValue());
            cs.setBitVectors(csd.getLongStats().getBitVectors());
            cs.setHistogram(csd.getLongStats().getHistogram());
        } else if (colTypeLowerCase.equals("float")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(csd.getDoubleStats().getLowValue(), csd.getDoubleStats().getHighValue());
            cs.setBitVectors(csd.getDoubleStats().getBitVectors());
            cs.setHistogram(csd.getDoubleStats().getHistogram());
        } else if (colTypeLowerCase.equals("double")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(csd.getDoubleStats().getLowValue(), csd.getDoubleStats().getHighValue());
            cs.setBitVectors(csd.getDoubleStats().getBitVectors());
            cs.setHistogram(csd.getDoubleStats().getHistogram());
        } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("varchar")) {
            cs.setCountDistint(csd.getStringStats().getNumDVs());
            cs.setNumNulls(csd.getStringStats().getNumNulls());
            cs.setAvgColLen(csd.getStringStats().getAvgColLen());
            cs.setBitVectors(csd.getStringStats().getBitVectors());
        } else if (colTypeLowerCase.equals("boolean")) {
            if (csd.getBooleanStats().getNumFalses() > 0L && csd.getBooleanStats().getNumTrues() > 0L) {
                cs.setCountDistint(2L);
            } else {
                cs.setCountDistint(1L);
            }
            cs.setNumTrues(csd.getBooleanStats().getNumTrues());
            cs.setNumFalses(csd.getBooleanStats().getNumFalses());
            cs.setNumNulls(csd.getBooleanStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colTypeLowerCase.equals("binary")) {
            cs.setAvgColLen(csd.getBinaryStats().getAvgColLen());
            cs.setNumNulls(csd.getBinaryStats().getNumNulls());
        } else if (colTypeLowerCase.equals("timestamp")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
            cs.setNumNulls(csd.getTimestampStats().getNumNulls());
            Long lowVal = csd.getTimestampStats().getLowValue() != null ? Long.valueOf(csd.getTimestampStats().getLowValue().getSecondsSinceEpoch()) : null;
            Long highVal = csd.getTimestampStats().getHighValue() != null ? Long.valueOf(csd.getTimestampStats().getHighValue().getSecondsSinceEpoch()) : null;
            cs.setRange(lowVal, highVal);
            cs.setHistogram(csd.getTimestampStats().getHistogram());
        } else if (colTypeLowerCase.equals("timestamp with local time zone")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
        } else if (colTypeLowerCase.startsWith("decimal")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDecimal());
            cs.setCountDistint(csd.getDecimalStats().getNumDVs());
            cs.setNumNulls(csd.getDecimalStats().getNumNulls());
            Decimal highValue = csd.getDecimalStats().getHighValue();
            Decimal lowValue = csd.getDecimalStats().getLowValue();
            if (highValue != null && highValue.getUnscaled() != null && lowValue != null && lowValue.getUnscaled() != null) {
                BigDecimal minVal;
                HiveDecimal maxHiveDec = HiveDecimal.create((BigInteger)new BigInteger(highValue.getUnscaled()), (int)highValue.getScale());
                BigDecimal maxVal = maxHiveDec == null ? null : maxHiveDec.bigDecimalValue();
                HiveDecimal minHiveDec = HiveDecimal.create((BigInteger)new BigInteger(lowValue.getUnscaled()), (int)lowValue.getScale());
                BigDecimal bigDecimal = minVal = minHiveDec == null ? null : minHiveDec.bigDecimalValue();
                if (minVal != null && maxVal != null) {
                    cs.setRange(minVal, maxVal);
                }
            }
            cs.setBitVectors(csd.getDecimalStats().getBitVectors());
            cs.setHistogram(csd.getDecimalStats().getHistogram());
        } else if (colTypeLowerCase.equals("date")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDate());
            cs.setNumNulls(csd.getDateStats().getNumNulls());
            Long lowVal = csd.getDateStats().getLowValue() != null ? Long.valueOf(csd.getDateStats().getLowValue().getDaysSinceEpoch()) : null;
            Long highVal = csd.getDateStats().getHighValue() != null ? Long.valueOf(csd.getDateStats().getHighValue().getDaysSinceEpoch()) : null;
            cs.setRange(lowVal, highVal);
            cs.setBitVectors(csd.getDateStats().getBitVectors());
            cs.setHistogram(csd.getDateStats().getHistogram());
        } else {
            return null;
        }
        return cs;
    }

    private static ColStatistics estimateColStats(long numRows, String colName, HiveConf conf, List<ColumnInfo> schema) {
        ColumnInfo cinfo = StatsUtils.getColumnInfoForColumn(colName, schema);
        ColStatistics cs = new ColStatistics(colName, cinfo.getTypeName());
        cs.setIsEstimated(true);
        String colTypeLowerCase = cinfo.getTypeName().toLowerCase();
        float ndvPercent = Math.min(100.0f, HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_NDV_ESTIMATE_PERC));
        float nullPercent = Math.min(100.0f, HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_NUM_NULLS_ESTIMATE_PERC));
        cs.setCountDistint(Math.max(1L, (long)((double)((float)numRows * ndvPercent) / 100.0)));
        cs.setNumNulls(Math.min(numRows, (long)((double)((float)numRows * nullPercent) / 100.0)));
        if (colTypeLowerCase.equals("tinyint")) {
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(-128, 127);
        } else if (colTypeLowerCase.equals("smallint")) {
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(Short.MIN_VALUE, Short.MAX_VALUE);
        } else if (colTypeLowerCase.equals("int")) {
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
        } else if (colTypeLowerCase.equals("bigint")) {
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(Long.MIN_VALUE, Long.MAX_VALUE);
        } else if (colTypeLowerCase.equals("float")) {
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        } else if (colTypeLowerCase.equals("double")) {
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(Double.MIN_VALUE, Double.MAX_VALUE);
        } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("binary") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("varchar")) {
            cs.setAvgColLen(StatsUtils.getAvgColLenOf(conf, cinfo.getObjectInspector(), cinfo.getTypeName()));
        } else if (colTypeLowerCase.equals("boolean")) {
            cs.setCountDistint(2L);
            cs.setNumTrues(Math.max(1L, numRows / 2L));
            cs.setNumFalses(Math.max(1L, numRows / 2L));
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colTypeLowerCase.equals("timestamp")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
            cs.setRange(915148800L, 1924991999L);
        } else if (colTypeLowerCase.equals("timestamp with local time zone")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
        } else if (colTypeLowerCase.startsWith("decimal")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDecimal());
            cs.setRange(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        } else if (colTypeLowerCase.equals("date")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDate());
            cs.setRange(10593, 22279);
        } else {
            cs.setAvgColLen(StatsUtils.getSizeOfComplexTypes(conf, cinfo.getObjectInspector()));
        }
        return cs;
    }

    private static List<ColStatistics> estimateStats(List<ColumnInfo> schema, List<String> neededColumns, HiveConf conf, long nr) {
        ArrayList<ColStatistics> stats = new ArrayList<ColStatistics>(neededColumns.size());
        for (String column : neededColumns) {
            ColStatistics cs = StatsUtils.estimateColStats(nr, column, conf, schema);
            stats.add(cs);
        }
        return stats;
    }

    public static List<ColStatistics> getTableColumnStats(org.apache.hadoop.hive.ql.metadata.Table table, List<String> neededColumns, ColumnStatsList colStatsCache, boolean fetchColStats) {
        List<String> colStatsToRetrieve;
        List<ColStatistics> stats = new ArrayList<ColStatistics>();
        if (table.isMaterializedTable()) {
            LOG.debug("Materialized table does not contain table statistics");
            return stats;
        }
        if (colStatsCache != null) {
            colStatsToRetrieve = new ArrayList<String>(neededColumns.size());
            for (String colName : neededColumns) {
                if (colStatsCache.getColStats().containsKey(colName)) continue;
                colStatsToRetrieve.add(colName);
            }
        } else {
            colStatsToRetrieve = neededColumns;
        }
        String dbName = table.getDbName();
        String tabName = table.getTableName();
        if ("_dummy_database".equals(dbName) && "_dummy_table".equals(tabName)) {
            return stats;
        }
        if (fetchColStats && !colStatsToRetrieve.isEmpty()) {
            try {
                List<ColumnStatisticsObj> colStat = Hive.get().getTableColumnStatistics(table, colStatsToRetrieve, false);
                stats = StatsUtils.convertColStats(colStat);
            }
            catch (HiveException e) {
                LOG.error("Failed to retrieve table statistics: ", (Throwable)e);
            }
        }
        if (colStatsCache != null) {
            for (String col : neededColumns) {
                ColStatistics cs = colStatsCache.getColStats().get(col);
                if (cs == null) continue;
                stats.add(cs);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Stats for column " + cs.getColumnName() + " in table " + table.getCompleteName() + " retrieved from cache");
            }
        }
        return stats;
    }

    private static List<ColStatistics> convertColStats(List<ColumnStatisticsObj> colStats) {
        if (colStats == null) {
            return Collections.emptyList();
        }
        ArrayList<ColStatistics> stats = new ArrayList<ColStatistics>(colStats.size());
        for (ColumnStatisticsObj statObj : colStats) {
            ColStatistics cs = StatsUtils.getColStatistics(statObj, statObj.getColName());
            if (cs == null) continue;
            stats.add(cs);
        }
        return stats;
    }

    public static long getAvgColLenOf(HiveConf conf, ObjectInspector oi, String colType) {
        long configVarLen = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_MAX_VARIABLE_LENGTH);
        String colTypeLowCase = colType.toLowerCase();
        if (colTypeLowCase.equals("string")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof StringObjectInspector) {
                return configVarLen;
            }
        } else if (colTypeLowCase.startsWith("varchar")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof HiveVarcharObjectInspector) {
                VarcharTypeInfo type = (VarcharTypeInfo)((HiveVarcharObjectInspector)oi).getTypeInfo();
                return type.getLength();
            }
        } else if (colTypeLowCase.startsWith("char")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof HiveCharObjectInspector) {
                CharTypeInfo type = (CharTypeInfo)((HiveCharObjectInspector)oi).getTypeInfo();
                return type.getLength();
            }
        } else if (colTypeLowCase.equals("binary")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                BytesWritable constantValue = (BytesWritable)coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.getLength();
            }
            if (oi instanceof BinaryObjectInspector) {
                return configVarLen;
            }
        } else {
            return StatsUtils.getSizeOfComplexTypes(conf, oi);
        }
        throw new IllegalArgumentException("Size requested for unknown type: " + colType + " OI: " + oi.getTypeName());
    }

    public static long getSizeOfComplexTypes(HiveConf conf, ObjectInspector oi) {
        long result = 0L;
        int length = 0;
        int listEntries = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_LIST_NUM_ENTRIES);
        int mapEntries = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_MAP_NUM_ENTRIES);
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                String colTypeLowerCase = oi.getTypeName().toLowerCase();
                if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase);
                    result += (long)JavaDataModel.get().lengthForStringOfLength(avgColLen);
                    break;
                }
                if (colTypeLowerCase.equals("binary")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase);
                    result += JavaDataModel.get().lengthForByteArrayOfSize((long)avgColLen);
                    break;
                }
                result += StatsUtils.getAvgColLenOfFixedLengthTypes(colTypeLowerCase);
                break;
            }
            case LIST: {
                if (oi instanceof StandardConstantListObjectInspector) {
                    ObjectInspector leoi;
                    StandardConstantListObjectInspector scloi = (StandardConstantListObjectInspector)oi;
                    List value = scloi.getWritableConstantValue();
                    if (value != null) {
                        length = value.size();
                    }
                    if ((leoi = scloi.getListElementObjectInspector()).getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
                        int maxVarLen = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_MAX_VARIABLE_LENGTH);
                        result += StatsUtils.getSizeOfPrimitiveTypeArraysFromType(leoi.getTypeName(), length, maxVarLen);
                        break;
                    }
                    result += JavaDataModel.get().lengthForObjectArrayOfSize((long)length);
                    break;
                }
                StandardListObjectInspector sloi = (StandardListObjectInspector)oi;
                long elemSize = StatsUtils.getSizeOfComplexTypes(conf, sloi.getListElementObjectInspector());
                result += (long)JavaDataModel.get().arrayList() + (long)listEntries * elemSize;
                break;
            }
            case MAP: {
                if (oi instanceof StandardConstantMapObjectInspector) {
                    StandardConstantMapObjectInspector scmoi = (StandardConstantMapObjectInspector)oi;
                    result += StatsUtils.getSizeOfMap(scmoi);
                    break;
                }
                StandardMapObjectInspector smoi = (StandardMapObjectInspector)oi;
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapKeyObjectInspector());
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapValueObjectInspector());
                result += (long)JavaDataModel.get().hashMap(mapEntries);
                break;
            }
            case STRUCT: {
                if (oi instanceof StandardConstantStructObjectInspector) {
                    StandardConstantStructObjectInspector scsoi = (StandardConstantStructObjectInspector)oi;
                    result += StatsUtils.getSizeOfStruct(scsoi);
                    break;
                }
                StructObjectInspector soi = (StructObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(soi.getAllStructFieldRefs().size() * JavaDataModel.get().ref());
                for (StructField field : soi.getAllStructFieldRefs()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, field.getFieldObjectInspector());
                }
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(uoi.getObjectInspectors().size() * JavaDataModel.get().primitive1());
                for (ObjectInspector foi : uoi.getObjectInspectors()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, foi);
                }
                break;
            }
        }
        return result;
    }

    public static long getAvgColLenOfFixedLengthTypes(String colType) {
        String colTypeLowerCase = Objects.requireNonNull(colType).toLowerCase();
        if (colTypeLowerCase.startsWith("decimal")) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        switch (colTypeLowerCase) {
            case "tinyint": 
            case "smallint": 
            case "int": 
            case "void": 
            case "boolean": 
            case "float": {
                return JavaDataModel.get().primitive1();
            }
            case "double": 
            case "bigint": 
            case "interval_year_month": 
            case "long": {
                return JavaDataModel.get().primitive2();
            }
            case "timestamp": 
            case "timestamp with local time zone": {
                return JavaDataModel.get().lengthOfTimestamp();
            }
            case "date": {
                return JavaDataModel.get().lengthOfDate();
            }
            case "interval_day_time": {
                return 12L;
            }
        }
        return 0L;
    }

    public static long getSizeOfPrimitiveTypeArraysFromType(String colType, int length, int maxLength) {
        String colTypeLowerCase = Objects.requireNonNull(colType).toLowerCase();
        if (colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
            int charTypeLen = JavaDataModel.get().lengthForStringOfLength(maxLength);
            return JavaDataModel.get().lengthForPrimitiveArrayOfSize(charTypeLen, (long)length);
        }
        switch (colTypeLowerCase) {
            case "tinyint": 
            case "smallint": 
            case "int": 
            case "float": {
                return JavaDataModel.get().lengthForIntArrayOfSize((long)length);
            }
            case "double": {
                return JavaDataModel.get().lengthForDoubleArrayOfSize((long)length);
            }
            case "bigint": 
            case "long": {
                return JavaDataModel.get().lengthForLongArrayOfSize((long)length);
            }
            case "binary": {
                return JavaDataModel.get().lengthForByteArrayOfSize((long)length);
            }
            case "boolean": {
                return JavaDataModel.get().lengthForBooleanArrayOfSize((long)length);
            }
            case "timestamp": 
            case "datetime": 
            case "interval_year_month": 
            case "interval_day_time": 
            case "timestamp with local time zone": {
                return JavaDataModel.get().lengthForTimestampArrayOfSize((long)length);
            }
            case "date": {
                return JavaDataModel.get().lengthForDateArrayOfSize((long)length);
            }
            case "decimal": {
                return JavaDataModel.get().lengthForDecimalArrayOfSize((long)length);
            }
            case "string": {
                int stringTypeLen = JavaDataModel.get().lengthForStringOfLength(maxLength);
                return JavaDataModel.get().lengthForPrimitiveArrayOfSize(stringTypeLen, (long)length);
            }
        }
        return 0L;
    }

    public static long getSizeOfMap(StandardConstantMapObjectInspector scmoi) {
        Map map = scmoi.getWritableConstantValue();
        if (null == map) {
            return 0L;
        }
        ObjectInspector koi = scmoi.getMapKeyObjectInspector();
        ObjectInspector voi = scmoi.getMapValueObjectInspector();
        long result = 0L;
        for (Map.Entry entry : map.entrySet()) {
            result += StatsUtils.getWritableSize(koi, entry.getKey());
            result += StatsUtils.getWritableSize(voi, entry.getValue());
        }
        return result += (long)JavaDataModel.get().hashMap(map.entrySet().size());
    }

    public static long getSizeOfStruct(StandardConstantStructObjectInspector soi) {
        long result = 0L;
        result += (long)JavaDataModel.get().object();
        result += (long)(soi.getAllStructFieldRefs().size() * JavaDataModel.get().ref());
        List value = soi.getWritableConstantValue();
        List fields = soi.getAllStructFieldRefs();
        if (value == null || value.size() != fields.size()) {
            return result;
        }
        for (int i = 0; i < fields.size(); ++i) {
            result += StatsUtils.getWritableSize(((StructField)fields.get(i)).getFieldObjectInspector(), value.get(i));
        }
        return result;
    }

    public static long getWritableSize(ObjectInspector oi, Object value) {
        if (oi instanceof WritableStringObjectInspector) {
            WritableStringObjectInspector woi = (WritableStringObjectInspector)oi;
            return JavaDataModel.get().lengthForStringOfLength(value == null ? 0 : woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBinaryObjectInspector) {
            WritableBinaryObjectInspector woi = (WritableBinaryObjectInspector)oi;
            return JavaDataModel.get().lengthForByteArrayOfSize(value == null ? 0L : (long)woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBooleanObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableByteObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableDateObjectInspector) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (oi instanceof WritableDoubleObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableFloatObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableHiveDecimalObjectInspector) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        if (oi instanceof WritableIntObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableLongObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableShortObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableTimestampObjectInspector || oi instanceof WritableTimestampLocalTZObjectInspector) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        return 0L;
    }

    public static List<ColStatistics> getColStatisticsFromExprMap(HiveConf conf, Statistics parentStats, Map<String, ExprNodeDesc> colExprMap, RowSchema rowSchema) {
        ArrayList cs = Lists.newArrayList();
        if (colExprMap != null && rowSchema != null) {
            for (ColumnInfo columnInfo : rowSchema.getSignature()) {
                String outColName = columnInfo.getInternalName();
                ExprNodeDesc end = colExprMap.get(outColName);
                ColStatistics colStat = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end);
                if (colStat == null) continue;
                colStat.setColumnName(outColName);
                cs.add(colStat);
            }
            for (Map.Entry entry : colExprMap.entrySet()) {
                ColStatistics colStat;
                if (rowSchema.getColumnInfo((String)entry.getKey()) != null || (colStat = StatsUtils.getColStatisticsFromExpression(conf, parentStats, (ExprNodeDesc)entry.getValue())) == null) continue;
                colStat.setColumnName((String)entry.getKey());
                cs.add(colStat);
            }
            return cs;
        }
        if (parentStats.getColumnStats() != null) {
            cs.addAll(parentStats.getColumnStats());
        }
        return cs;
    }

    public static List<ColStatistics> getColStatisticsUpdatingTableAlias(Statistics parentStats) {
        ArrayList cs = Lists.newArrayList();
        for (ColStatistics parentColStat : parentStats.getColumnStats()) {
            ColStatistics colStat = parentColStat.clone();
            if (colStat == null) continue;
            cs.add(colStat);
        }
        return cs;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ColStatistics getColStatisticsFromExpression(HiveConf conf, Statistics parentStats, ExprNodeDesc end) {
        ObjectInspector oi;
        long numNulls;
        long countDistincts;
        double avgColSize;
        String colType;
        String colName;
        block15: {
            ExprNodeGenericFuncDesc engfd;
            long numRows;
            block17: {
                Optional<ColStatistics> res;
                ExprNodeDesc child;
                ColStatistics cs;
                Iterator<ExprNodeDesc> iterator;
                ArrayList<ColStatistics> csList;
                StatEstimator se;
                block18: {
                    ExprNodeDesc encd;
                    block16: {
                        Optional<StatEstimatorProvider> sep;
                        ColStatistics stats;
                        if (end == null) {
                            return null;
                        }
                        colName = null;
                        colType = null;
                        avgColSize = 0.0;
                        countDistincts = 0L;
                        numNulls = 0L;
                        oi = end.getWritableObjectInspector();
                        numRows = parentStats.getNumRows();
                        if (end instanceof ExprNodeColumnDesc) {
                            encd = (ExprNodeColumnDesc)end;
                            colName = ((ExprNodeColumnDesc)encd).getColumn();
                            if (((ExprNodeColumnDesc)encd).getIsPartitionColOrVirtualCol()) {
                                ColStatistics colStats = parentStats.getColumnStatisticsFromColName(colName);
                                if (colStats != null) {
                                    return colStats.clone();
                                }
                                colType = encd.getTypeInfo().getTypeName();
                                countDistincts = numRows;
                                break block15;
                            } else {
                                ColStatistics result = parentStats.getColumnStatisticsFromColName(colName);
                                if (result != null) {
                                    return result.clone();
                                }
                                return null;
                            }
                        }
                        if (end instanceof ExprNodeConstantDesc) {
                            return StatsUtils.buildColStatForConstant(conf, numRows, (ExprNodeConstantDesc)end);
                        }
                        if (!(end instanceof ExprNodeGenericFuncDesc)) break block16;
                        engfd = (ExprNodeGenericFuncDesc)end;
                        colName = engfd.getName();
                        colType = engfd.getTypeString();
                        if (StatsUtils.isWideningCast(engfd) && engfd.getChildren().get(0) instanceof ExprNodeColumnDesc && (stats = parentStats.getColumnStatisticsFromColName(engfd.getCols().get(0))) != null) {
                            ColStatistics newStats = stats.clone();
                            newStats.setColumnName(colName);
                            colType = colType.toLowerCase();
                            newStats.setColumnType(colType);
                            newStats.setAvgColLen(StatsUtils.getAvgColLenOf(conf, oi, colType));
                            return newStats;
                        }
                        if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_ESTIMATORS_ENABLE) || !(sep = engfd.getGenericUDF().adapt(StatEstimatorProvider.class)).isPresent()) break block17;
                        se = sep.get().getStatEstimator();
                        csList = new ArrayList<ColStatistics>();
                        iterator = engfd.getChildren().iterator();
                        break block18;
                    }
                    if (end instanceof ExprNodeColumnListDesc) {
                        encd = (ExprNodeColumnListDesc)end;
                        colName = Joiner.on((String)",").join(((ExprNodeColumnListDesc)encd).getCols());
                        colType = "array";
                        countDistincts = numRows;
                        break block15;
                    } else if (end instanceof ExprNodeFieldDesc) {
                        ExprNodeFieldDesc enfd = (ExprNodeFieldDesc)end;
                        colName = enfd.getFieldName();
                        colType = enfd.getTypeString();
                        countDistincts = numRows;
                        break block15;
                    } else {
                        if (end instanceof ExprDynamicParamDesc) {
                            return null;
                        }
                        throw new IllegalArgumentException("not supported expr type " + end.getClass());
                    }
                }
                while (iterator.hasNext() && (cs = StatsUtils.getColStatisticsFromExpression(conf, parentStats, child = iterator.next())) != null) {
                    csList.add(cs);
                }
                if (csList.size() == engfd.getChildren().size() && (res = se.estimate(csList)).isPresent()) {
                    ColStatistics newStats = res.get();
                    colType = colType.toLowerCase();
                    newStats.setColumnType(colType);
                    newStats.setColumnName(colName);
                    return newStats;
                }
            }
            countDistincts = StatsUtils.getNDVFor(engfd, numRows, parentStats);
        }
        colType = colType.toLowerCase();
        avgColSize = StatsUtils.getAvgColLenOf(conf, oi, colType);
        ColStatistics colStats = new ColStatistics(colName, colType);
        colStats.setAvgColLen(avgColSize);
        colStats.setCountDistint(countDistincts);
        colStats.setNumNulls(numNulls);
        return colStats;
    }

    private static ColStatistics buildColStatForConstant(HiveConf conf, long numRows, ExprNodeConstantDesc encd) {
        long numNulls = 0L;
        long countDistincts = 0L;
        if (encd.getValue() == null) {
            numNulls = numRows;
        } else {
            countDistincts = 1L;
        }
        String colType = encd.getTypeString();
        colType = colType.toLowerCase();
        ConstantObjectInspector oi = encd.getWritableObjectInspector();
        double avgColSize = StatsUtils.getAvgColLenOf(conf, (ObjectInspector)oi, colType);
        ColStatistics colStats = new ColStatistics(encd.getName(), colType);
        colStats.setAvgColLen(avgColSize);
        colStats.setCountDistint(countDistincts);
        colStats.setNumNulls(numNulls);
        Optional<Number> value = StatsUtils.getConstValue(encd);
        value.ifPresent(number -> colStats.setRange((Number)number, (Number)number));
        return colStats;
    }

    private static Optional<Number> getConstValue(ExprNodeConstantDesc encd) {
        if (encd.getValue() == null) {
            return Optional.empty();
        }
        String constant = encd.getValue().toString();
        PrimitiveObjectInspector.PrimitiveCategory category = GenericUDAFSum.getReturnType(encd.getTypeInfo());
        if (category == null) {
            return Optional.empty();
        }
        switch (category) {
            case INT: 
            case BYTE: 
            case SHORT: 
            case LONG: {
                return Optional.ofNullable(Longs.tryParse((String)constant));
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return Optional.ofNullable(Doubles.tryParse((String)constant));
            }
        }
        return Optional.empty();
    }

    private static boolean isWideningCast(ExprNodeGenericFuncDesc engfd) {
        GenericUDF udf = engfd.getGenericUDF();
        if (!FunctionRegistry.isOpCast(udf)) {
            return false;
        }
        return TypeInfoUtils.implicitConvertible((TypeInfo)engfd.getChildren().get(0).getTypeInfo(), (TypeInfo)engfd.getTypeInfo());
    }

    public static Long addWithExpDecay(List<Long> distinctVals) {
        distinctVals.sort(Collections.reverseOrder());
        long denom = distinctVals.get(0);
        for (int i = 1; i < distinctVals.size(); ++i) {
            denom = (long)((double)denom * Math.pow(distinctVals.get(i).longValue(), 1.0 / (double)(1 << i)));
        }
        return denom;
    }

    private static long getNDVFor(ExprNodeGenericFuncDesc engfd, long numRows, Statistics parentStats) {
        GenericUDF udf = engfd.getGenericUDF();
        if (!FunctionRegistry.isDeterministic(udf) && !FunctionRegistry.isRuntimeConstant(udf)) {
            return numRows;
        }
        ArrayList ndvs = Lists.newArrayList();
        Class<Object> udfClass = udf instanceof GenericUDFBridge ? ((GenericUDFBridge)udf).getUdfClass() : udf.getClass();
        NDV ndv = (NDV)AnnotationUtils.getAnnotation(udfClass, NDV.class);
        long udfNDV = Long.MAX_VALUE;
        if (ndv != null) {
            udfNDV = ndv.maxNdv();
        } else {
            for (String col : engfd.getCols()) {
                ColStatistics stats = parentStats.getColumnStatisticsFromColName(col);
                if (stats == null) continue;
                ndvs.add(stats.getCountDistint());
            }
        }
        long countDistincts = ndvs.isEmpty() ? numRows : StatsUtils.addWithExpDecay(ndvs);
        return (Long)Collections.min(Lists.newArrayList((Object[])new Long[]{countDistincts, udfNDV, numRows}));
    }

    @Deprecated
    public static long getNumRows(org.apache.hadoop.hive.ql.metadata.Table table) {
        return StatsUtils.getBasicStatForTable(table, "numRows");
    }

    public static long getTotalSize(org.apache.hadoop.hive.ql.metadata.Table table) {
        return StatsUtils.getBasicStatForTable(table, "totalSize");
    }

    public static long getErasureCodedFiles(org.apache.hadoop.hive.ql.metadata.Table table) {
        return StatsUtils.getBasicStatForTable(table, "numFilesErasureCoded");
    }

    @Deprecated
    public static long getBasicStatForTable(org.apache.hadoop.hive.ql.metadata.Table table, String statType) {
        Map<String, String> params = table.getParameters();
        long result = -1L;
        if (params != null) {
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = -1L;
            }
        }
        return result;
    }

    public static List<Long> getBasicStatForPartitions(List<Partition> parts, String statType) {
        ArrayList stats = Lists.newArrayList();
        for (Partition part : parts) {
            Map<String, String> params = part.getParameters();
            long result = 0L;
            if (params == null) continue;
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
            stats.add(result);
        }
        return stats;
    }

    public static long getDataSizeFromColumnStats(long numRows, List<ColStatistics> colStats) {
        long result = 0L;
        if (numRows <= 0L || colStats == null) {
            return result;
        }
        if (colStats.isEmpty()) {
            return numRows * 8L;
        }
        for (ColStatistics cs : colStats) {
            if (cs == null) continue;
            String colTypeLowerCase = cs.getColumnType().toLowerCase();
            long nonNullCount = cs.getNumNulls() > 0L ? numRows - cs.getNumNulls() + 1L : numRows;
            double sizeOf = 0.0;
            if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("boolean") || colTypeLowerCase.equals("float") || colTypeLowerCase.equals("double")) {
                sizeOf = cs.getAvgColLen();
            } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
                acl = (int)Math.round(cs.getAvgColLen());
                sizeOf = JavaDataModel.get().lengthForStringOfLength(acl);
            } else if (colTypeLowerCase.equals("binary")) {
                acl = (int)Math.round(cs.getAvgColLen());
                sizeOf = JavaDataModel.get().lengthForByteArrayOfSize((long)acl);
            } else {
                sizeOf = colTypeLowerCase.equals("timestamp") || colTypeLowerCase.equals("timestamp with local time zone") ? (double)JavaDataModel.get().lengthOfTimestamp() : (colTypeLowerCase.startsWith("decimal") ? (double)JavaDataModel.get().lengthOfDecimal() : (colTypeLowerCase.equals("date") ? (double)JavaDataModel.get().lengthOfDate() : cs.getAvgColLen()));
            }
            result = StatsUtils.safeAdd(result, StatsUtils.safeMult(nonNullCount, sizeOf));
        }
        return result;
    }

    @Deprecated
    public static String getFullyQualifiedTableName(String dbName, String tabName) {
        return StatsUtils.getFullyQualifiedName(dbName, tabName);
    }

    @Deprecated
    private static String getFullyQualifiedName(String ... names) {
        ArrayList nonNullAndEmptyNames = Lists.newArrayList();
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            nonNullAndEmptyNames.add(name);
        }
        return Joiner.on((String)".").join((Iterable)nonNullAndEmptyNames);
    }

    public static List<String> getQualifedReducerKeyNames(List<String> keyExprs) {
        ArrayList result = Lists.newArrayList();
        if (keyExprs != null) {
            for (String key : keyExprs) {
                result.add(Utilities.ReduceField.KEY + "." + key);
            }
        }
        return result;
    }

    public static long getMaxIfOverflow(long val) {
        return val < 0L ? Long.MAX_VALUE : val;
    }

    public static long safeMult(long a, double b) {
        double result = (double)a * b;
        return result > 9.223372036854776E18 ? Long.MAX_VALUE : (long)result;
    }

    public static long safeAdd(long a, long b) {
        try {
            return LongMath.checkedAdd((long)a, (long)b);
        }
        catch (ArithmeticException ex) {
            return Long.MAX_VALUE;
        }
    }

    public static long safeMult(long a, long b) {
        try {
            return LongMath.checkedMultiply((long)a, (long)b);
        }
        catch (ArithmeticException ex) {
            return Long.MAX_VALUE;
        }
    }

    public static boolean hasDiscreteRange(ColStatistics colStat) {
        TypeInfo colType;
        if (colStat.getRange() != null && (colType = TypeInfoUtils.getTypeInfoFromTypeString((String)colStat.getColumnType())).getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveTypeInfo pti = (PrimitiveTypeInfo)colType;
            switch (pti.getPrimitiveCategory()) {
                case INT: 
                case BYTE: 
                case SHORT: 
                case LONG: 
                case BOOLEAN: {
                    return true;
                }
            }
        }
        return false;
    }

    public static ColStatistics.Range combineRange(ColStatistics.Range range1, ColStatistics.Range range2) {
        if (range1.minValue != null && range1.maxValue != null && range2.minValue != null && range2.maxValue != null) {
            long min1 = range1.minValue.longValue();
            long max1 = range1.maxValue.longValue();
            long min2 = range2.minValue.longValue();
            long max2 = range2.maxValue.longValue();
            if (max1 < min2 || max2 < min1) {
                return null;
            }
            return new ColStatistics.Range(Math.min(min1, min2), Math.max(max1, max2));
        }
        return null;
    }

    public static boolean isPartitionStats(org.apache.hadoop.hive.ql.metadata.Table table, HiveConf conf) {
        return conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_PART_LEVEL_STATS) && table.isPartitioned() && (!table.isNonNative() || table.getStorageHandler().canSetColStatistics(table));
    }

    public static boolean checkCanProvideStats(org.apache.hadoop.hive.ql.metadata.Table table) {
        return !MetaStoreUtils.isExternalTable((Table)table.getTTable()) || table.isNonNative() && table.getStorageHandler().canProvideBasicStatistics();
    }

    public static boolean checkCanProvidePartitionStats(org.apache.hadoop.hive.ql.metadata.Table table) {
        return !table.isNonNative() || table.getStorageHandler().canProvidePartitionStatistics(table);
    }

    public static boolean areBasicStatsUptoDateForQueryAnswering(org.apache.hadoop.hive.ql.metadata.Table table, Map<String, String> params) {
        return StatsUtils.checkCanProvideStats(table) && StatsSetupConst.areBasicStatsUptoDate(params);
    }

    public static boolean areColumnStatsUptoDateForQueryAnswering(org.apache.hadoop.hive.ql.metadata.Table table, Map<String, String> params, String colName) {
        return StatsUtils.checkCanProvideStats(table) && StatsSetupConst.areColumnStatsUptoDate(params, (String)colName);
    }

    public static void updateStats(Statistics stats, long newNumRows, boolean useColStats, Operator<? extends OperatorDesc> op) {
        StatsUtils.updateStats(stats, newNumRows, useColStats, op, Collections.EMPTY_SET);
    }

    public static void updateStats(Statistics stats, long newNumRows, boolean useColStats, Operator<? extends OperatorDesc> op, Set<String> affectedColumns) {
        if (newNumRows < 0L) {
            LOG.debug("STATS-" + op.toString() + ": Overflow in number of rows. " + newNumRows + " rows will be set to Long.MAX_VALUE");
            newNumRows = StatsUtils.getMaxIfOverflow(newNumRows);
        }
        if (newNumRows == 0L) {
            LOG.debug("STATS-" + op.toString() + ": Equals 0 in number of rows. " + newNumRows + " rows will be set to 1");
            newNumRows = 1L;
        }
        long oldRowCount = stats.getNumRows();
        double ratio = (double)newNumRows / (double)oldRowCount;
        stats.setNumRows(newNumRows);
        if (useColStats) {
            List<ColStatistics> colStats = stats.getColumnStats();
            for (ColStatistics cs : colStats) {
                long oldDV = cs.getCountDistint();
                if (affectedColumns.contains(cs.getColumnName())) {
                    long newDV = oldDV;
                    if (ratio <= 1.0) {
                        newDV = (long)Math.ceil(ratio * (double)oldDV);
                    }
                    cs.setCountDistint(newDV);
                    cs.setFilterColumn();
                    oldDV = newDV;
                }
                if (oldDV > newNumRows) {
                    cs.setCountDistint(newNumRows);
                }
                long newNumNulls = Math.round(ratio * (double)cs.getNumNulls());
                cs.setNumNulls(Math.min(newNumNulls, newNumRows));
            }
            stats.setColumnStats(colStats);
            long newDataSize = StatsUtils.getDataSizeFromColumnStats(newNumRows, colStats);
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
        } else {
            long newDataSize = (long)(ratio * (double)stats.getDataSize());
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
        }
    }

    public static void scaleColStatistics(List<ColStatistics> colStats, double factor) {
        for (ColStatistics cs : colStats) {
            cs.setNumFalses(StatsUtils.safeMult(cs.getNumFalses(), factor));
            cs.setNumTrues(StatsUtils.safeMult(cs.getNumTrues(), factor));
            cs.setNumNulls(StatsUtils.safeMult(cs.getNumNulls(), factor));
            if (!(factor < 1.0)) continue;
            double newNDV = Math.ceil((double)cs.getCountDistint() * factor);
            cs.setCountDistint(newNDV > 9.223372036854776E18 ? Long.MAX_VALUE : (long)newNDV);
        }
    }

    public static long computeNDVGroupingColumns(List<ColStatistics> colStats, Statistics parentStats, boolean expDecay) {
        List<Long> ndvValues = StatsUtils.extractNDVGroupingColumns(colStats, parentStats);
        if (ndvValues == null) {
            return 0L;
        }
        if (ndvValues.isEmpty()) {
            return 1L;
        }
        if (expDecay) {
            return StatsUtils.addWithExpDecay(ndvValues);
        }
        return ndvValues.stream().reduce(1L, StatsUtils::safeMult);
    }

    private static List<Long> extractNDVGroupingColumns(List<ColStatistics> colStats, Statistics parentStats) {
        ArrayList<Long> ndvValues = new ArrayList<Long>(colStats.size());
        for (ColStatistics cs : colStats) {
            if (cs != null) {
                long ndv = cs.getCountDistint();
                if (cs.getNumNulls() > 0L) {
                    ndv = StatsUtils.safeAdd(ndv, 1L);
                }
                ndvValues.add(ndv);
                continue;
            }
            if (parentStats.getColumnStatsState().equals((Object)Statistics.State.COMPLETE)) continue;
            ndvValues = null;
            break;
        }
        return ndvValues;
    }
}

