/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.OperatorContains;
import com.esri.core.geometry.OperatorSimpleRelation;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.esri.HiveGeometryOIHelper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ST_GeometryRelational
extends GenericUDF {
    private static final Logger LOG = LoggerFactory.getLogger(ST_GeometryRelational.class);
    private static final int NUM_ARGS = 2;
    private static final int GEOM_1 = 0;
    private static final int GEOM_2 = 1;
    private transient HiveGeometryOIHelper geomHelper1;
    private transient HiveGeometryOIHelper geomHelper2;
    private transient OperatorSimpleRelation opSimpleRelation;
    private transient boolean firstRun = true;
    private transient boolean geom1IsAccelerated = false;

    protected abstract OperatorSimpleRelation getRelationOperator();

    @Override
    public ObjectInspector initialize(ObjectInspector[] OIs) throws UDFArgumentException {
        this.opSimpleRelation = this.getRelationOperator();
        if (OIs.length != 2) {
            throw new UDFArgumentException("The " + this.opSimpleRelation.getType().toString().toLowerCase() + " relationship operator takes exactly two arguments");
        }
        this.geomHelper1 = HiveGeometryOIHelper.create(OIs[0], 0);
        this.geomHelper2 = HiveGeometryOIHelper.create(OIs[1], 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("OI[0]=" + this.geomHelper1);
            LOG.debug("OI[1]=" + this.geomHelper2);
        }
        this.firstRun = true;
        this.geom1IsAccelerated = false;
        return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        OGCGeometry geom1 = this.geomHelper1.getGeometry(args);
        OGCGeometry geom2 = this.geomHelper2.getGeometry(args);
        if (geom1 == null || geom2 == null) {
            return false;
        }
        if (this.firstRun && this.geomHelper1.isConstant()) {
            this.geom1IsAccelerated = this.opSimpleRelation.accelerateGeometry(geom1.getEsriGeometry(), geom1.getEsriSpatialReference(), Geometry.GeometryAccelerationDegree.enumMedium);
        }
        this.firstRun = false;
        return this.opSimpleRelation.execute(geom1.getEsriGeometry(), geom2.getEsriGeometry(), geom1.getEsriSpatialReference(), null);
    }

    @Override
    public void close() {
        if (this.geom1IsAccelerated && this.geomHelper1 != null && this.geomHelper1.getConstantGeometry() != null) {
            OperatorContains.deaccelerateGeometry((Geometry)this.geomHelper1.getConstantGeometry().getEsriGeometry());
        }
    }
}

