/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class GenericUDFMacro
extends GenericUDF
implements Serializable {
    private static final long serialVersionUID = 2829755821687181020L;
    private String macroName;
    private ExprNodeDesc bodyDesc;
    private transient ExprNodeEvaluator body;
    private List<String> colNames;
    private List<TypeInfo> colTypes;
    private transient ObjectInspectorConverters.Converter[] converters;
    private transient ArrayList<Object> evaluatedArguments;

    public GenericUDFMacro(String macroName, ExprNodeDesc bodyDesc, List<String> colNames, List<TypeInfo> colTypes) {
        this.macroName = macroName;
        this.bodyDesc = bodyDesc;
        this.colNames = colNames;
        this.colTypes = colTypes;
        assert (this.bodyDesc != null);
        assert (colNames.size() == colTypes.size());
    }

    public GenericUDFMacro() {
    }

    public boolean isDeterministic() {
        if (this.body != null) {
            return this.body.isDeterministic();
        }
        return true;
    }

    public boolean isStateful() {
        if (this.body != null) {
            return this.body.isStateful();
        }
        return false;
    }

    public boolean isRuntimeConstant() {
        if (this.body != null) {
            return this.body.isRuntimeConstant();
        }
        return false;
    }

    private void checkNotNull(Object object, String msg) {
        if (object == null) {
            throw new NullPointerException(msg);
        }
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkNotNull(this.colTypes, "colTypes");
        this.checkNotNull(arguments, "arguments");
        this.checkNotNull(this.bodyDesc, "bodyDesc");
        if (this.colTypes.size() != arguments.length) {
            throw new UDFArgumentLengthException("The macro " + this.macroName + " accepts exactly " + this.colTypes.size() + " arguments.");
        }
        try {
            this.body = ExprNodeEvaluatorFactory.get(this.bodyDesc);
        }
        catch (HiveException ex) {
            throw new UDFArgumentException((Throwable)ex);
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        ArrayList<ObjectInspector> colObjectInspectors = new ArrayList<ObjectInspector>(this.colTypes.size());
        for (int index = 0; index < arguments.length; ++index) {
            ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)this.colTypes.get(index));
            colObjectInspectors.add(objectInspector);
            this.converters[index] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[index], (ObjectInspector)objectInspector);
        }
        this.evaluatedArguments = new ArrayList(arguments.length);
        StandardStructObjectInspector structOI = ObjectInspectorFactory.getStandardStructObjectInspector(this.colNames, colObjectInspectors);
        try {
            return this.body.initialize((ObjectInspector)structOI);
        }
        catch (HiveException ex) {
            throw new UDFArgumentException((Throwable)ex);
        }
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.evaluatedArguments.clear();
        for (int index = 0; index < arguments.length; ++index) {
            this.evaluatedArguments.add(this.converters[index].convert(arguments[index].get()));
        }
        return this.body.evaluate(this.evaluatedArguments);
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.macroName, children);
    }

    public void setMacroName(String macroName) {
        this.macroName = macroName;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void setBody(ExprNodeDesc bodyDesc) {
        this.bodyDesc = bodyDesc;
    }

    public ExprNodeDesc getBody() {
        return this.bodyDesc;
    }

    public void setColNames(List<String> colNames) {
        this.colNames = colNames;
    }

    public List<String> getColNames() {
        return this.colNames;
    }

    public void setColTypes(List<TypeInfo> colTypes) {
        this.colTypes = colTypes;
    }

    public List<TypeInfo> getColTypes() {
        return this.colTypes;
    }
}

