/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.sampling.PreambleUtil;
import org.apache.datasketches.sampling.SampleSubsetSummary;
import org.apache.datasketches.sampling.SamplingUtil;
import org.apache.datasketches.sampling.VarOptItemsSamples;

public final class VarOptItemsSketch<T> {
    private static final int MIN_LG_ARR_ITEMS = 4;
    private static final ResizeFactor DEFAULT_RESIZE_FACTOR = ResizeFactor.X8;
    private static final ArrayOfBooleansSerDe MARK_SERDE = new ArrayOfBooleansSerDe();
    private int k_;
    private int currItemsAlloc_;
    private final ResizeFactor rf_;
    private ArrayList<T> data_;
    private ArrayList<Double> weights_;
    private long n_;
    private int h_;
    private int m_;
    private int r_;
    private double totalWtR_;
    private int numMarksInH_;
    private ArrayList<Boolean> marks_;

    private VarOptItemsSketch(int k, ResizeFactor rf) {
        if (k < 1 || k > 0x7FFFFFFE) {
            throw new SketchesArgumentException("k must be at least 1 and less than 2147483647. Found: " + k);
        }
        this.k_ = k;
        this.n_ = 0L;
        this.rf_ = rf;
        this.h_ = 0;
        this.m_ = 0;
        this.r_ = 0;
        this.totalWtR_ = 0.0;
        this.numMarksInH_ = 0;
        int ceilingLgK = Util.exactLog2OfInt(Util.ceilingPowerOf2(this.k_), "VarOptItemsSketch");
        int initialLgSize = SamplingUtil.startingSubMultiple(ceilingLgK, this.rf_.lg(), 4);
        this.currItemsAlloc_ = SamplingUtil.getAdjustedSize(this.k_, 1 << initialLgSize);
        if (this.currItemsAlloc_ == this.k_) {
            ++this.currItemsAlloc_;
        }
        this.data_ = new ArrayList(this.currItemsAlloc_);
        this.weights_ = new ArrayList(this.currItemsAlloc_);
        this.marks_ = null;
    }

    private VarOptItemsSketch(ArrayList<T> dataList, ArrayList<Double> weightList, int k, long n, int currItemsAlloc, ResizeFactor rf, int hCount, int rCount, double totalWtR) {
        assert (dataList != null);
        assert (weightList != null);
        assert (dataList.size() == weightList.size());
        assert (currItemsAlloc >= dataList.size());
        assert (k >= 2);
        assert (n >= 0L);
        assert (hCount >= 0);
        assert (rCount >= 0);
        assert (rCount == 0 && dataList.size() == hCount || rCount > 0 && dataList.size() == k + 1);
        this.k_ = k;
        this.n_ = n;
        this.h_ = hCount;
        this.r_ = rCount;
        this.m_ = 0;
        this.totalWtR_ = totalWtR;
        this.currItemsAlloc_ = currItemsAlloc;
        this.rf_ = rf;
        this.data_ = dataList;
        this.weights_ = weightList;
        this.numMarksInH_ = 0;
        this.marks_ = null;
    }

    public static <T> VarOptItemsSketch<T> newInstance(int k) {
        return new VarOptItemsSketch<T>(k, DEFAULT_RESIZE_FACTOR);
    }

    public static <T> VarOptItemsSketch<T> newInstance(int k, ResizeFactor rf) {
        return new VarOptItemsSketch<T>(k, rf);
    }

    static <T> VarOptItemsSketch<T> newInstanceAsGadget(int k) {
        VarOptItemsSketch<T> sketch = new VarOptItemsSketch<T>(k, DEFAULT_RESIZE_FACTOR);
        sketch.marks_ = new ArrayList(sketch.currItemsAlloc_);
        return sketch;
    }

    static <T> VarOptItemsSketch<T> newInstanceFromUnionResult(ArrayList<T> dataList, ArrayList<Double> weightList, int k, long n, int hCount, int rCount, double totalWtR) {
        VarOptItemsSketch<T> sketch = new VarOptItemsSketch<T>(dataList, weightList, k, n, dataList.size(), DEFAULT_RESIZE_FACTOR, hCount, rCount, totalWtR);
        super.convertToHeap();
        return sketch;
    }

    public static <T> VarOptItemsSketch<T> heapify(Memory srcMem, ArrayOfItemsSerDe<T> serDe) {
        boolean isGadget;
        int numPreLongs = PreambleUtil.getAndCheckPreLongs(srcMem);
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(srcMem));
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyId = PreambleUtil.extractFamilyID(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        boolean isEmpty = (flags & 4) != 0;
        boolean bl = isGadget = (flags & 0x80) != 0;
        if (isEmpty) {
            if (numPreLongs != PreambleUtil.VO_PRELONGS_EMPTY) {
                throw new SketchesArgumentException("Possible corruption: Must be " + PreambleUtil.VO_PRELONGS_EMPTY + " for an empty sketch. Found: " + numPreLongs);
            }
        } else if (numPreLongs != 3 && numPreLongs != PreambleUtil.VO_PRELONGS_FULL) {
            throw new SketchesArgumentException("Possible corruption: Must be 3 or " + PreambleUtil.VO_PRELONGS_FULL + " for a non-empty sketch. Found: " + numPreLongs);
        }
        if (serVer != 2) {
            throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 2: " + serVer);
        }
        int reqFamilyId = Family.VAROPT.getID();
        if (familyId != reqFamilyId) {
            throw new SketchesArgumentException("Possible Corruption: FamilyID must be " + reqFamilyId + ": " + familyId);
        }
        int k = PreambleUtil.extractK(srcMem);
        if (k < 1) {
            throw new SketchesArgumentException("Possible Corruption: k must be at least 1: " + k);
        }
        if (isEmpty) {
            assert (numPreLongs == Family.VAROPT.getMinPreLongs());
            return new VarOptItemsSketch<T>(k, rf);
        }
        long n = PreambleUtil.extractN(srcMem);
        if (n < 0L) {
            throw new SketchesArgumentException("Possible Corruption: n cannot be negative: " + n);
        }
        int hCount = PreambleUtil.extractHRegionItemCount(srcMem);
        int rCount = PreambleUtil.extractRRegionItemCount(srcMem);
        if (hCount < 0) {
            throw new SketchesArgumentException("Possible Corruption: H region count cannot be negative: " + hCount);
        }
        if (rCount < 0) {
            throw new SketchesArgumentException("Possible Corruption: R region count cannot be negative: " + rCount);
        }
        double totalRWeight = 0.0;
        if (numPreLongs == Family.VAROPT.getMaxPreLongs()) {
            if (rCount > 0) {
                totalRWeight = PreambleUtil.extractTotalRWeight(srcMem);
            } else {
                throw new SketchesArgumentException("Possible Corruption: " + Family.VAROPT.getMaxPreLongs() + " preLongs but no items in R region");
            }
        }
        int preLongBytes = numPreLongs << 3;
        int totalItems = hCount + rCount;
        int allocatedItems = k + 1;
        if (rCount == 0) {
            int ceilingLgK = Util.exactLog2OfInt(Util.ceilingPowerOf2(k), "heapify");
            int minLgSize = Util.exactLog2OfInt(Util.ceilingPowerOf2(hCount), "heapify");
            int initialLgSize = SamplingUtil.startingSubMultiple(ceilingLgK, rf.lg(), Math.max(minLgSize, 4));
            allocatedItems = SamplingUtil.getAdjustedSize(k, 1 << initialLgSize);
            if (allocatedItems == k) {
                ++allocatedItems;
            }
        }
        long weightOffsetBytes = 24 + (rCount > 0 ? 8 : 0);
        ArrayList<Double> weightList = new ArrayList<Double>(allocatedItems);
        double[] wts = new double[allocatedItems];
        srcMem.getDoubleArray(weightOffsetBytes, wts, 0, hCount);
        for (int i = 0; i < hCount; ++i) {
            if (wts[i] <= 0.0) {
                throw new SketchesArgumentException("Possible Corruption: Non-positive weight in heapify(): " + wts[i]);
            }
            weightList.add(wts[i]);
        }
        long markBytes = 0L;
        int markCount = 0;
        ArrayList<Boolean> markList = null;
        if (isGadget) {
            Boolean[] markArray;
            long markOffsetBytes = (long)preLongBytes + (long)hCount * 8L;
            markBytes = ArrayOfBooleansSerDe.computeBytesNeeded(hCount);
            markList = new ArrayList<Boolean>(allocatedItems);
            ArrayOfBooleansSerDe booleansSerDe = new ArrayOfBooleansSerDe();
            for (Boolean mark : markArray = booleansSerDe.deserializeFromMemory(srcMem.region(markOffsetBytes, (long)((hCount >>> 3) + 1)), 0L, hCount)) {
                if (!mark.booleanValue()) continue;
                ++markCount;
            }
            markList.addAll(Arrays.asList(markArray));
        }
        long offsetBytes = (long)preLongBytes + (long)hCount * 8L + markBytes;
        T[] data = serDe.deserializeFromMemory(srcMem.region(offsetBytes, srcMem.getCapacity() - offsetBytes), 0L, totalItems);
        List<T> wrappedData = Arrays.asList(data);
        ArrayList<T> dataList = new ArrayList<T>(allocatedItems);
        dataList.addAll(wrappedData.subList(0, hCount));
        if (rCount > 0) {
            weightList.add(-1.0);
            if (isGadget) {
                markList.add(false);
            }
            for (int i = 0; i < rCount; ++i) {
                weightList.add(-1.0);
                if (!isGadget) continue;
                markList.add(false);
            }
            dataList.add(null);
            dataList.addAll(wrappedData.subList(hCount, totalItems));
        }
        VarOptItemsSketch sketch = new VarOptItemsSketch(dataList, weightList, k, n, allocatedItems, rf, hCount, rCount, totalRWeight);
        if (isGadget) {
            sketch.marks_ = markList;
            sketch.numMarksInH_ = markCount;
        }
        return sketch;
    }

    public int getK() {
        return this.k_;
    }

    public long getN() {
        return this.n_;
    }

    public int getNumSamples() {
        return Math.min(this.k_, this.h_ + this.r_);
    }

    public VarOptItemsSamples<T> getSketchSamples() {
        return new VarOptItemsSamples(this);
    }

    public void update(T item, double weight) {
        this.update(item, weight, false);
    }

    public void reset() {
        int ceilingLgK = Util.exactLog2OfInt(Util.ceilingPowerOf2(this.k_), "VarOptItemsSketch");
        int initialLgSize = SamplingUtil.startingSubMultiple(ceilingLgK, this.rf_.lg(), 4);
        this.currItemsAlloc_ = SamplingUtil.getAdjustedSize(this.k_, 1 << initialLgSize);
        if (this.currItemsAlloc_ == this.k_) {
            ++this.currItemsAlloc_;
        }
        this.data_ = new ArrayList(this.currItemsAlloc_);
        this.weights_ = new ArrayList(this.currItemsAlloc_);
        if (this.marks_ != null) {
            this.marks_ = new ArrayList(this.currItemsAlloc_);
        }
        this.n_ = 0L;
        this.h_ = 0;
        this.m_ = 0;
        this.r_ = 0;
        this.numMarksInH_ = 0;
        this.totalWtR_ = 0.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append(Util.LS);
        sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   k            : ").append(this.k_).append(Util.LS);
        sb.append("   h            : ").append(this.h_).append(Util.LS);
        sb.append("   r            : ").append(this.r_).append(Util.LS);
        sb.append("   weight_r     : ").append(this.totalWtR_).append(Util.LS);
        sb.append("   Current size : ").append(this.currItemsAlloc_).append(Util.LS);
        sb.append("   Resize factor: ").append((Object)this.rf_).append(Util.LS);
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.preambleToString(byteArr);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.preambleToString(mem);
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<? super T> serDe) {
        if (this.r_ == 0 && this.h_ == 0) {
            return this.toByteArray(serDe, null);
        }
        int validIndex = this.h_ == 0 ? 1 : 0;
        Class<?> clazz = this.data_.get(validIndex).getClass();
        return this.toByteArray(serDe, clazz);
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<? super T> serDe, Class<?> clazz) {
        int outBytes;
        int preLongs;
        int flags;
        boolean empty = this.r_ == 0 && this.h_ == 0;
        byte[] itemBytes = null;
        int n = flags = this.marks_ == null ? 0 : 128;
        if (empty) {
            preLongs = Family.VAROPT.getMinPreLongs();
            outBytes = Family.VAROPT.getMinPreLongs() << 3;
            flags |= 4;
        } else {
            preLongs = this.r_ == 0 ? 3 : Family.VAROPT.getMaxPreLongs();
            itemBytes = serDe.serializeToByteArray(this.getDataSamples(clazz));
            int numMarkBytes = this.marks_ == null ? 0 : ArrayOfBooleansSerDe.computeBytesNeeded(this.h_);
            outBytes = (preLongs << 3) + this.h_ * 8 + numMarkBytes + itemBytes.length;
        }
        byte[] outArr = new byte[outBytes];
        WritableMemory mem = WritableMemory.writableWrap((byte[])outArr);
        PreambleUtil.insertPreLongs(mem, preLongs);
        PreambleUtil.insertLgResizeFactor(mem, this.rf_.lg());
        PreambleUtil.insertSerVer(mem, 2);
        PreambleUtil.insertFamilyID(mem, Family.VAROPT.getID());
        PreambleUtil.insertFlags(mem, flags);
        PreambleUtil.insertK(mem, this.k_);
        if (!empty) {
            PreambleUtil.insertN(mem, this.n_);
            PreambleUtil.insertHRegionItemCount(mem, this.h_);
            PreambleUtil.insertRRegionItemCount(mem, this.r_);
            if (this.r_ > 0) {
                PreambleUtil.insertTotalRWeight(mem, this.totalWtR_);
            }
            int offset = preLongs << 3;
            for (int i = 0; i < this.h_; ++i) {
                mem.putDouble((long)offset, this.weights_.get(i).doubleValue());
                offset += 8;
            }
            if (this.marks_ != null) {
                byte[] markBytes = MARK_SERDE.serializeToByteArray(this.marks_.subList(0, this.h_).toArray(new Boolean[0]));
                mem.putByteArray((long)offset, markBytes, 0, markBytes.length);
                offset += markBytes.length;
            }
            mem.putByteArray((long)offset, itemBytes, 0, itemBytes.length);
        }
        return outArr;
    }

    public SampleSubsetSummary estimateSubsetSum(Predicate<T> predicate) {
        int idx;
        if (this.n_ == 0L) {
            return new SampleSubsetSummary(0.0, 0.0, 0.0, 0.0);
        }
        double totalWtH = 0.0;
        double hTrueWeight = 0.0;
        for (idx = 0; idx < this.h_; ++idx) {
            double wt = this.weights_.get(idx);
            totalWtH += wt;
            if (!predicate.test(this.data_.get(idx))) continue;
            hTrueWeight += wt;
        }
        if (this.r_ == 0) {
            return new SampleSubsetSummary(hTrueWeight, hTrueWeight, hTrueWeight, hTrueWeight);
        }
        long numSampled = this.n_ - (long)this.h_;
        assert (numSampled > 0L);
        double effectiveSamplingRate = (double)this.r_ / (double)numSampled;
        assert (effectiveSamplingRate >= 0.0);
        assert (effectiveSamplingRate <= 1.0);
        int rTrueCount = 0;
        ++idx;
        while (idx < this.k_ + 1) {
            if (predicate.test(this.data_.get(idx))) {
                ++rTrueCount;
            }
            ++idx;
        }
        double lbTrueFraction = SamplingUtil.pseudoHypergeometricLBonP(this.r_, rTrueCount, effectiveSamplingRate);
        double estimatedTrueFraction = 1.0 * (double)rTrueCount / (double)this.r_;
        double ubTrueFraction = SamplingUtil.pseudoHypergeometricUBonP(this.r_, rTrueCount, effectiveSamplingRate);
        return new SampleSubsetSummary(hTrueWeight + this.totalWtR_ * lbTrueFraction, hTrueWeight + this.totalWtR_ * estimatedTrueFraction, hTrueWeight + this.totalWtR_ * ubTrueFraction, totalWtH + this.totalWtR_);
    }

    Result getSamplesAsArrays() {
        if (this.r_ + this.h_ == 0) {
            return null;
        }
        int validIndex = this.h_ == 0 ? 1 : 0;
        Class<?> clazz = this.data_.get(validIndex).getClass();
        return this.getSamplesAsArrays(clazz);
    }

    VarOptItemsSketch<T> copyAndSetN(boolean asSketch, long adjustedN) {
        VarOptItemsSketch<T> sketch = new VarOptItemsSketch<T>(this.data_, this.weights_, this.k_, this.n_, this.currItemsAlloc_, this.rf_, this.h_, this.r_, this.totalWtR_);
        if (!asSketch) {
            sketch.marks_ = this.marks_;
            sketch.numMarksInH_ = this.numMarksInH_;
        }
        if (adjustedN >= 0L) {
            sketch.n_ = adjustedN;
        }
        return sketch;
    }

    void stripMarks() {
        assert (this.marks_ != null);
        this.numMarksInH_ = 0;
        this.marks_ = null;
    }

    Result getSamplesAsArrays(Class<?> clazz) {
        if (this.r_ + this.h_ == 0) {
            return null;
        }
        int numSamples = this.getNumSamples();
        Object[] prunedItems = (Object[])Array.newInstance(clazz, numSamples);
        double[] prunedWeights = new double[numSamples];
        int j = 0;
        double rWeight = this.totalWtR_ / (double)this.r_;
        int i = 0;
        while (j < numSamples) {
            T item = this.data_.get(i);
            if (item != null) {
                prunedItems[j] = item;
                prunedWeights[j] = this.weights_.get(i) > 0.0 ? this.weights_.get(i) : rWeight;
                ++j;
            }
            ++i;
        }
        Result output = new Result();
        output.items = prunedItems;
        output.weights = prunedWeights;
        return output;
    }

    T getItem(int idx) {
        return this.data_.get(idx);
    }

    double getWeight(int idx) {
        return this.weights_.get(idx);
    }

    boolean getMark(int idx) {
        return this.marks_.get(idx);
    }

    int getHRegionCount() {
        return this.h_;
    }

    int getRRegionCount() {
        return this.r_;
    }

    int getNumMarksInH() {
        return this.numMarksInH_;
    }

    double getTau() {
        return this.r_ == 0 ? Double.NaN : this.totalWtR_ / (double)this.r_;
    }

    double getTotalWtR() {
        return this.totalWtR_;
    }

    void forceSetK(int k) {
        assert (k > 0);
        this.k_ = k;
    }

    void update(T item, double weight, boolean mark) {
        if (item == null) {
            return;
        }
        if (weight <= 0.0) {
            throw new SketchesArgumentException("Item weights must be strictly positive: " + weight + ", for item " + item.toString());
        }
        ++this.n_;
        if (this.r_ == 0) {
            this.updateWarmupPhase(item, weight, mark);
        } else {
            boolean condition2;
            assert (this.h_ == 0 || this.peekMin() >= this.getTau());
            double hypotheticalTau = (weight + this.totalWtR_) / (double)(this.r_ + 1 - 1);
            boolean condition1 = this.h_ == 0 || weight <= this.peekMin();
            boolean bl = condition2 = weight < hypotheticalTau;
            if (condition1 && condition2) {
                this.updateLight(item, weight, mark);
            } else if (this.r_ == 1) {
                this.updateHeavyREq1(item, weight, mark);
            } else {
                this.updateHeavyGeneral(item, weight, mark);
            }
        }
    }

    void decreaseKBy1() {
        if (this.k_ <= 1) {
            throw new SketchesStateException("Cannot decrease k below 1 in union");
        }
        if (this.h_ == 0 && this.r_ == 0) {
            --this.k_;
        } else if (this.h_ > 0 && this.r_ == 0) {
            --this.k_;
            if (this.h_ > this.k_) {
                this.transitionFromWarmup();
            }
        } else if (this.h_ > 0 && this.r_ > 0) {
            int oldGapIdx = this.h_;
            int oldFinalRIdx = this.h_ + 1 + this.r_ - 1;
            assert (oldFinalRIdx == this.k_);
            this.swapValues(oldFinalRIdx, oldGapIdx);
            int pulledIdx = this.h_ - 1;
            T pulledItem = this.data_.get(pulledIdx);
            double pulledWeight = this.weights_.get(pulledIdx);
            boolean pulledMark = this.marks_.get(pulledIdx);
            if (pulledMark) {
                --this.numMarksInH_;
            }
            this.weights_.set(pulledIdx, -1.0);
            --this.h_;
            --this.k_;
            --this.n_;
            this.update(pulledItem, pulledWeight, pulledMark);
        } else if (this.h_ == 0 && this.r_ > 0) {
            assert (this.r_ >= 2);
            int rIdxToDelete = 1 + SamplingUtil.rand().nextInt(this.r_);
            int rightmostRIdx = 1 + this.r_ - 1;
            this.swapValues(rIdxToDelete, rightmostRIdx);
            this.weights_.set(rightmostRIdx, -1.0);
            --this.k_;
            --this.r_;
        }
    }

    private void updateLight(T item, double weight, boolean mark) {
        assert (this.r_ >= 1);
        assert (this.r_ + this.h_ == this.k_);
        int mSlot = this.h_;
        this.data_.set(mSlot, item);
        this.weights_.set(mSlot, weight);
        if (this.marks_ != null) {
            this.marks_.set(mSlot, mark);
        }
        ++this.m_;
        this.growCandidateSet(this.totalWtR_ + weight, this.r_ + 1);
    }

    private void updateHeavyGeneral(T item, double weight, boolean mark) {
        assert (this.m_ == 0);
        assert (this.r_ >= 2);
        assert (this.r_ + this.h_ == this.k_);
        this.push(item, weight, mark);
        this.growCandidateSet(this.totalWtR_, this.r_);
    }

    private void updateHeavyREq1(T item, double weight, boolean mark) {
        assert (this.m_ == 0);
        assert (this.r_ == 1);
        assert (this.r_ + this.h_ == this.k_);
        this.push(item, weight, mark);
        this.popMinToMRegion();
        int mSlot = this.k_ - 1;
        this.growCandidateSet(this.weights_.get(mSlot) + this.totalWtR_, 2);
    }

    private void updateWarmupPhase(T item, double wt, boolean mark) {
        assert (this.r_ == 0);
        assert (this.m_ == 0);
        assert (this.h_ <= this.k_);
        if (this.h_ >= this.currItemsAlloc_) {
            this.growDataArrays();
        }
        this.data_.add(this.h_, item);
        this.weights_.add(this.h_, wt);
        if (this.marks_ != null) {
            this.marks_.add(this.h_, mark);
        }
        ++this.h_;
        this.numMarksInH_ += mark ? 1 : 0;
        if (this.h_ > this.k_) {
            this.transitionFromWarmup();
        }
    }

    private void transitionFromWarmup() {
        this.convertToHeap();
        this.popMinToMRegion();
        this.popMinToMRegion();
        --this.m_;
        ++this.r_;
        assert (this.h_ == this.k_ - 1);
        assert (this.m_ == 1);
        assert (this.r_ == 1);
        this.totalWtR_ = this.weights_.get(this.k_);
        this.weights_.set(this.k_, -1.0);
        this.growCandidateSet(this.weights_.get(this.k_ - 1) + this.totalWtR_, 2);
    }

    private void convertToHeap() {
        int lastNonLeaf;
        if (this.h_ < 2) {
            return;
        }
        int lastSlot = this.h_ - 1;
        for (int j = lastNonLeaf = (lastSlot + 1) / 2 - 1; j >= 0; --j) {
            this.restoreTowardsLeaves(j);
        }
    }

    private void restoreTowardsLeaves(int slotIn) {
        assert (this.h_ > 0);
        int lastSlot = this.h_ - 1;
        assert (slotIn <= lastSlot);
        int slot = slotIn;
        int child = 2 * slotIn + 1;
        while (child <= lastSlot) {
            int child2 = child + 1;
            if (child2 <= lastSlot && this.weights_.get(child2) < this.weights_.get(child)) {
                child = child2;
            }
            if (this.weights_.get(slot) <= this.weights_.get(child)) break;
            this.swapValues(slot, child);
            slot = child;
            child = 2 * slot + 1;
        }
    }

    private void restoreTowardsRoot(int slotIn) {
        int slot = slotIn;
        int p = (slot + 1) / 2 - 1;
        while (slot > 0 && this.weights_.get(slot) < this.weights_.get(p)) {
            this.swapValues(slot, p);
            slot = p;
            p = (slot + 1) / 2 - 1;
        }
    }

    private void push(T item, double wt, boolean mark) {
        this.data_.set(this.h_, item);
        this.weights_.set(this.h_, wt);
        if (this.marks_ != null) {
            this.marks_.set(this.h_, mark);
            this.numMarksInH_ += mark ? 1 : 0;
        }
        ++this.h_;
        this.restoreTowardsRoot(this.h_ - 1);
    }

    private double peekMin() {
        assert (this.h_ > 0);
        return this.weights_.get(0);
    }

    private void popMinToMRegion() {
        assert (this.h_ > 0);
        assert (this.h_ + this.m_ + this.r_ == this.k_ + 1);
        if (this.h_ == 1) {
            ++this.m_;
            --this.h_;
        } else {
            int tgt = this.h_ - 1;
            this.swapValues(0, tgt);
            ++this.m_;
            --this.h_;
            this.restoreTowardsLeaves(0);
        }
        if (this.isMarked(this.h_)) {
            --this.numMarksInH_;
        }
    }

    private void growCandidateSet(double wtCands, int numCands) {
        double nextTotWt;
        double nextWt;
        assert (this.h_ + this.m_ + this.r_ == this.k_ + 1);
        assert (numCands >= 2);
        assert (numCands == this.m_ + this.r_);
        assert (this.m_ == 0 || this.m_ == 1);
        while (this.h_ > 0 && (nextWt = this.peekMin()) * (double)numCands < (nextTotWt = wtCands + nextWt)) {
            wtCands = nextTotWt;
            ++numCands;
            this.popMinToMRegion();
        }
        this.downsampleCandidateSet(wtCands, numCands);
    }

    private int pickRandomSlotInR() {
        assert (this.r_ > 0);
        int offset = this.h_ + this.m_;
        if (this.r_ == 1) {
            return offset;
        }
        return offset + SamplingUtil.rand().nextInt(this.r_);
    }

    private int chooseDeleteSlot(double wtCand, int numCand) {
        int firstRSlot;
        assert (this.r_ > 0);
        if (this.m_ == 0) {
            return this.pickRandomSlotInR();
        }
        if (this.m_ == 1) {
            double wtMCand = this.weights_.get(this.h_);
            if (wtCand * SamplingUtil.nextDoubleExcludeZero() < (double)(numCand - 1) * wtMCand) {
                return this.pickRandomSlotInR();
            }
            return this.h_;
        }
        int deleteSlot = this.chooseWeightedDeleteSlot(wtCand, numCand);
        if (deleteSlot == (firstRSlot = this.h_ + this.m_)) {
            return this.pickRandomSlotInR();
        }
        return deleteSlot;
    }

    private int chooseWeightedDeleteSlot(double wtCand, int numCand) {
        assert (this.m_ >= 1);
        int offset = this.h_;
        int finalM = offset + this.m_ - 1;
        int numToKeep = numCand - 1;
        double leftSubtotal = 0.0;
        double rightSubtotal = -1.0 * wtCand * SamplingUtil.nextDoubleExcludeZero();
        for (int i = offset; i <= finalM; ++i) {
            if (!((leftSubtotal += (double)numToKeep * this.weights_.get(i)) < (rightSubtotal += wtCand))) continue;
            return i;
        }
        return finalM + 1;
    }

    private void downsampleCandidateSet(double wtCands, int numCands) {
        assert (numCands >= 2);
        assert (this.h_ + numCands == this.k_ + 1);
        int deleteSlot = this.chooseDeleteSlot(wtCands, numCands);
        int leftmostCandSlot = this.h_;
        assert (deleteSlot >= leftmostCandSlot);
        assert (deleteSlot <= this.k_);
        int stopIdx = leftmostCandSlot + this.m_;
        for (int j = leftmostCandSlot; j < stopIdx; ++j) {
            this.weights_.set(j, -1.0);
        }
        this.data_.set(deleteSlot, this.data_.get(leftmostCandSlot));
        this.data_.set(leftmostCandSlot, null);
        this.m_ = 0;
        this.r_ = numCands - 1;
        this.totalWtR_ = wtCands;
    }

    private void swapValues(int src, int dst) {
        T item = this.data_.get(src);
        this.data_.set(src, this.data_.get(dst));
        this.data_.set(dst, item);
        Double wt = this.weights_.get(src);
        this.weights_.set(src, this.weights_.get(dst));
        this.weights_.set(dst, wt);
        if (this.marks_ != null) {
            Boolean mark = this.marks_.get(src);
            this.marks_.set(src, this.marks_.get(dst));
            this.marks_.set(dst, mark);
        }
    }

    private boolean isMarked(int idx) {
        return this.marks_ != null ? this.marks_.get(idx) : false;
    }

    private T[] getDataSamples(Class<?> clazz) {
        assert (this.h_ + this.r_ > 0);
        Object[] prunedList = (Object[])Array.newInstance(clazz, this.getNumSamples());
        int i = 0;
        for (T item : this.data_) {
            if (item == null) continue;
            prunedList[i++] = item;
        }
        return prunedList;
    }

    private void growDataArrays() {
        this.currItemsAlloc_ = SamplingUtil.getAdjustedSize(this.k_, this.currItemsAlloc_ << this.rf_.lg());
        if (this.currItemsAlloc_ == this.k_) {
            ++this.currItemsAlloc_;
        }
        this.data_.ensureCapacity(this.currItemsAlloc_);
        this.weights_.ensureCapacity(this.currItemsAlloc_);
        if (this.marks_ != null) {
            this.marks_.ensureCapacity(this.currItemsAlloc_);
        }
    }

    class Result {
        T[] items;
        double[] weights;

        Result() {
        }
    }
}

