/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.metrics;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.model.AtlasBaseModelObject;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.commons.collections.CollectionUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasMetricsStat
extends AtlasBaseModelObject
implements Serializable {
    public static final String METRICS_CATEGORY_GENERAL_PROPERTY = "general";
    public static final String METRICS_COLLECTION_TIME_PROPERTY = "collectionTime";
    public static final String METRICS_ID_PREFIX_PROPERTY = "atlas_metrics_";
    private String metricsId;
    private long collectionTime;
    private long timeToLiveMillis;
    private Map<String, Object> typeData;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private AtlasMetrics metrics;

    public AtlasMetricsStat() {
    }

    public AtlasMetricsStat(String guid) {
        this.setGuid(guid);
    }

    public AtlasMetricsStat(AtlasMetrics metrics) {
        this(metrics, null);
    }

    public AtlasMetricsStat(AtlasMetrics metrics, List<String> listOfTypeNames) {
        this(metrics, TimeUnit.HOURS.toMillis(AtlasConfiguration.METRICS_TIME_TO_LIVE_HOURS.getInt()), listOfTypeNames);
    }

    public AtlasMetricsStat(AtlasMetrics metrics, long timeToLiveMillis, List<String> listOfTypeNames) {
        this.collectionTime = metrics == null ? System.currentTimeMillis() : (Long)metrics.getMetric(METRICS_CATEGORY_GENERAL_PROPERTY, METRICS_COLLECTION_TIME_PROPERTY);
        this.setCollectionTime(this.collectionTime);
        this.setMetricsId(METRICS_ID_PREFIX_PROPERTY + this.getCollectionTime() + "@" + AtlasEntityUtil.getMetadataNamespace());
        this.setTimeToLiveMillis(timeToLiveMillis);
        this.setMetrics(metrics);
        this.setGuid(this.getGuid());
        this.typeData = CollectionUtils.isEmpty(listOfTypeNames) ? null : new HashMap();
        AtlasEntityUtil.metricsToTypeData(metrics, listOfTypeNames, this.typeData);
    }

    public String getMetricsId() {
        return this.metricsId;
    }

    public void setMetricsId(String metricsId) {
        this.metricsId = metricsId;
    }

    public long getCollectionTime() {
        return this.collectionTime;
    }

    public void setCollectionTime(long collectionTime) {
        this.collectionTime = collectionTime;
    }

    public long getTimeToLiveMillis() {
        return this.timeToLiveMillis;
    }

    public void setTimeToLiveMillis(long timeToLiveMillis) {
        this.timeToLiveMillis = timeToLiveMillis;
    }

    public AtlasMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(AtlasMetrics metrics) {
        this.metrics = metrics;
    }

    public Map<String, Object> getTypeData() {
        return this.typeData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasMetricsStat that = (AtlasMetricsStat)o;
        return Objects.equals(this.metrics, that.metrics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.metrics);
    }

    @Override
    protected StringBuilder toString(StringBuilder sb) {
        sb.append(", metricsId=").append(this.metricsId);
        sb.append(", collectionTime=").append(this.collectionTime);
        sb.append(", timeToLiveMillis=").append(this.timeToLiveMillis);
        sb.append(", metrics=");
        if (this.metrics == null) {
            sb.append("null");
        } else {
            sb.append(this.metrics);
        }
        return sb;
    }
}

