/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.TimeUnit;
import javax.jdo.JDOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.AbstractHMSHandlerProxy;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.DeadlineException;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.datanucleus.exceptions.NucleusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RetryingHMSHandler
extends AbstractHMSHandlerProxy {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingHMSHandler.class);
    private final long retryInterval;
    private final int retryLimit;

    public RetryingHMSHandler(Configuration conf, IHMSHandler baseHandler, boolean local) throws MetaException {
        super(conf, baseHandler, local);
        this.retryInterval = MetastoreConf.getTimeVar((Configuration)this.origConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        this.retryLimit = MetastoreConf.getIntVar((Configuration)this.origConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS);
        try {
            this.invoke(baseHandler, baseHandler.getClass().getDeclaredMethod("init", null), null);
        }
        catch (Throwable e) {
            LOG.error("HMSHandler Fatal error: " + ExceptionUtils.getStackTrace((Throwable)e));
            MetaException me = new MetaException(e.getMessage());
            me.initCause(e);
            throw me;
        }
    }

    @Override
    protected void initBaseHandler() throws MetaException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractHMSHandlerProxy.Result invokeInternal(Object proxy, Method method, Object[] args) throws Throwable {
        boolean gotNewConnectUrl = false;
        if (this.reloadConf) {
            MetaStoreInit.updateConnectionURL(this.origConf, this.getActiveConf(), null, this.metaStoreInitData);
        }
        int retryCount = 0;
        Throwable caughtException = null;
        while (true) {
            try {
                if (this.reloadConf || gotNewConnectUrl) {
                    this.baseHandler.setConf(this.getActiveConf());
                }
                Object object = null;
                boolean isStarted = Deadline.startTimer(method.getName());
                try {
                    object = method.invoke((Object)this.baseHandler, args);
                }
                finally {
                    if (isStarted) {
                        Deadline.stopTimer();
                    }
                }
                StringBuilder additionalInfo = new StringBuilder();
                additionalInfo.append("retryCount=").append(retryCount).append(" error=").append(false);
                return new AbstractHMSHandlerProxy.Result(object, additionalInfo.toString());
            }
            catch (UndeclaredThrowableException e) {
                if (e.getCause() != null) {
                    if (e.getCause() instanceof JDOException) {
                        caughtException = e.getCause();
                    }
                    if (e.getCause() instanceof MetaException && e.getCause().getCause() != null && e.getCause().getCause() instanceof JDOException) {
                        caughtException = e.getCause().getCause();
                    }
                    LOG.error(ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                    throw e.getCause();
                }
                LOG.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof JDOException) {
                    caughtException = e.getCause();
                }
                if (e.getCause() instanceof NoSuchObjectException || e.getTargetException().getCause() instanceof NoSuchObjectException) {
                    String methodName = method.getName();
                    if (!(methodName.startsWith("get_database") || methodName.startsWith("get_table") || methodName.startsWith("get_partition") || methodName.startsWith("get_function") || methodName.startsWith("get_stored_procedure") || methodName.startsWith("find_package"))) {
                        LOG.error(ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                    }
                    throw e.getCause();
                }
                if (e.getCause() instanceof MetaException && e.getCause().getCause() != null) {
                    if (e.getCause().getCause() instanceof JDOException || e.getCause().getCause() instanceof NucleusException) {
                        caughtException = e.getCause().getCause();
                    }
                    if (e.getCause().getCause() instanceof DeadlineException) {
                        Deadline.clear();
                        LOG.error("Error happens in method " + method.getName() + ": " + ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                        throw e.getCause();
                    }
                    LOG.error(ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                    throw e.getCause();
                }
                LOG.error(ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                throw e.getCause();
            }
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)caughtException);
            String errorMessage = ExceptionUtils.getMessage((Throwable)caughtException) + (String)(rootCause == null ? "" : "\nRoot cause: " + rootCause);
            if (retryCount >= this.retryLimit || !this.isRecoverableException(caughtException)) {
                LOG.error("HMSHandler Fatal error: " + ExceptionUtils.getStackTrace((Throwable)caughtException));
                throw new MetaException(errorMessage);
            }
            assert (this.retryInterval >= 0L);
            LOG.error(String.format("Retrying HMSHandler after %d ms (attempt %d of %d)", this.retryInterval, ++retryCount, this.retryLimit) + " with error: " + ExceptionUtils.getStackTrace((Throwable)caughtException));
            Thread.sleep(this.retryInterval);
            String lastUrl = MetaStoreInit.getConnectionURL(this.getActiveConf());
            gotNewConnectUrl = MetaStoreInit.updateConnectionURL(this.origConf, this.getActiveConf(), lastUrl, this.metaStoreInitData);
        }
    }

    private boolean isRecoverableException(Throwable t) {
        if (!(t instanceof JDOException) && !(t instanceof NucleusException)) {
            return false;
        }
        return DatabaseProduct.isRecoverableException(t);
    }
}

