/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.AuditLeaderListener;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.leader.LeaderElectionFactory;
import org.apache.hadoop.hive.metastore.leader.LeaderException;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class LeaderElectionContext {
    private final Configuration conf;
    private final String servHost;
    private final boolean startAsDaemon;
    private AuditLeaderListener auditLeaderListener;
    private final Map<TTYPE, List<LeaderElection.LeadershipStateListener>> listeners;
    private final List<LeaderElection> leaderElections = new ArrayList<LeaderElection>();
    public static final String LEADER_IN_TEST = "metastore.leader.election.in.test";

    private LeaderElectionContext(String servHost, Configuration conf, Map<TTYPE, List<LeaderElection.LeadershipStateListener>> listeners, boolean startAsDaemon, IHMSHandler handler) throws Exception {
        Objects.requireNonNull(conf, "conf is null");
        Objects.requireNonNull(listeners, "listeners is null");
        this.servHost = servHost;
        this.conf = new Configuration(conf);
        this.startAsDaemon = startAsDaemon;
        String tableName = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_AUDITTABLE);
        if (StringUtils.isNotEmpty((CharSequence)tableName)) {
            TableName table = TableName.fromString((String)tableName, (String)MetaStoreUtils.getDefaultCatalog((Configuration)conf), (String)"default");
            this.auditLeaderListener = new AuditLeaderListener(table, handler);
        }
        this.listeners = listeners;
    }

    public void start() throws Exception {
        Map<TTYPE, List<LeaderElection.LeadershipStateListener>> listenerMap = this.listeners;
        if (this.conf.getBoolean(LEADER_IN_TEST, false)) {
            HashMap<TTYPE, List<LeaderElection.LeadershipStateListener>> newListeners = new HashMap<TTYPE, List<LeaderElection.LeadershipStateListener>>();
            newListeners.put(TTYPE.HOUSEKEEPING, new ArrayList());
            listenerMap.forEach((k, v) -> ((List)newListeners.get((Object)TTYPE.HOUSEKEEPING)).addAll(v));
            listenerMap = newListeners;
        }
        for (Map.Entry<TTYPE, List<LeaderElection.LeadershipStateListener>> entry : listenerMap.entrySet()) {
            List<LeaderElection.LeadershipStateListener> listenerList = entry.getValue();
            if (listenerList.isEmpty()) continue;
            if (this.auditLeaderListener != null) {
                listenerList.add(0, this.auditLeaderListener);
            }
            TTYPE ttype = entry.getKey();
            LeaderElection leaderElection = LeaderElectionFactory.create(this.conf);
            leaderElection.setName(ttype.name);
            listenerList.forEach(listener -> leaderElection.addStateListener((LeaderElection.LeadershipStateListener)listener));
            this.leaderElections.add(leaderElection);
            Thread daemon = new Thread(() -> {
                try {
                    Object mutex = LeaderElectionContext.getLeaderMutex(this.conf, ttype, this.servHost);
                    leaderElection.tryBeLeader(this.conf, mutex);
                }
                catch (LeaderException e) {
                    throw new RuntimeException("Error claiming to be leader: " + leaderElection.getName(), e);
                }
            });
            daemon.setName("Metastore Election " + leaderElection.getName());
            daemon.setDaemon(true);
            if (this.startAsDaemon) {
                daemon.start();
                continue;
            }
            daemon.run();
        }
    }

    public void close() {
        this.leaderElections.forEach(le -> {
            try {
                le.close();
            }
            catch (Exception e) {
                HiveMetaStore.LOG.warn("Error closing election: " + le.getName(), (Throwable)e);
            }
        });
    }

    public static Object getLeaderMutex(Configuration conf, TTYPE ttype, String servHost) {
        String method = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_ELECTION);
        switch (method.toLowerCase()) {
            case "host": {
                return servHost;
            }
            case "lock": {
                TableName mutex = ttype.getTableName();
                String namespace = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_LOCK_NAMESPACE);
                if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                    return new TableName(mutex.getCat(), namespace, mutex.getTable());
                }
                return mutex;
            }
        }
        throw new UnsupportedOperationException(method + " not supported for leader election");
    }

    public static enum TTYPE {
        HOUSEKEEPING(new TableName("hive", "__METASTORE_LEADER_ELECTION__", "metastore_housekeeping"), "housekeeping"),
        WORKER(new TableName("hive", "__METASTORE_LEADER_ELECTION__", "metastore_compactor_worker"), "compactor_worker"),
        ALWAYS_TASKS(new TableName("hive", "__METASTORE_LEADER_ELECTION__", "metastore_always_tasks"), "always_tasks");

        private final TableName mutex;
        private final String name;

        private TTYPE(TableName tableName, String name) {
            this.mutex = tableName;
            this.name = name;
        }

        public TableName getTableName() {
            return this.mutex;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ContextBuilder {
        private Configuration configuration;
        private boolean startAsDaemon;
        private String servHost;
        private IHMSHandler handler;
        private TTYPE ttype = TTYPE.HOUSEKEEPING;
        private Map<TTYPE, List<LeaderElection.LeadershipStateListener>> listeners;

        public ContextBuilder(Configuration conf) {
            this.configuration = conf;
            this.listeners = new HashMap<TTYPE, List<LeaderElection.LeadershipStateListener>>();
            for (TTYPE type : TTYPE.values()) {
                this.listeners.put(type, new ArrayList());
            }
        }

        public ContextBuilder servHost(String hostName) {
            this.servHost = hostName;
            return this;
        }

        public ContextBuilder setHMSHandler(IHMSHandler handler) {
            this.handler = handler;
            return this;
        }

        public ContextBuilder setTType(TTYPE type) {
            this.ttype = type;
            return this;
        }

        public ContextBuilder addListener(LeaderElection.LeadershipStateListener listener) {
            this.listeners.get((Object)this.ttype).add(listener);
            return this;
        }

        public ContextBuilder addListener(LeaderElection.LeadershipStateListener listener, boolean condition) {
            if (condition) {
                this.addListener(listener);
            }
            return this;
        }

        public ContextBuilder startAsDaemon(boolean daemon) {
            this.startAsDaemon = daemon;
            return this;
        }

        public LeaderElectionContext build() throws Exception {
            return new LeaderElectionContext(this.servHost, this.configuration, this.listeners, this.startAsDaemon, this.handler);
        }
    }
}

