/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.messaging.AddCheckConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONAddCheckConstraintMessage
extends AddCheckConstraintMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<String> checkConstraintListJson;

    public JSONAddCheckConstraintMessage() {
    }

    public JSONAddCheckConstraintMessage(String server, String servicePrincipal, List<SQLCheckConstraint> ccs, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.timestamp = timestamp;
        this.checkConstraintListJson = new ArrayList<String>();
        try {
            for (SQLCheckConstraint cc : ccs) {
                this.checkConstraintListJson.add(MessageBuilder.createCheckConstraintObjJson(cc));
            }
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<SQLCheckConstraint> getCheckConstraints() throws Exception {
        ArrayList<SQLCheckConstraint> ccs = new ArrayList<SQLCheckConstraint>();
        for (String ccJson : this.checkConstraintListJson) {
            ccs.add((SQLCheckConstraint)MessageBuilder.getTObj(ccJson, SQLCheckConstraint.class));
        }
        return ccs;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

