/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONAddForeignKeyMessage
extends AddForeignKeyMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<String> foreignKeyListJson;

    public JSONAddForeignKeyMessage() {
    }

    public JSONAddForeignKeyMessage(String server, String servicePrincipal, List<SQLForeignKey> fks, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.timestamp = timestamp;
        this.foreignKeyListJson = new ArrayList<String>();
        try {
            for (SQLForeignKey pk : fks) {
                this.foreignKeyListJson.add(MessageBuilder.createForeignKeyObjJson(pk));
            }
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<SQLForeignKey> getForeignKeys() throws Exception {
        ArrayList<SQLForeignKey> fks = new ArrayList<SQLForeignKey>();
        for (String pkJson : this.foreignKeyListJson) {
            fks.add((SQLForeignKey)MessageBuilder.getTObj(pkJson, SQLForeignKey.class));
        }
        return fks;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

