/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataStruct;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsMetricType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionMetricsData;

public class CompactionMetricsDataConverter {
    public static CompactionMetricsDataStruct dataToStruct(CompactionMetricsData data) throws MetaException {
        CompactionMetricsDataStruct struct = new CompactionMetricsDataStruct();
        struct.setDbname(data.getDbName());
        struct.setTblname(data.getTblName());
        struct.setPartitionname(data.getPartitionName());
        struct.setType(CompactionMetricsDataConverter.dbCompactionMetricType2ThriftType(data.getMetricType()));
        struct.setMetricvalue(data.getMetricValue());
        struct.setVersion(data.getVersion());
        struct.setThreshold(data.getThreshold());
        return struct;
    }

    public static CompactionMetricsData structToData(CompactionMetricsDataStruct struct) throws MetaException {
        return new CompactionMetricsData.Builder().dbName(struct.getDbname()).tblName(struct.getTblname()).partitionName(struct.getPartitionname()).metricType(CompactionMetricsDataConverter.thriftCompactionMetricType2DbType(struct.getType())).metricValue(struct.getMetricvalue()).version(struct.getVersion()).threshold(struct.getThreshold()).build();
    }

    public static CompactionMetricsMetricType dbCompactionMetricType2ThriftType(CompactionMetricsData.MetricType type) throws MetaException {
        switch (type) {
            case NUM_DELTAS: {
                return CompactionMetricsMetricType.NUM_DELTAS;
            }
            case NUM_SMALL_DELTAS: {
                return CompactionMetricsMetricType.NUM_SMALL_DELTAS;
            }
            case NUM_OBSOLETE_DELTAS: {
                return CompactionMetricsMetricType.NUM_OBSOLETE_DELTAS;
            }
        }
        throw new MetaException("Unexpected metric type " + type);
    }

    public static CompactionMetricsData.MetricType thriftCompactionMetricType2DbType(CompactionMetricsMetricType type) throws MetaException {
        switch (type) {
            case NUM_DELTAS: {
                return CompactionMetricsData.MetricType.NUM_DELTAS;
            }
            case NUM_SMALL_DELTAS: {
                return CompactionMetricsData.MetricType.NUM_SMALL_DELTAS;
            }
            case NUM_OBSOLETE_DELTAS: {
                return CompactionMetricsData.MetricType.NUM_OBSOLETE_DELTAS;
            }
        }
        throw new MetaException("Unexpected metric type " + type);
    }
}

