/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.InClauseBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MarkCleanedFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(MarkCleanedFunction.class);
    private final CompactionInfo info;

    public MarkCleanedFunction(CompactionInfo info) {
        this.info = info;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        MapSqlParameterSource param;
        NamedParameterJdbcTemplate jdbcTemplate = jdbcResource.getJdbcTemplate();
        if (!this.info.isAbortedTxnCleanup()) {
            param = new MapSqlParameterSource().addValue("id", (Object)this.info.id).addValue("succeeded", (Object)Character.toString('s'), 1);
            jdbcTemplate.update("INSERT INTO \"COMPLETED_COMPACTIONS\"(\"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\", \"CC_TYPE\", \"CC_TBLPROPERTIES\", \"CC_WORKER_ID\", \"CC_START\", \"CC_END\", \"CC_RUN_AS\", \"CC_HIGHEST_WRITE_ID\", \"CC_META_INFO\", \"CC_HADOOP_JOB_ID\", \"CC_ERROR_MESSAGE\", \"CC_ENQUEUE_TIME\", \"CC_WORKER_VERSION\", \"CC_INITIATOR_ID\", \"CC_INITIATOR_VERSION\", \"CC_NEXT_TXN_ID\", \"CC_TXN_ID\", \"CC_COMMIT_TIME\", \"CC_POOL_NAME\", \"CC_NUMBER_OF_BUCKETS\",\"CC_ORDER_BY\") SELECT \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", :succeeded, \"CQ_TYPE\", \"CQ_TBLPROPERTIES\", \"CQ_WORKER_ID\", \"CQ_START\", " + TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct()) + ", \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_META_INFO\", \"CQ_HADOOP_JOB_ID\", \"CQ_ERROR_MESSAGE\", \"CQ_ENQUEUE_TIME\", \"CQ_WORKER_VERSION\", \"CQ_INITIATOR_ID\", \"CQ_INITIATOR_VERSION\", \"CQ_NEXT_TXN_ID\", \"CQ_TXN_ID\", \"CQ_COMMIT_TIME\", \"CQ_POOL_NAME\", \"CQ_NUMBER_OF_BUCKETS\", \"CQ_ORDER_BY\" FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = :id", (SqlParameterSource)param);
        }
        this.removeCompactionAndAbortRetryEntries(this.info, jdbcTemplate);
        if (!this.info.isAbortedTxnCleanup()) {
            Object query = "DELETE FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_DATABASE\" = :db AND \"CTC_TABLE\" = :table";
            if (this.info.partName != null) {
                query = (String)query + " AND \"CTC_PARTITION\" = :partition";
            }
            if (this.info.highestWriteId != 0L) {
                query = (String)query + " AND \"CTC_WRITEID\" <= :writeId";
            }
            param = new MapSqlParameterSource().addValue("db", (Object)this.info.dbname).addValue("table", (Object)this.info.tableName).addValue("writeId", (Object)this.info.highestWriteId);
            if (this.info.partName != null) {
                param.addValue("partition", (Object)this.info.partName);
            }
            LOG.debug("Going to execute update <{}>", query);
            int updCount = jdbcTemplate.update((String)query, (SqlParameterSource)param);
            if (updCount < 1) {
                LOG.warn("Expected to remove at least one row from completed_txn_components when marking compaction entry as clean!");
            }
            LOG.debug("Removed {} records from completed_txn_components", (Object)updCount);
        }
        this.removeTxnComponents(this.info, jdbcResource);
        return null;
    }

    private void removeTxnComponents(CompactionInfo info, MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("state", (Object)TxnStatus.ABORTED.getSqlConst(), 1).addValue("db", (Object)info.dbname).addValue("table", (Object)info.tableName).addValue("partition", (Object)info.partName);
        int totalCount = 0;
        if (!info.hasUncompactedAborts && info.highestWriteId != 0L) {
            totalCount = jdbcResource.getJdbcTemplate().update("DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" IN ( SELECT \"TXN_ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = :state) AND \"TC_DATABASE\" = :db AND \"TC_TABLE\" = :table AND (:partition is NULL OR \"TC_PARTITION\" = :partition) AND \"TC_WRITEID\" <= :id", (SqlParameterSource)params.addValue("id", (Object)info.highestWriteId));
        } else if (CollectionUtils.isNotEmpty(info.writeIds)) {
            params.addValue("ids", new ArrayList<Long>(info.writeIds));
            totalCount = jdbcResource.execute(new InClauseBatchCommand("DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" IN ( SELECT \"TXN_ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = :state) AND \"TC_DATABASE\" = :db AND \"TC_TABLE\" = :table AND (:partition is NULL OR \"TC_PARTITION\" = :partition) AND \"TC_WRITEID\" IN (:ids)", (SqlParameterSource)params, "ids", Long::compareTo));
        }
        LOG.debug("Removed {} records from txn_components", (Object)totalCount);
    }

    private void removeCompactionAndAbortRetryEntries(CompactionInfo info, NamedParameterJdbcTemplate jdbcTemplate) {
        String query;
        if (info.id == 0L) {
            return;
        }
        MapSqlParameterSource params = new MapSqlParameterSource("id", (Object)info.id);
        if (info.isAbortedTxnCleanup()) {
            query = "DELETE FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = :id";
        } else {
            query = "DELETE FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = :id OR (\"CQ_DATABASE\" = :db AND \"CQ_TABLE\" = :table AND \"CQ_TYPE\" = :type AND (:partition is NULL OR \"CQ_PARTITION\" = :partition))";
            params.addValue("db", (Object)info.dbname).addValue("table", (Object)info.tableName).addValue("type", (Object)Character.toString('c'), 1).addValue("partition", (Object)info.partName, 12);
        }
        LOG.debug("Going to execute update <{}>", (Object)query);
        int rc = jdbcTemplate.update(query, (SqlParameterSource)params);
        LOG.debug("Removed {} records in COMPACTION_QUEUE", (Object)rc);
    }
}

