/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.service;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidOpenTxnsCounterService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidOpenTxnsCounterService.class);
    private static final int LOG_INTERVAL_MS = 60000;
    private Configuration conf;
    private int isAliveCounter = 0;
    private long lastLogTime = 0L;
    private TxnStore txnHandler;

    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COUNT_OPEN_TXNS_INTERVAL, (TimeUnit)unit);
    }

    public void run() {
        try {
            long start = System.currentTimeMillis();
            ++this.isAliveCounter;
            this.txnHandler.countOpenTxns();
            long now = System.currentTimeMillis();
            if (now - this.lastLogTime > 60000L) {
                LOG.info("Open txn counter ran for {} seconds. isAliveCounter: {}", (Object)((now - start) / 1000L), (Object)this.isAliveCounter);
                this.lastLogTime = now;
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected exception in thread: {}, message: {}", new Object[]{Thread.currentThread().getName(), e.getMessage(), e});
        }
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }
}

