/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.RDBMSPropertyNames;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class BoneCPConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        int value;
        int size;
        String dbPassword;
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        if ((dbPassword = storeMgr.getConnectionPassword()) == null) {
            dbPassword = "";
        }
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        String dbDriver = storeMgr.getConnectionDriverName();
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            this.loadDriver(dbDriver, clr);
        }
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.jolbox.bonecp.BoneCPDataSource", (String)"bonecp.jar");
        BoneCPConfig config = new BoneCPConfig();
        config.setUsername(dbUser);
        config.setPassword(dbPassword);
        Properties dbProps = BoneCPConnectionPoolFactory.getPropertiesForDriver(storeMgr);
        config.setDriverProperties(dbProps);
        BoneCPDataSource ds = new BoneCPDataSource(config);
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_STATEMENTS) && (size = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_STATEMENTS)) >= 0) {
            ds.setStatementsCacheSize(size);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_POOL_SIZE) && (size = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_POOL_SIZE)) >= 0) {
            ds.setMaxConnectionsPerPartition(size);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_POOL_SIZE) && (size = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_POOL_SIZE)) >= 0) {
            ds.setMinConnectionsPerPartition(size);
        }
        if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_IDLE) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_IDLE)) > 0) {
            ds.setIdleMaxAgeInMinutes((long)value);
        }
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            ds.setDriverClass(dbDriver);
        }
        ds.setJdbcUrl(storeMgr.getConnectionURL());
        ds.setUsername(dbUser);
        ds.setPassword(dbPassword);
        return new BoneCPConnectionPool(ds);
    }

    public class BoneCPConnectionPool
    implements ConnectionPool {
        final BoneCPDataSource dataSource;

        public BoneCPConnectionPool(BoneCPDataSource ds) {
            this.dataSource = ds;
        }

        @Override
        public void close() {
            this.dataSource.close();
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

