/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NoTableManagedException;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ColumnMappingFactory;
import org.datanucleus.store.rdbms.mapping.java.ArrayMapping;
import org.datanucleus.store.rdbms.mapping.java.BigDecimalMapping;
import org.datanucleus.store.rdbms.mapping.java.BigIntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.BitSetMapping;
import org.datanucleus.store.rdbms.mapping.java.BooleanMapping;
import org.datanucleus.store.rdbms.mapping.java.ByteMapping;
import org.datanucleus.store.rdbms.mapping.java.CharacterMapping;
import org.datanucleus.store.rdbms.mapping.java.CollectionMapping;
import org.datanucleus.store.rdbms.mapping.java.DatastoreIdMapping;
import org.datanucleus.store.rdbms.mapping.java.DateMapping;
import org.datanucleus.store.rdbms.mapping.java.DoubleMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.EnumMapping;
import org.datanucleus.store.rdbms.mapping.java.FileMapping;
import org.datanucleus.store.rdbms.mapping.java.FloatMapping;
import org.datanucleus.store.rdbms.mapping.java.GregorianCalendarMapping;
import org.datanucleus.store.rdbms.mapping.java.IntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.InterfaceMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.LongMapping;
import org.datanucleus.store.rdbms.mapping.java.MapMapping;
import org.datanucleus.store.rdbms.mapping.java.NumberMapping;
import org.datanucleus.store.rdbms.mapping.java.ObjectMapping;
import org.datanucleus.store.rdbms.mapping.java.OptionalMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedLocalFileMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.ShortMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlDateMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlTimeMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlTimestampMapping;
import org.datanucleus.store.rdbms.mapping.java.StringMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMultiMapping;
import org.datanucleus.store.rdbms.mapping.java.UUIDMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class MappingManagerImpl
implements MappingManager {
    protected final RDBMSStoreManager storeMgr;
    protected final ClassLoaderResolver clr;
    protected Map<String, MappedType> mappedTypes = new ConcurrentHashMap<String, MappedType>();

    public MappingManagerImpl(RDBMSStoreManager storeMgr) {
        this.storeMgr = storeMgr;
        this.clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.addMappedType(Boolean.TYPE, BooleanMapping.class);
        this.addMappedType(Byte.TYPE, ByteMapping.class);
        this.addMappedType(Character.TYPE, CharacterMapping.class);
        this.addMappedType(Double.TYPE, DoubleMapping.class);
        this.addMappedType(Float.TYPE, FloatMapping.class);
        this.addMappedType(Integer.TYPE, IntegerMapping.class);
        this.addMappedType(Long.TYPE, LongMapping.class);
        this.addMappedType(Short.TYPE, ShortMapping.class);
        this.addMappedType(Boolean.class, BooleanMapping.class);
        this.addMappedType(Byte.class, ByteMapping.class);
        this.addMappedType(Character.class, CharacterMapping.class);
        this.addMappedType(Double.class, DoubleMapping.class);
        this.addMappedType(Float.class, FloatMapping.class);
        this.addMappedType(Integer.class, IntegerMapping.class);
        this.addMappedType(Long.class, LongMapping.class);
        this.addMappedType(Short.class, ShortMapping.class);
        this.addMappedType(Number.class, NumberMapping.class);
        this.addMappedType(String.class, StringMapping.class);
        this.addMappedType(Enum.class, EnumMapping.class);
        this.addMappedType(Object.class, SerialisedMapping.class);
        this.addMappedType(File.class, FileMapping.class);
        this.addMappedType(Serializable.class, SerialisedMapping.class);
        this.addMappedType(BigDecimal.class, BigDecimalMapping.class);
        this.addMappedType(BigInteger.class, BigIntegerMapping.class);
        this.addMappedType(Calendar.class, GregorianCalendarMapping.class);
        this.addMappedType(GregorianCalendar.class, GregorianCalendarMapping.class);
        this.addMappedType(Date.class, DateMapping.class);
        this.addMappedType(UUID.class, UUIDMapping.class);
        this.addMappedType(java.sql.Date.class, SqlDateMapping.class);
        this.addMappedType(Time.class, SqlTimeMapping.class);
        this.addMappedType(Timestamp.class, SqlTimestampMapping.class);
        this.addMappedType(boolean[].class, ArrayMapping.class);
        this.addMappedType(byte[].class, ArrayMapping.class);
        this.addMappedType(char[].class, ArrayMapping.class);
        this.addMappedType(double[].class, ArrayMapping.class);
        this.addMappedType(float[].class, ArrayMapping.class);
        this.addMappedType(int[].class, ArrayMapping.class);
        this.addMappedType(long[].class, ArrayMapping.class);
        this.addMappedType(short[].class, ArrayMapping.class);
        this.addMappedType(Boolean[].class, ArrayMapping.class);
        this.addMappedType(Byte[].class, ArrayMapping.class);
        this.addMappedType(Character[].class, ArrayMapping.class);
        this.addMappedType(Double[].class, ArrayMapping.class);
        this.addMappedType(Float[].class, ArrayMapping.class);
        this.addMappedType(Integer[].class, ArrayMapping.class);
        this.addMappedType(Long[].class, ArrayMapping.class);
        this.addMappedType(Short[].class, ArrayMapping.class);
        this.addMappedType(Number[].class, ArrayMapping.class);
        this.addMappedType(String[].class, ArrayMapping.class);
        this.addMappedType(Enum[].class, ArrayMapping.class);
        this.addMappedType(BigDecimal[].class, ArrayMapping.class);
        this.addMappedType(BigInteger[].class, ArrayMapping.class);
        this.addMappedType(Date[].class, ArrayMapping.class);
        this.addMappedType(Locale[].class, ArrayMapping.class);
        this.addMappedType(ArrayList.class, CollectionMapping.class);
        this.addMappedType(BitSet.class, BitSetMapping.class);
        this.addMappedType(Collection.class, CollectionMapping.class);
        this.addMappedType(HashMap.class, MapMapping.class);
        this.addMappedType(HashSet.class, CollectionMapping.class);
        this.addMappedType(Hashtable.class, MapMapping.class);
        this.addMappedType(LinkedList.class, CollectionMapping.class);
        this.addMappedType(List.class, CollectionMapping.class);
        this.addMappedType(LinkedHashMap.class, MapMapping.class);
        this.addMappedType(LinkedHashSet.class, CollectionMapping.class);
        this.addMappedType(Map.class, MapMapping.class);
        this.addMappedType(PriorityQueue.class, CollectionMapping.class);
        this.addMappedType(Properties.class, MapMapping.class);
        this.addMappedType(Queue.class, CollectionMapping.class);
        this.addMappedType(Set.class, CollectionMapping.class);
        this.addMappedType(SortedMap.class, MapMapping.class);
        this.addMappedType(SortedSet.class, CollectionMapping.class);
        this.addMappedType(Stack.class, CollectionMapping.class);
        this.addMappedType(TreeMap.class, MapMapping.class);
        this.addMappedType(TreeSet.class, CollectionMapping.class);
        this.addMappedType(Vector.class, CollectionMapping.class);
        this.addMappedType(Optional.class, OptionalMapping.class);
        this.addMappedType(DatastoreId.class, DatastoreIdMapping.class);
        PluginManager pluginMgr = storeMgr.getNucleusContext().getPluginManager();
        ConfigurationElement[] elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.java_mapping", null, null);
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                String javaName = elems[i].getAttribute("java-type").trim();
                String mappingClassName = elems[i].getAttribute("mapping-class");
                if (javaName == null || this.mappedTypes.containsKey(javaName) || StringUtils.isWhitespace((String)mappingClassName)) continue;
                try {
                    Class mappingType = pluginMgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), mappingClassName);
                    try {
                        Class javaType = this.clr.classForName(javaName);
                        if (javaType == null) continue;
                        this.mappedTypes.put(javaName, new MappedType(javaType, mappingType));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                catch (NucleusException jpe) {
                    NucleusLogger.PERSISTENCE.error((Object)Localiser.msg((String)"016004", (Object[])new Object[]{mappingClassName}));
                }
            }
        }
    }

    protected void addMappedType(Class javaType, Class<? extends JavaTypeMapping> mappingType) {
        this.mappedTypes.put(javaType.getName(), new MappedType(javaType, mappingType));
    }

    @Override
    public boolean isSupportedMappedType(String javaTypeName) {
        if (javaTypeName == null) {
            return false;
        }
        MappedType type = this.mappedTypes.get(javaTypeName);
        if (type == null) {
            try {
                Class cls = this.clr.classForName(javaTypeName);
                type = this.findMappedTypeForClass(cls);
                return type != null && type.javaMappingType != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return type.javaMappingType != null;
    }

    @Override
    public Class<? extends JavaTypeMapping> getMappingType(String javaTypeName) {
        if (javaTypeName == null) {
            return null;
        }
        MappedType type = this.mappedTypes.get(javaTypeName);
        if (type != null) {
            return type.javaMappingType;
        }
        TypeManager typeMgr = this.storeMgr.getNucleusContext().getTypeManager();
        TypeConverter defaultTypeConv = typeMgr.getDefaultTypeConverterForType(this.clr.classForName(javaTypeName));
        if (defaultTypeConv != null) {
            return null;
        }
        Class cls = typeMgr.getTypeForSecondClassWrapper(javaTypeName);
        if (cls != null && (type = this.mappedTypes.get(cls.getName())) != null) {
            return type.javaMappingType;
        }
        try {
            cls = this.clr.classForName(javaTypeName);
            type = this.findMappedTypeForClass(cls);
            return type.javaMappingType;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected MappedType findMappedTypeForClass(Class javaType) {
        MappedType type = this.mappedTypes.get(javaType.getName());
        if (type != null) {
            return type;
        }
        Class<?> componentCls = javaType.isArray() ? javaType.getComponentType() : null;
        for (MappedType mappedType : this.mappedTypes.values()) {
            if (mappedType.javaType == javaType) {
                return mappedType;
            }
            if (mappedType.javaType.getName().equals("java.lang.Object") || mappedType.javaType.getName().equals("java.io.Serializable")) continue;
            if (componentCls != null) {
                if (!mappedType.javaType.isArray() || !mappedType.javaType.getComponentType().isAssignableFrom(componentCls)) continue;
                this.mappedTypes.put(javaType.getName(), mappedType);
                return mappedType;
            }
            if (!mappedType.javaType.isAssignableFrom(javaType)) continue;
            this.mappedTypes.put(javaType.getName(), mappedType);
            return mappedType;
        }
        return null;
    }

    @Override
    public JavaTypeMapping getMappingWithColumnMapping(Class javaType, boolean serialised, boolean embedded, ClassLoaderResolver clr) {
        try {
            DatastoreClass datastoreClass = this.storeMgr.getDatastoreClass(javaType.getName(), clr);
            return datastoreClass.getIdMapping();
        }
        catch (NoTableManagedException ex) {
            MappingConverterDetails mcd = this.getMappingClass(javaType, serialised, embedded, null, null);
            Class<? extends JavaTypeMapping> mc = mcd.mappingClass;
            mc = this.getOverrideMappingClass(mc, null, null);
            try {
                JavaTypeMapping m = mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.initialize(this.storeMgr, javaType.getName());
                if (m.hasSimpleDatastoreRepresentation()) {
                    this.createColumnMapping(m, null, m.getJavaTypeForColumnMapping(0));
                }
                return m;
            }
            catch (NucleusUserException nue) {
                throw nue;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
    }

    @Override
    public JavaTypeMapping getMapping(Class javaType) {
        return this.getMapping(javaType, false, false, (String)null);
    }

    @Override
    public JavaTypeMapping getMapping(Class javaType, boolean serialised, boolean embedded, String fieldName) {
        MappingConverterDetails mcd = this.getMappingClass(javaType, serialised, embedded, null, fieldName);
        Class<? extends JavaTypeMapping> mc = mcd.mappingClass;
        mc = this.getOverrideMappingClass(mc, null, null);
        try {
            JavaTypeMapping m = mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            m.initialize(this.storeMgr, javaType.getName());
            return m;
        }
        catch (Exception e) {
            throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
        }
    }

    @Override
    public JavaTypeMapping getMapping(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr, FieldRole fieldRole) {
        JavaTypeMapping m;
        if (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT || fieldRole == FieldRole.ROLE_ARRAY_ELEMENT) {
            return this.getElementMapping(table, mmd, fieldRole, clr);
        }
        if (fieldRole == FieldRole.ROLE_MAP_KEY) {
            return this.getKeyMapping(table, mmd, clr);
        }
        if (fieldRole == FieldRole.ROLE_MAP_VALUE) {
            return this.getValueMapping(table, mmd, clr);
        }
        TypeManager typeMgr = table.getStoreManager().getNucleusContext().getTypeManager();
        TypeConverter conv = null;
        if (!mmd.isTypeConversionDisabled()) {
            if (mmd.getTypeConverterName() != null) {
                conv = typeMgr.getTypeConverterForName(mmd.getTypeConverterName());
                if (conv == null) {
                    throw new NucleusUserException(Localiser.msg((String)"044062", (Object[])new Object[]{mmd.getFullFieldName(), mmd.getTypeConverterName()}));
                }
            } else {
                TypeConverter autoApplyConv = typeMgr.getAutoApplyTypeConverterForType(mmd.getType());
                if (autoApplyConv != null) {
                    conv = autoApplyConv;
                }
            }
            if (conv != null) {
                JavaTypeMapping m2 = null;
                if (conv instanceof MultiColumnConverter) {
                    Class<TypeConverterMultiMapping> mc = TypeConverterMultiMapping.class;
                    try {
                        m2 = (JavaTypeMapping)mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        m2.setRoleForMember(FieldRole.ROLE_FIELD);
                        ((TypeConverterMultiMapping)m2).initialize(mmd, table, clr, conv);
                        return m2;
                    }
                    catch (Exception e) {
                        throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
                    }
                }
                Class<TypeConverterMapping> mc = TypeConverterMapping.class;
                try {
                    m2 = (JavaTypeMapping)mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    m2.setRoleForMember(FieldRole.ROLE_FIELD);
                    ((TypeConverterMapping)m2).initialize(mmd, table, clr, conv);
                    return m2;
                }
                catch (Exception e) {
                    throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
                }
            }
        }
        AbstractMemberMetaData overrideMmd = null;
        MappingConverterDetails mcd = null;
        Class<? extends JavaTypeMapping> mc = null;
        String userMappingClassName = mmd.getValueForExtension("mapping-class");
        if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException ne) {
                throw new NucleusUserException(Localiser.msg((String)"041014", (Object[])new Object[]{mmd.getFullFieldName(), userMappingClassName})).setFatal();
            }
        } else {
            InterfaceMetaData typeCmd;
            Object object = typeCmd = mmd.getType().isInterface() ? this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForInterface(mmd.getType(), clr) : this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            if (mmd.hasExtension("serializeToFileLocation") && Serializable.class.isAssignableFrom(mmd.getType())) {
                mc = SerialisedLocalFileMapping.class;
            } else if (mmd.isSerialized()) {
                mcd = this.getMappingClass(mmd.getType(), true, false, null, mmd.getFullFieldName());
            } else if (mmd.getEmbeddedMetaData() != null) {
                mcd = this.getMappingClass(mmd.getType(), false, true, null, mmd.getFullFieldName());
            } else if (typeCmd != null && typeCmd.isEmbeddedOnly()) {
                mcd = this.getMappingClass(mmd.getType(), false, true, null, mmd.getFullFieldName());
            } else if (mmd.isEmbedded()) {
                mcd = this.getMappingClass(mmd.getType(), true, false, mmd.getColumnMetaData(), mmd.getFullFieldName());
            } else {
                Class memberType = mmd.getType();
                mcd = this.getMappingClass(memberType, false, false, mmd.getColumnMetaData(), mmd.getFullFieldName());
                if (mmd.getParent() instanceof EmbeddedMetaData && mmd.getRelationType(clr) != RelationType.NONE) {
                    AbstractClassMetaData cmdForFmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(mmd.getClassName(), clr);
                    overrideMmd = cmdForFmd.getMetaDataForMember(mmd.getName());
                }
            }
        }
        if (mcd != null) {
            mc = mcd.mappingClass;
            mc = this.getOverrideMappingClass(mc, mmd, fieldRole);
        }
        if (mc != null && (mcd == null || mcd.typeConverter == null)) {
            try {
                m = mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.setRoleForMember(FieldRole.ROLE_FIELD);
                m.initialize(mmd, table, clr);
                if (overrideMmd != null) {
                    m.setMemberMetaData(overrideMmd);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        if (mcd != null && mcd.typeConverter != null) {
            try {
                m = mcd.mappingClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.setRoleForMember(FieldRole.ROLE_FIELD);
                if (m instanceof TypeConverterMapping) {
                    ((TypeConverterMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                } else if (m instanceof TypeConverterMultiMapping) {
                    ((TypeConverterMultiMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                }
                if (overrideMmd != null) {
                    m.setMemberMetaData(overrideMmd);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        throw new NucleusException("Unable to create mapping for member at " + mmd.getFullFieldName() + " - no available mapping");
    }

    protected Class<? extends JavaTypeMapping> getOverrideMappingClass(Class<? extends JavaTypeMapping> mappingClass, AbstractMemberMetaData mmd, FieldRole fieldRole) {
        return mappingClass;
    }

    protected MappingConverterDetails getMappingClass(Class javaType, boolean serialised, boolean embedded, ColumnMetaData[] colmds, String fieldName) {
        Class superClass;
        MappingConverterDetails mcd;
        ApiAdapter api = this.storeMgr.getApiAdapter();
        if (api.isPersistable(javaType)) {
            if (serialised) {
                return new MappingConverterDetails(SerialisedPCMapping.class);
            }
            if (embedded) {
                return new MappingConverterDetails(EmbeddedPCMapping.class);
            }
            return new MappingConverterDetails(PersistableMapping.class);
        }
        if (javaType.isInterface() && !this.storeMgr.getMappingManager().isSupportedMappedType(javaType.getName())) {
            if (serialised) {
                return new MappingConverterDetails(SerialisedReferenceMapping.class);
            }
            if (embedded) {
                return new MappingConverterDetails(EmbeddedPCMapping.class);
            }
            return new MappingConverterDetails(InterfaceMapping.class);
        }
        if (javaType == Object.class) {
            if (serialised) {
                return new MappingConverterDetails(SerialisedReferenceMapping.class);
            }
            if (embedded) {
                throw new NucleusUserException(Localiser.msg((String)"041042", (Object[])new Object[]{fieldName})).setFatal();
            }
            return new MappingConverterDetails(ObjectMapping.class);
        }
        if (javaType.isArray()) {
            if (api.isPersistable(javaType.getComponentType())) {
                return new MappingConverterDetails(ArrayMapping.class);
            }
            if (javaType.getComponentType().isInterface() && !this.storeMgr.getMappingManager().isSupportedMappedType(javaType.getComponentType().getName())) {
                return new MappingConverterDetails(ArrayMapping.class);
            }
            if (javaType.getComponentType() == Object.class) {
                return new MappingConverterDetails(ArrayMapping.class);
            }
        }
        if ((mcd = this.getDefaultJavaTypeMapping(javaType, colmds)) == null || mcd.mappingClass == null) {
            for (superClass = javaType.getSuperclass(); !(superClass == null || superClass.getName().equals(ClassNameConstants.Object) || mcd != null && mcd.mappingClass != null); superClass = superClass.getSuperclass()) {
                mcd = this.getDefaultJavaTypeMapping(superClass, colmds);
            }
        }
        if (mcd == null) {
            if (this.storeMgr.getMappingManager().isSupportedMappedType(javaType.getName())) {
                throw new NucleusUserException(Localiser.msg((String)"041001", (Object[])new Object[]{fieldName, javaType.getName()}));
            }
            for (superClass = javaType; !(superClass == null || superClass.getName().equals(ClassNameConstants.Object) || mcd != null && mcd.mappingClass != null); superClass = superClass.getSuperclass()) {
                Class<?>[] interfaces = superClass.getInterfaces();
                for (int i = 0; i < interfaces.length && (mcd == null || mcd.mappingClass == null); ++i) {
                    mcd = this.getDefaultJavaTypeMapping(interfaces[i], colmds);
                }
            }
            if (mcd == null) {
                TypeConverter converter;
                if (!serialised && (converter = this.storeMgr.getNucleusContext().getTypeManager().getAutoApplyTypeConverterForType(javaType)) != null) {
                    return new MappingConverterDetails(TypeConverterMapping.class, converter);
                }
                NucleusLogger.PERSISTENCE.warn((Object)("Trying to find mapping for type " + javaType.getName() + " but none found, and only serialised available! Falling back to SerialisedMapping"));
                return new MappingConverterDetails(SerialisedMapping.class);
            }
        }
        return mcd;
    }

    protected JavaTypeMapping getElementMapping(Table table, AbstractMemberMetaData mmd, FieldRole fieldRole, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        if (!mmd.hasCollection() && !mmd.hasArray()) {
            throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no collection/array!").setFatal();
        }
        if (mmd.getJoinMetaData() == null) {
            AbstractMemberMetaData[] refMmds = mmd.getRelatedMemberMetaData(clr);
            if (refMmds == null || refMmds.length == 0) {
                throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
            }
            if (refMmds[0].getJoinMetaData() == null) {
                throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
            }
        }
        MappingConverterDetails mcd = null;
        Class mc = null;
        String userMappingClassName = null;
        String userTypeConverterName = null;
        if (mmd.getElementMetaData() != null) {
            userTypeConverterName = mmd.getElementMetaData().getValueForExtension("type-converter-name");
            userMappingClassName = mmd.getElementMetaData().getValueForExtension("mapping-class");
        }
        if (userTypeConverterName != null) {
            TypeConverter conv = this.storeMgr.getNucleusContext().getTypeManager().getTypeConverterForName(userTypeConverterName);
            if (conv == null) {
                throw new NucleusUserException("Field " + mmd.getFullFieldName() + " ELEMENT has been specified to use type converter " + userTypeConverterName + " but not found!");
            }
            mcd = new MappingConverterDetails(TypeConverterMapping.class, conv);
        } else if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(Localiser.msg((String)"041014", (Object[])new Object[]{userMappingClassName})).setFatal();
            }
        } else {
            boolean serialised = mmd.hasCollection() && mmd.getCollection().isSerializedElement() || mmd.hasArray() && mmd.getArray().isSerializedElement();
            boolean embeddedPC = mmd.hasCollection() && mmd.getCollection().elementIsPersistent() && mmd.getCollection().isEmbeddedElement() || mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null;
            boolean elementPC = mmd.hasCollection() && mmd.getCollection().elementIsPersistent() || mmd.hasArray() && mmd.getArray().elementIsPersistent();
            boolean embedded = true;
            Class<?> elementCls = null;
            if (mmd.hasCollection()) {
                embedded = mmd.getCollection().isEmbeddedElement();
                elementCls = clr.classForName(mmd.getCollection().getElementType());
            } else if (mmd.hasArray()) {
                embedded = mmd.getArray().isEmbeddedElement();
                elementCls = mmd.getType().getComponentType();
            }
            boolean elementReference = ClassUtils.isReferenceType(elementCls);
            if (serialised) {
                mc = elementPC ? SerialisedElementPCMapping.class : (elementReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
            } else if (embedded) {
                if (embeddedPC) {
                    mc = EmbeddedElementPCMapping.class;
                } else if (elementPC) {
                    mc = PersistableMapping.class;
                } else {
                    mcd = this.getMappingClass(elementCls, serialised, embedded, mmd.getElementMetaData() != null ? mmd.getElementMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
                }
            } else {
                mcd = this.getMappingClass(elementCls, serialised, embedded, mmd.getElementMetaData() != null ? mmd.getElementMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
            }
        }
        if (mcd != null && mcd.typeConverter == null) {
            mc = mcd.mappingClass;
        }
        if (mc != null && (mcd == null || mcd.typeConverter == null)) {
            m = null;
            try {
                m = mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.setRoleForMember(fieldRole);
                m.initialize(mmd, table, clr);
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        if (mcd != null && mcd.typeConverter != null) {
            try {
                m = mcd.mappingClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.setRoleForMember(fieldRole);
                if (m instanceof TypeConverterMapping) {
                    ((TypeConverterMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                } else if (m instanceof TypeConverterMultiMapping) {
                    ((TypeConverterMultiMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc != null ? mc.getName() : null, e}), (Throwable)e).setFatal();
            }
        }
        throw new NucleusException("Unable to create mapping for element of collection/array at " + mmd.getFullFieldName() + " - no available mapping");
    }

    protected JavaTypeMapping getKeyMapping(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        if (mmd.getMap() == null) {
            throw new NucleusException("Attempt to get key mapping for field " + mmd.getFullFieldName() + " that has no map!").setFatal();
        }
        MappingConverterDetails mcd = null;
        Class mc = null;
        String userTypeConverterName = null;
        String userMappingClassName = null;
        if (mmd.getKeyMetaData() != null) {
            userTypeConverterName = mmd.getKeyMetaData().getValueForExtension("type-converter-name");
            userMappingClassName = mmd.getKeyMetaData().getValueForExtension("mapping-class");
        }
        if (userTypeConverterName != null) {
            TypeConverter conv = this.storeMgr.getNucleusContext().getTypeManager().getTypeConverterForName(userTypeConverterName);
            if (conv == null) {
                throw new NucleusUserException("Field " + mmd.getFullFieldName() + " KEY has been specified to use type converter " + userTypeConverterName + " but not found!");
            }
            mcd = new MappingConverterDetails(TypeConverterMapping.class, conv);
        } else if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(Localiser.msg((String)"041014", (Object[])new Object[]{userMappingClassName})).setFatal();
            }
        } else {
            boolean serialised = mmd.hasMap() && mmd.getMap().isSerializedKey();
            boolean embedded = mmd.hasMap() && mmd.getMap().isEmbeddedKey();
            boolean embeddedPC = mmd.hasMap() && mmd.getMap().keyIsPersistent() && mmd.getMap().isEmbeddedKey() || mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null;
            boolean keyPC = mmd.hasMap() && mmd.getMap().keyIsPersistent();
            Class keyCls = clr.classForName(mmd.getMap().getKeyType());
            boolean keyReference = ClassUtils.isReferenceType((Class)keyCls);
            if (serialised) {
                mc = keyPC ? SerialisedKeyPCMapping.class : (keyReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
            } else if (embedded) {
                if (embeddedPC) {
                    mc = EmbeddedKeyPCMapping.class;
                } else if (keyPC) {
                    mc = PersistableMapping.class;
                } else {
                    mcd = this.getMappingClass(keyCls, serialised, embedded, mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
                }
            } else {
                mcd = this.getMappingClass(keyCls, serialised, embedded, mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
            }
        }
        if (mcd != null && mcd.typeConverter == null) {
            mc = mcd.mappingClass;
        }
        if (mc != null && (mcd == null || mcd.typeConverter == null)) {
            m = null;
            try {
                m = mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.setRoleForMember(FieldRole.ROLE_MAP_KEY);
                m.initialize(mmd, table, clr);
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        if (mcd != null && mcd.typeConverter != null) {
            try {
                m = mcd.mappingClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.setRoleForMember(FieldRole.ROLE_MAP_KEY);
                if (m instanceof TypeConverterMapping) {
                    ((TypeConverterMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                } else if (m instanceof TypeConverterMultiMapping) {
                    ((TypeConverterMultiMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc != null ? mc.getName() : null, e}), (Throwable)e).setFatal();
            }
        }
        throw new NucleusException("Unable to create mapping for key of map at " + mmd.getFullFieldName() + " - no available mapping");
    }

    protected JavaTypeMapping getValueMapping(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        if (mmd.getMap() == null) {
            throw new NucleusException("Attempt to get value mapping for field " + mmd.getFullFieldName() + " that has no map!").setFatal();
        }
        MappingConverterDetails mcd = null;
        Class mc = null;
        String userTypeConverterName = null;
        String userMappingClassName = null;
        if (mmd.getValueMetaData() != null) {
            userTypeConverterName = mmd.getValueMetaData().getValueForExtension("type-converter-name");
            userMappingClassName = mmd.getValueMetaData().getValueForExtension("mapping-class");
        }
        if (userTypeConverterName != null) {
            TypeConverter conv = this.storeMgr.getNucleusContext().getTypeManager().getTypeConverterForName(userTypeConverterName);
            if (conv == null) {
                throw new NucleusUserException("Field " + mmd.getFullFieldName() + " VALUE has been specified to use type converter " + userTypeConverterName + " but not found!");
            }
            mcd = new MappingConverterDetails(TypeConverterMapping.class, conv);
        } else if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(Localiser.msg((String)"041014", (Object[])new Object[]{userMappingClassName})).setFatal();
            }
        } else {
            boolean serialised = mmd.hasMap() && mmd.getMap().isSerializedValue();
            boolean embedded = mmd.hasMap() && mmd.getMap().isEmbeddedValue();
            boolean embeddedPC = mmd.hasMap() && mmd.getMap().valueIsPersistent() && mmd.getMap().isEmbeddedValue() || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null;
            boolean valuePC = mmd.hasMap() && mmd.getMap().valueIsPersistent();
            Class valueCls = clr.classForName(mmd.getMap().getValueType());
            boolean valueReference = ClassUtils.isReferenceType((Class)valueCls);
            if (serialised) {
                mc = valuePC ? SerialisedValuePCMapping.class : (valueReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
            } else if (embedded) {
                if (embeddedPC) {
                    mc = EmbeddedValuePCMapping.class;
                } else if (valuePC) {
                    mc = PersistableMapping.class;
                } else {
                    mcd = this.getMappingClass(valueCls, serialised, embedded, mmd.getValueMetaData() != null ? mmd.getValueMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
                }
            } else {
                mcd = this.getMappingClass(valueCls, serialised, embedded, mmd.getValueMetaData() != null ? mmd.getValueMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
            }
        }
        if (mcd != null && mcd.typeConverter == null) {
            mc = mcd.mappingClass;
        }
        if (mc != null && (mcd == null || mcd.typeConverter == null)) {
            m = null;
            try {
                m = mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.setRoleForMember(FieldRole.ROLE_MAP_VALUE);
                m.initialize(mmd, table, clr);
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        if (mcd != null && mcd.typeConverter != null) {
            try {
                m = mcd.mappingClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                m.setRoleForMember(FieldRole.ROLE_MAP_VALUE);
                if (m instanceof TypeConverterMapping) {
                    ((TypeConverterMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                } else if (m instanceof TypeConverterMultiMapping) {
                    ((TypeConverterMultiMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc != null ? mc.getName() : null, e}), (Throwable)e).setFatal();
            }
        }
        throw new NucleusException("Unable to create mapping for value of map at " + mmd.getFullFieldName() + " - no available mapping");
    }

    protected MappingConverterDetails getDefaultJavaTypeMapping(Class javaType, ColumnMetaData[] colmds) {
        Class<? extends JavaTypeMapping> cls = this.storeMgr.getMappingManager().getMappingType(javaType.getName());
        if (cls == null) {
            TypeConverter conv;
            TypeManager typeMgr = this.storeMgr.getNucleusContext().getTypeManager();
            if (colmds != null && colmds.length > 0) {
                if (colmds.length > 1) {
                    Collection converters = typeMgr.getTypeConvertersForType(javaType);
                    if (converters != null && !converters.isEmpty()) {
                        for (TypeConverter conv2 : converters) {
                            if (!(conv2 instanceof MultiColumnConverter) || ((MultiColumnConverter)conv2).getDatastoreColumnTypes().length != colmds.length) continue;
                            return new MappingConverterDetails(TypeConverterMultiMapping.class, conv2);
                        }
                    }
                } else {
                    JdbcType jdbcType = colmds[0].getJdbcType();
                    if (jdbcType != null) {
                        TypeConverter conv3 = null;
                        if (MetaDataUtils.isJdbcTypeString((JdbcType)jdbcType)) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, String.class);
                        } else if (MetaDataUtils.isJdbcTypeNumeric((JdbcType)jdbcType)) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, Long.class);
                        } else if (jdbcType == JdbcType.TIMESTAMP) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, Timestamp.class);
                        } else if (jdbcType == JdbcType.TIME) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, Time.class);
                        } else if (jdbcType == JdbcType.DATE) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, java.sql.Date.class);
                        }
                        if (conv3 != null) {
                            return new MappingConverterDetails(TypeConverterMapping.class, conv3);
                        }
                    }
                }
            }
            if ((conv = typeMgr.getDefaultTypeConverterForType(javaType)) != null) {
                if (conv instanceof MultiColumnConverter) {
                    return new MappingConverterDetails(TypeConverterMultiMapping.class, conv);
                }
                return new MappingConverterDetails(TypeConverterMapping.class, conv);
            }
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"041000", (Object[])new Object[]{javaType.getName()}));
            return null;
        }
        return new MappingConverterDetails(cls);
    }

    @Override
    public ColumnMapping createColumnMapping(JavaTypeMapping mapping, AbstractMemberMetaData mmd, int index, Column column) {
        Class<? extends ColumnMapping> columnMappingClass = null;
        if (mmd.getColumnMetaData().length > 0 && mmd.getColumnMetaData()[index].hasExtension("column-mapping-class")) {
            columnMappingClass = this.clr.classForName(mmd.getColumnMetaData()[index].getValueForExtension("column-mapping-class"));
        }
        if (columnMappingClass == null) {
            String javaType = mapping.getJavaTypeForColumnMapping(index);
            String jdbcType = null;
            String sqlType = null;
            if (mapping.getRoleForMember() == FieldRole.ROLE_ARRAY_ELEMENT || mapping.getRoleForMember() == FieldRole.ROLE_COLLECTION_ELEMENT) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcTypeName();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getCollection() != null && mmd.getCollection().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
                if (mmd.getArray() != null && mmd.getArray().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForMember() == FieldRole.ROLE_MAP_KEY) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcTypeName();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getMap().isSerializedKey()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForMember() == FieldRole.ROLE_MAP_VALUE) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getValueMetaData() != null ? mmd.getValueMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcTypeName();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getMap().isSerializedValue()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else {
                ValueGenerationStrategy strategy;
                if (mmd.getColumnMetaData().length > 0) {
                    jdbcType = mmd.getColumnMetaData()[index].getJdbcTypeName();
                    sqlType = mmd.getColumnMetaData()[index].getSqlType();
                }
                if ((strategy = mmd.getValueStrategy()) != null) {
                    String strategyName = strategy.toString();
                    if (strategy == ValueGenerationStrategy.NATIVE) {
                        strategyName = this.storeMgr.getValueGenerationStrategyForNative(mmd);
                    }
                    if (strategyName != null && ValueGenerationStrategy.IDENTITY.toString().equals(strategyName)) {
                        Class requestedType = this.clr.classForName(javaType);
                        Class requiredType = this.storeMgr.getDatastoreAdapter().getIdentityJavaTypeForType(requestedType);
                        if (requiredType != mmd.getType()) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Member " + mmd.getFullFieldName() + " uses IDENTITY strategy and rather than using memberType of " + mmd.getTypeName() + " for the column type, using " + requiredType + " since the datastore requires that"));
                        }
                        javaType = requiredType.getName();
                    }
                }
                if (mmd.isSerialized()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            }
            columnMappingClass = this.storeMgr.getDatastoreAdapter().getColumnMappingClass(javaType, jdbcType, sqlType, this.clr, mmd.getFullFieldName());
        }
        ColumnMapping columnMapping = ColumnMappingFactory.createMapping(columnMappingClass, mapping, this.storeMgr, column);
        if (column != null) {
            column.setColumnMapping(columnMapping);
        }
        return columnMapping;
    }

    @Override
    public ColumnMapping createColumnMapping(JavaTypeMapping mapping, Column column, String javaType) {
        Column col = column;
        String jdbcType = null;
        String sqlType = null;
        if (col != null && col.getColumnMetaData() != null) {
            jdbcType = col.getColumnMetaData().getJdbcTypeName();
            sqlType = col.getColumnMetaData().getSqlType();
        }
        Class<? extends ColumnMapping> columnMappingClass = this.storeMgr.getDatastoreAdapter().getColumnMappingClass(javaType, jdbcType, sqlType, this.clr, null);
        ColumnMapping columnMapping = ColumnMappingFactory.createMapping(columnMappingClass, mapping, this.storeMgr, column);
        if (column != null) {
            column.setColumnMapping(columnMapping);
        }
        return columnMapping;
    }

    @Override
    public Column createColumn(JavaTypeMapping mapping, String javaType, int columnIndex) {
        AbstractMemberMetaData mmd = mapping.getMemberMetaData();
        FieldRole roleForField = mapping.getRoleForMember();
        ColumnMetaData colmd = null;
        AbstractMemberMetaData columnContainer = mmd;
        if (roleForField == FieldRole.ROLE_COLLECTION_ELEMENT || roleForField == FieldRole.ROLE_ARRAY_ELEMENT) {
            columnContainer = mmd.getElementMetaData();
        } else if (roleForField == FieldRole.ROLE_MAP_KEY) {
            columnContainer = mmd.getKeyMetaData();
        } else if (roleForField == FieldRole.ROLE_MAP_VALUE) {
            columnContainer = mmd.getValueMetaData();
        }
        if (columnContainer != null && columnContainer.getColumnMetaData().length > columnIndex) {
            colmd = columnContainer.getColumnMetaData()[columnIndex];
        } else {
            colmd = new ColumnMetaData();
            if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > columnIndex) {
                colmd.setName(mmd.getColumnMetaData()[columnIndex].getName());
            }
            if (columnContainer != null) {
                columnContainer.addColumn(colmd);
            }
        }
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        Table tbl = mapping.getTable();
        if (colmd.getName() == null) {
            if (roleForField == FieldRole.ROLE_COLLECTION_ELEMENT) {
                identifier = idFactory.newJoinTableFieldIdentifier(mmd, null, null, true, FieldRole.ROLE_COLLECTION_ELEMENT);
            } else if (roleForField == FieldRole.ROLE_ARRAY_ELEMENT) {
                identifier = idFactory.newJoinTableFieldIdentifier(mmd, null, null, true, FieldRole.ROLE_ARRAY_ELEMENT);
            } else if (roleForField == FieldRole.ROLE_MAP_KEY) {
                identifier = idFactory.newJoinTableFieldIdentifier(mmd, null, null, true, FieldRole.ROLE_MAP_KEY);
            } else if (roleForField == FieldRole.ROLE_MAP_VALUE) {
                identifier = idFactory.newJoinTableFieldIdentifier(mmd, null, null, true, FieldRole.ROLE_MAP_VALUE);
            } else {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, mmd.getName());
                int i = 0;
                while (tbl.hasColumn(identifier)) {
                    identifier = idFactory.newIdentifier(IdentifierType.COLUMN, mmd.getName() + "_" + i);
                    ++i;
                }
            }
            colmd.setName(identifier.getName());
        } else {
            identifier = idFactory.newColumnIdentifier(colmd.getName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(mmd.getType()), null, true);
        }
        Column col = tbl.addColumn(javaType, identifier, mapping, colmd);
        if (mmd.isPrimaryKey()) {
            col.setPrimaryKey();
        }
        if (mmd.getParent() instanceof AbstractClassMetaData && this.storeMgr.isValueGenerationStrategyDatastoreAttributed(mmd.getAbstractClassMetaData(), mmd.getAbsoluteFieldNumber()) && tbl instanceof DatastoreClass && (mmd.isPrimaryKey() && ((DatastoreClass)tbl).isBaseDatastoreClass() || !mmd.isPrimaryKey())) {
            col.setIdentity(true);
        }
        if (mmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("select-function"), 0);
        }
        if (mmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("insert-function"), 1);
        }
        if (mmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("update-function"), 2);
        }
        this.setColumnNullability(mmd, colmd, col);
        if (mmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable(colmd.getDefaultValue());
        }
        return col;
    }

    @Override
    public Column createColumn(JavaTypeMapping mapping, String javaType, ColumnMetaData colmd) {
        AbstractMemberMetaData mmd = mapping.getMemberMetaData();
        Table tbl = mapping.getTable();
        if (colmd == null) {
            colmd = new ColumnMetaData();
            if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length == 1) {
                colmd.setName(mmd.getColumnMetaData()[0].getName());
            }
            mmd.addColumn(colmd);
        }
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            identifier = idFactory.newIdentifier(IdentifierType.COLUMN, mmd.getName());
            int i = 0;
            while (tbl.hasColumn(identifier)) {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, mmd.getName() + "_" + i);
                ++i;
            }
            colmd.setName(identifier.getName());
        } else {
            identifier = idFactory.newColumnIdentifier(colmd.getName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(mmd.getType()), null, true);
        }
        Column col = tbl.addColumn(javaType, identifier, mapping, colmd);
        this.setColumnNullability(mmd, colmd, col);
        if (mmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable(colmd.getDefaultValue());
        }
        return col;
    }

    @Override
    public Column createColumn(AbstractMemberMetaData mmd, Table table, JavaTypeMapping mapping, ColumnMetaData colmd, Column reference, ClassLoaderResolver clr) {
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
            identifier = idFactory.newForeignKeyFieldIdentifier(relatedMmds != null ? relatedMmds[0] : null, mmd, reference.getIdentifier(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(mmd.getType()), FieldRole.ROLE_OWNER);
            colmd.setName(identifier.getName());
        } else {
            identifier = idFactory.newColumnIdentifier(colmd.getName(), false, null, true);
        }
        Column col = table.addColumn(mmd.getType().getName(), identifier, mapping, colmd);
        reference.copyConfigurationTo(col);
        if (mmd.isPrimaryKey()) {
            col.setPrimaryKey();
        }
        if (mmd.getParent() instanceof AbstractClassMetaData && this.storeMgr.isValueGenerationStrategyDatastoreAttributed(mmd.getAbstractClassMetaData(), mmd.getAbsoluteFieldNumber()) && (mmd.isPrimaryKey() && ((DatastoreClass)table).isBaseDatastoreClass() || !mmd.isPrimaryKey())) {
            col.setIdentity(true);
        }
        if (mmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("select-function"), 0);
        }
        if (mmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("insert-function"), 1);
        }
        if (mmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("update-function"), 2);
        }
        this.setColumnNullability(mmd, colmd, col);
        if (mmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable(colmd.getDefaultValue());
        }
        return col;
    }

    private void setColumnNullability(AbstractMemberMetaData mmd, ColumnMetaData colmd, Column col) {
        if (colmd != null && colmd.getAllowsNull() == null) {
            if (mmd.isPrimaryKey()) {
                colmd.setAllowsNull(Boolean.valueOf(false));
            } else if (!mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
                colmd.setAllowsNull(Boolean.valueOf(true));
            } else {
                colmd.setAllowsNull(Boolean.valueOf(false));
            }
            if (colmd.isAllowsNull()) {
                col.setNullable(true);
            }
        } else if (colmd != null && colmd.getAllowsNull() != null) {
            if (colmd.isAllowsNull()) {
                col.setNullable(true);
            }
        } else if (!mmd.isPrimaryKey() && !mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
            col.setNullable(true);
        }
    }

    public class MappingConverterDetails {
        Class<? extends JavaTypeMapping> mappingClass;
        TypeConverter typeConverter;

        public MappingConverterDetails(Class<? extends JavaTypeMapping> mappingCls) {
            this.mappingClass = mappingCls;
        }

        public MappingConverterDetails(Class<? extends JavaTypeMapping> mappingCls, TypeConverter typeConv) {
            this.mappingClass = mappingCls;
            this.typeConverter = typeConv;
        }
    }

    static class MappedType {
        final Class javaType;
        final Class<? extends JavaTypeMapping> javaMappingType;

        public MappedType(Class javaType, Class<? extends JavaTypeMapping> mappingType) {
            this.javaType = javaType;
            this.javaMappingType = mappingType;
        }

        public String toString() {
            StringBuilder str = new StringBuilder("MappedType " + this.javaType.getName() + " [");
            if (this.javaMappingType != null) {
                str.append(" mapping=" + this.javaMappingType);
            }
            str.append("]");
            return str.toString();
        }
    }
}

