/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyTablePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyIndexOrSizeNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyValueTypes;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class WebAssemblyTablePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WebAssemblyTablePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WebAssemblyTablePrototypeBuiltins();

    protected WebAssemblyTablePrototypeBuiltins() {
        super(JSWebAssemblyTable.PROTOTYPE_NAME, WebAssemblyTablePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WebAssemblyTablePrototype builtinEnum) {
        switch (builtinEnum) {
            case grow: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableGrowNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case get: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableGetNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case set: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableSetNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case length: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableGetLengthNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum WebAssemblyTablePrototype implements BuiltinEnum<WebAssemblyTablePrototype>
    {
        grow(1),
        get(1),
        set(1),
        length(0);

        private final int functionLength;

        private WebAssemblyTablePrototype(int length) {
            this.functionLength = length;
        }

        @Override
        public int getLength() {
            return this.functionLength;
        }

        @Override
        public boolean isEnumerable() {
            return true;
        }

        @Override
        public boolean isGetter() {
            return this == length;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WebAssemblyTableGrowNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toDeltaNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.grow(): Argument 0");

        public WebAssemblyTableGrowNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object grow(Object thiz, Object delta, Object[] args, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary tableGrowLib, @Cached InlinedBranchProfile errorBranch) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("WebAssembly.Table.grow(): Receiver is not a WebAssembly.Table");
            }
            JSWebAssemblyTableObject table = (JSWebAssemblyTableObject)((Object)thiz);
            int deltaInt = this.toDeltaNode.executeInt(delta);
            Object wasmTable = table.getWASMTable();
            TruffleString elementKind = table.getElementKind();
            JSRealm realm = this.getRealm();
            Object wasmValue = args.length == 0 ? JSWebAssemblyValueTypes.getDefaultValue(realm, elementKind) : toWebAssemblyValueNode.execute(args[0], elementKind);
            try {
                Object growFn = realm.getWASMTableGrow();
                return tableGrowLib.execute(growFn, new Object[]{wasmTable, deltaInt, wasmValue});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (AbstractTruffleException ex) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError(ex, (Node)this);
            }
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WebAssemblyTableGetNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toIndexNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.get(): Argument 0");

        public WebAssemblyTableGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object get(Object thiz, Object index, @Cached ToJSValueNode toJSValueNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary tableGetLib, @Cached InlinedBranchProfile errorBranch) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("WebAssembly.Table.get(): Receiver is not a WebAssembly.Table");
            }
            JSRealm realm = this.getRealm();
            int indexInt = this.toIndexNode.executeInt(index);
            Object wasmTable = ((JSWebAssemblyTableObject)((Object)thiz)).getWASMTable();
            try {
                Object getFn = realm.getWASMTableRead();
                Object fn = tableGetLib.execute(getFn, new Object[]{wasmTable, indexInt});
                return toJSValueNode.execute(fn);
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (AbstractTruffleException ex) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError(ex, (Node)this);
            }
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WebAssemblyTableSetNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toIndexNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.set(): Argument 0");

        public WebAssemblyTableSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object set(Object thiz, Object index, Object[] args, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary tableSetLib, @Cached InlinedBranchProfile errorBranch) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("WebAssembly.Table.set(): Receiver is not a WebAssembly.Table");
            }
            JSWebAssemblyTableObject table = (JSWebAssemblyTableObject)((Object)thiz);
            int indexInt = this.toIndexNode.executeInt(index);
            Object wasmTable = table.getWASMTable();
            TruffleString elementKind = table.getElementKind();
            JSRealm realm = this.getRealm();
            Object wasmValue = args.length == 0 ? JSWebAssemblyValueTypes.getDefaultValue(realm, elementKind) : toWebAssemblyValueNode.execute(args[0], elementKind);
            try {
                Object setFn = realm.getWASMTableWrite();
                tableSetLib.execute(setFn, new Object[]{wasmTable, indexInt, wasmValue});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (AbstractTruffleException ex) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError(ex, (Node)this);
            }
            return Undefined.instance;
        }
    }

    public static abstract class WebAssemblyTableGetLengthNode
    extends JSBuiltinNode {
        @Node.Child
        InteropLibrary tableLengthLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);

        public WebAssemblyTableGetLengthNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getLength(JSWebAssemblyTableObject tableObj) {
            Object wasmTable = tableObj.getWASMTable();
            try {
                Object lengthFn = this.getRealm().getWASMTableLength();
                return this.tableLengthLib.execute(lengthFn, new Object[]{wasmTable});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        protected Object doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeError("WebAssembly.Table.length(): Receiver is not a WebAssembly.Table", (Node)this);
        }
    }
}

