/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.AvailableSlotsCalculator;
import org.apache.hadoop.hive.ql.exec.tez.DynamicPartitionPruner;
import org.apache.hadoop.hive.ql.exec.tez.HiveInputCounters;
import org.apache.hadoop.hive.ql.exec.tez.SplitGrouper;
import org.apache.hadoop.hive.ql.exec.tez.Utils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.hive.common.util.ReflectionUtil;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSplitGenerator
extends InputInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSplitGenerator.class);
    private final DynamicPartitionPruner pruner;
    private Configuration conf;
    private JobConf jobConf;
    private MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto;
    private MapWork work;
    private final SplitGrouper splitGrouper = new SplitGrouper();
    private SplitLocationProvider splitLocationProvider;
    private Optional<Integer> numSplits;
    private boolean generateSingleSplit;

    public HiveSplitGenerator(Configuration conf, MapWork work, boolean generateSingleSplit) throws IOException {
        this(conf, work, generateSingleSplit, null);
    }

    public HiveSplitGenerator(Configuration conf, MapWork work, boolean generateSingleSplit, Integer numSplits) throws IOException {
        super(null);
        this.conf = conf;
        this.work = work;
        this.jobConf = new JobConf(conf);
        this.generateSingleSplit = generateSingleSplit;
        this.userPayloadProto = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder().setGroupingEnabled(true).build();
        this.splitLocationProvider = Utils.getSplitLocationProvider(conf, work.getCacheAffinity(), LOG);
        LOG.info("SplitLocationProvider: " + String.valueOf(this.splitLocationProvider));
        ShimLoader.getHadoopShims().getMergedCredentials(this.jobConf);
        this.pruner = null;
        this.numSplits = Optional.ofNullable(numSplits);
    }

    public HiveSplitGenerator(InputInitializerContext initializerContext) {
        super(initializerContext);
        Preconditions.checkNotNull((Object)initializerContext);
        this.pruner = new DynamicPartitionPruner();
        this.numSplits = Optional.empty();
    }

    @VisibleForTesting
    void prepare(InputInitializerContext initializerContext) throws IOException, SerDeException {
        this.userPayloadProto = MRInputHelpers.parseMRInputPayload((UserPayload)initializerContext.getInputUserPayload());
        this.conf = TezUtils.createConfFromByteString((ByteString)this.userPayloadProto.getConfigurationBytes());
        this.jobConf = new JobConf(this.conf);
        ShimLoader.getHadoopShims().getMergedCredentials(this.jobConf);
        this.work = Utilities.getMapWork((Configuration)this.jobConf);
        this.splitLocationProvider = Utils.getSplitLocationProvider(this.conf, this.work.getCacheAffinity(), LOG);
        LOG.info("SplitLocationProvider: " + String.valueOf(this.splitLocationProvider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> initialize() throws Exception {
        if (this.getContext() != null) {
            this.prepare(this.getContext());
        }
        Utilities.setMapWork((Configuration)this.jobConf, this.work);
        try {
            InputSplit[] flatSplits;
            boolean sendSerializedEvents = this.conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
            if (this.pruner != null) {
                this.pruner.initialize(this.getContext(), this.work, this.jobConf);
                this.pruner.prune();
            }
            InputSplitInfoMem inputSplitInfo = null;
            boolean generateConsistentSplits = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_GENERATE_CONSISTENT_SPLITS);
            LOG.info("GenerateConsistentSplitsInHive=" + generateConsistentSplits);
            String realInputFormatName = this.conf.get("mapred.input.format.class");
            boolean groupingEnabled = this.userPayloadProto.getGroupingEnabled();
            if (groupingEnabled) {
                InputSplit[] splits;
                InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)JavaUtils.loadClass((String)realInputFormatName), (Configuration)this.jobConf);
                int availableSlots = this.getAvailableSlotsCalculator().getAvailableSlots();
                if (HiveConf.getLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPRED_MIN_SPLIT_SIZE, (long)1L) <= 1L) {
                    long blockSize = this.conf.getLongBytes("dfs.blocksize", 0x8000000L);
                    long minGrouping = this.conf.getLong("tez.grouping.min-size", 0x3200000L);
                    long preferredSplitSize = Math.min(blockSize / 2L, minGrouping);
                    HiveConf.setLongVar((Configuration)this.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPRED_MIN_SPLIT_SIZE, (long)preferredSplitSize);
                    LOG.info("The preferred split size is " + preferredSplitSize);
                }
                float waves = this.numSplits.isPresent() ? this.numSplits.get().floatValue() / (float)availableSlots : this.conf.getFloat("tez.grouping.split-waves", 1.7f);
                if (this.generateSingleSplit && this.conf.get(HiveConf.ConfVars.HIVE_TEZ_INPUT_FORMAT.varname).equals(HiveInputFormat.class.getName())) {
                    MapWork mapWork = Utilities.getMapWork((Configuration)this.jobConf);
                    List<Path> paths = Utilities.getInputPathsTez(this.jobConf, mapWork);
                    FileSystem fs = paths.get(0).getFileSystem((Configuration)this.jobConf);
                    FileStatus[] fileStatuses = fs.listStatus(paths.get(0));
                    if (fileStatuses.length == 0) {
                        splits = new InputSplit[]{};
                    } else {
                        Preconditions.checkState((paths.size() == 1 && fileStatuses.length == 1 && mapWork.getAliasToPartnInfo().size() == 1 ? 1 : 0) != 0, (Object)("Requested to generate single split. Paths and fileStatuses are expected to be 1. Got paths: " + paths.size() + " fileStatuses: " + fileStatuses.length));
                        splits = new InputSplit[1];
                        FileStatus fileStatus = fileStatuses[0];
                        BlockLocation[] locations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
                        HashSet hostsSet = new HashSet();
                        for (BlockLocation blockLocation : locations) {
                            hostsSet.addAll(Lists.newArrayList((Object[])blockLocation.getHosts()));
                        }
                        String[] hosts = hostsSet.toArray(new String[0]);
                        FileSplit fileSplit = new FileSplit(fileStatus.getPath(), 0L, fileStatus.getLen(), hosts);
                        String alias = mapWork.getAliases().get(0);
                        PartitionDesc partitionDesc = mapWork.getAliasToPartnInfo().get(alias);
                        String partIF = partitionDesc.getInputFileFormatClassName();
                        splits[0] = new HiveInputFormat.HiveInputSplit((InputSplit)fileSplit, partIF);
                    }
                } else {
                    splits = inputFormat.getSplits(this.jobConf, this.numSplits.orElse((int)((float)availableSlots * waves)).intValue());
                }
                Arrays.sort(splits, new InputSplitComparator());
                LOG.info("Number of input splits: " + splits.length + ". " + availableSlots + " available slots, " + waves + " waves. Input format is: " + realInputFormatName);
                InputInitializerContext inputInitializerContext = this.getContext();
                TezCounters tezCounters = null;
                String groupName = null;
                String vertexName = null;
                if (inputInitializerContext != null) {
                    try {
                        tezCounters = new TezCounters();
                        groupName = HiveInputCounters.class.getName();
                        vertexName = this.jobConf.get("__hive.context.name", "");
                        String counterName = Utilities.getVertexCounterName(HiveInputCounters.RAW_INPUT_SPLITS.name(), vertexName);
                        tezCounters.findCounter(groupName, counterName).increment((long)splits.length);
                        List<Path> paths = Utilities.getInputPathsTez(this.jobConf, this.work);
                        counterName = Utilities.getVertexCounterName(HiveInputCounters.INPUT_DIRECTORIES.name(), vertexName);
                        tezCounters.findCounter(groupName, counterName).increment((long)paths.size());
                        HashSet<String> files = new HashSet<String>();
                        for (String string : splits) {
                            FileSplit fileSplit;
                            Path path;
                            String fileStr;
                            if (!(string instanceof FileSplit) || files.contains(fileStr = (path = (fileSplit = (FileSplit)string).getPath()).toString())) continue;
                            files.add(fileStr);
                        }
                        counterName = Utilities.getVertexCounterName(HiveInputCounters.INPUT_FILES.name(), vertexName);
                        tezCounters.findCounter(groupName, counterName).increment((long)files.size());
                    }
                    catch (Exception e) {
                        LOG.warn("Caught exception while trying to update Tez counters", (Throwable)e);
                    }
                }
                if (this.work.getIncludedBuckets() != null) {
                    splits = this.pruneBuckets(this.work, splits);
                }
                Multimap<Integer, InputSplit> groupedSplits = this.splitGrouper.generateGroupedSplits(this.jobConf, this.conf, splits, waves, availableSlots, this.splitLocationProvider);
                flatSplits = groupedSplits.values().toArray(new InputSplit[0]);
                LOG.info("Number of split groups: " + flatSplits.length);
                if (inputInitializerContext != null) {
                    try {
                        String counterName = Utilities.getVertexCounterName(HiveInputCounters.GROUPED_INPUT_SPLITS.name(), vertexName);
                        tezCounters.findCounter(groupName, counterName).setValue((long)flatSplits.length);
                        LOG.debug("Published tez counters: {}", (Object)tezCounters);
                        inputInitializerContext.addCounters(tezCounters);
                    }
                    catch (Exception e) {
                        LOG.warn("Caught exception while trying to update Tez counters", (Throwable)e);
                    }
                }
            } else {
                throw new RuntimeException("HiveInputFormat does not support non-grouped splits, InputFormatName is: " + realInputFormatName);
            }
            List<TaskLocationHint> locationHints = this.splitGrouper.createTaskLocationHints(flatSplits, generateConsistentSplits);
            inputSplitInfo = new InputSplitInfoMem(flatSplits, locationHints, flatSplits.length, null, (Configuration)this.jobConf);
            List<Event> list = this.createEventList(sendSerializedEvents, inputSplitInfo);
            return list;
        }
        finally {
            Utilities.clearWork((Configuration)this.jobConf);
        }
    }

    private InputSplit[] pruneBuckets(MapWork work, InputSplit[] splits) {
        BitSet buckets = work.getIncludedBuckets();
        String bucketIn = buckets.toString();
        ArrayList<InputSplit> filteredSplits = new ArrayList<InputSplit>(splits.length / 2);
        for (InputSplit split : splits) {
            int bucket = Utilities.parseSplitBucket(split);
            if (bucket < 0 || buckets.get(bucket)) {
                filteredSplits.add(split);
                continue;
            }
            LOG.info("Pruning with IN ({}) - removing {}", (Object)bucketIn, (Object)split);
        }
        if (filteredSplits.size() < splits.length) {
            splits = filteredSplits.toArray(new InputSplit[filteredSplits.size()]);
        }
        return splits;
    }

    @VisibleForTesting
    List<Event> createEventList(boolean sendSerializedEvents, InputSplitInfoMem inputSplitInfo) throws IOException {
        ArrayList events = Lists.newArrayListWithCapacity((int)(inputSplitInfo.getNumTasks() + 1));
        InputConfigureVertexTasksEvent configureVertexEvent = InputConfigureVertexTasksEvent.create((int)inputSplitInfo.getNumTasks(), (VertexLocationHint)VertexLocationHint.create((List)inputSplitInfo.getTaskLocationHints()), (InputSpecUpdate)InputSpecUpdate.getDefaultSinglePhysicalInputSpecUpdate());
        events.add(configureVertexEvent);
        if (sendSerializedEvents) {
            int count = 0;
            long inMemoryPayloadSize = 0L;
            long serializedPayloadSize = 0L;
            int payloadSerializationThresholdBytes = HiveConf.getIntVar((Configuration)this.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_INPUT_FS_SERIALIZATION_THRESHOLD);
            List splits = inputSplitInfo.getSplitsProto().getSplitsList();
            LOG.debug("Start creating events for {} splits", (Object)splits.size());
            long startTime = Time.monotonicNow();
            try (SplitSerializer splitSerializer = this.getSplitSerializer();){
                for (MRRuntimeProtos.MRSplitProto mrSplit : splits) {
                    ByteBuffer payloadBuffer = mrSplit.toByteString().asReadOnlyByteBuffer();
                    int payloadSize = payloadBuffer.limit();
                    boolean shouldSerializeEventToFile = payloadSerializationThresholdBytes != -1 && inMemoryPayloadSize >= (long)payloadSerializationThresholdBytes;
                    LOG.debug("Split #{}, byteBuffer size: {} bytes", (Object)count, (Object)payloadSize);
                    InputDataInformationEvent diEvent = null;
                    if (shouldSerializeEventToFile) {
                        LOG.debug("Serialize to path: {}, current in-memory payload: {} bytes >= threshold: {} bytes", new Object[]{splitSerializer.getSerializedFilePath(count), inMemoryPayloadSize, payloadSerializationThresholdBytes});
                        serializedPayloadSize += (long)payloadSize;
                        diEvent = splitSerializer.write(count, mrSplit);
                    } else {
                        inMemoryPayloadSize += (long)payloadSize;
                        diEvent = InputDataInformationEvent.createWithSerializedPayload((int)count, (ByteBuffer)payloadBuffer);
                    }
                    events.add(diEvent);
                    ++count;
                }
            }
            long elapsed = Time.monotonicNow() - startTime;
            LOG.info("Finished creating events ({} splits) in {} ms, size of payloads: in memory: {} bytes, serialized to fs: {} bytes", new Object[]{splits.size(), elapsed, inMemoryPayloadSize, serializedPayloadSize});
        } else {
            int count = 0;
            for (InputSplit split : inputSplitInfo.getOldFormatSplits()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)split);
                events.add(diEvent);
            }
        }
        return events;
    }

    @VisibleForTesting
    SplitSerializer getSplitSerializer() throws IOException {
        return new SplitSerializer(this);
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) {
        this.pruner.processVertex(stateUpdate.getVertexName());
    }

    public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        for (InputInitializerEvent e : events) {
            this.pruner.addEvent(e);
        }
    }

    private AvailableSlotsCalculator getAvailableSlotsCalculator() throws Exception {
        Class<?> clazz = Class.forName(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SPLITS_AVAILABLE_SLOTS_CALCULATOR_CLASS), true, Utilities.getSessionSpecifiedClassLoader());
        AvailableSlotsCalculator slotsCalculator = (AvailableSlotsCalculator)ReflectionUtil.newInstance(clazz, null);
        slotsCalculator.initialize(this.conf, this);
        return slotsCalculator;
    }

    static class InputSplitComparator
    implements Comparator<InputSplit> {
        InputSplitComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    if (o1 instanceof FileSplit && o2 instanceof FileSplit) {
                        FileSplit fs1 = (FileSplit)o1;
                        FileSplit fs2 = (FileSplit)o2;
                        if (fs1.getPath() != null && fs2.getPath() != null) {
                            int pathComp = fs1.getPath().compareTo(fs2.getPath());
                            if (pathComp == 0) {
                                long startPos2;
                                long startPos1 = fs1.getStart();
                                if (startPos1 > (startPos2 = fs2.getStart())) {
                                    return 1;
                                }
                                if (startPos1 < startPos2) {
                                    return -1;
                                }
                                return 0;
                            }
                            return pathComp;
                        }
                    }
                    return 0;
                }
                return -1;
            }
            catch (IOException e) {
                throw new RuntimeException("Problem getting input split size", e);
            }
        }
    }

    class SplitSerializer
    implements AutoCloseable {
        private static final String FILE_PATH_FORMAT = "%s/events/%s/%d_%s_InputDataInformationEvent_%d";
        private String queryId;
        private String inputName;
        private int vertexId;
        private Path appStagingPath;
        private FileSystem fs;
        private ExecutorService executor;
        private AtomicBoolean anyTaskFailed;
        private List<Future<?>> asyncTasks;

        @VisibleForTesting
        SplitSerializer(HiveSplitGenerator this$0) throws IOException {
            if (this$0.getContext() == null) {
                return;
            }
            this.queryId = this$0.jobConf.get(HiveConf.ConfVars.HIVE_QUERY_ID.varname);
            this.inputName = this$0.getContext().getInputName();
            this.vertexId = this$0.getContext().getVertexId();
            this.appStagingPath = TezCommonUtils.getTezSystemStagingPath((Configuration)this$0.jobConf, (String)this$0.getContext().getApplicationId().toString());
            this.fs = this.appStagingPath.getFileSystem((Configuration)this$0.jobConf);
            int numThreads = HiveConf.getIntVar((Configuration)this$0.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_INPUT_FS_SERIALIZATION_THREADS);
            this.executor = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("HiveSplitGenerator.SplitSerializer Thread - #%d").build());
            this.anyTaskFailed = new AtomicBoolean(false);
            this.asyncTasks = new ArrayList();
        }

        @VisibleForTesting
        InputDataInformationEvent write(int count, MRRuntimeProtos.MRSplitProto mrSplit) {
            Path filePath = this.getSerializedFilePath(count);
            Runnable task = () -> {
                if (!this.anyTaskFailed.get()) {
                    try {
                        this.writeSplit(count, mrSplit, filePath);
                    }
                    catch (IOException e) {
                        this.anyTaskFailed.set(true);
                        throw new RuntimeException(e);
                    }
                }
            };
            this.asyncTasks.add(CompletableFuture.runAsync(task, this.executor));
            return InputDataInformationEvent.createWithSerializedPath((int)count, (String)filePath.toString());
        }

        @VisibleForTesting
        void writeSplit(int count, MRRuntimeProtos.MRSplitProto mrSplit, Path filePath) throws IOException {
            long fileWriteStarted = Time.monotonicNow();
            try (FSDataOutputStream out = this.fs.create(filePath, false);){
                mrSplit.writeTo((OutputStream)out);
            }
            LOG.debug("Split #{} event to output path: {} written in {} ms", new Object[]{count, filePath, Time.monotonicNow() - fileWriteStarted});
        }

        Path getSerializedFilePath(int index) {
            return new Path(String.format(FILE_PATH_FORMAT, this.appStagingPath, this.queryId, this.vertexId, this.inputName, index));
        }

        @Override
        public void close() {
            try {
                if (this.asyncTasks != null) {
                    CompletableFuture.allOf(this.asyncTasks.toArray(new CompletableFuture[0])).get();
                }
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted while generating splits", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.error("Exception while generating splits", e.getCause());
                throw new RuntimeException(e.getCause());
            }
            finally {
                if (this.executor != null) {
                    this.executor.shutdown();
                }
            }
        }
    }
}

