/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;

public final class TimestampUtils {
    static final long MILLISECONDS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    static final long NANOSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);

    public static long daysToNanoseconds(long daysSinceEpoch) {
        return DateWritableV2.daysToMillis((int)((int)daysSinceEpoch)) * NANOSECONDS_PER_MILLISECOND;
    }

    public static TimestampWritableV2 timestampColumnVectorWritable(TimestampColumnVector timestampColVector, int elementNum, TimestampWritableV2 timestampWritable) {
        Timestamp ts = timestampColVector.asScratchTimestamp(elementNum);
        if (ts == null) {
            timestampWritable.set((org.apache.hadoop.hive.common.type.Timestamp)null);
            return timestampWritable;
        }
        org.apache.hadoop.hive.common.type.Timestamp newTS = org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)ts.getTime(), (int)ts.getNanos());
        timestampWritable.set(newTS);
        return timestampWritable;
    }

    public static HiveIntervalDayTimeWritable intervalDayTimeColumnVectorWritable(IntervalDayTimeColumnVector intervalDayTimeColVector, int elementNum, HiveIntervalDayTimeWritable intervalDayTimeWritable) {
        intervalDayTimeWritable.set(intervalDayTimeColVector.asScratchIntervalDayTime(elementNum));
        return intervalDayTimeWritable;
    }

    public static String timestampScalarTypeToString(Object o) {
        if (o instanceof Timestamp) {
            Timestamp ts = (Timestamp)o;
            return org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)ts.getTime(), (int)ts.getNanos()).toString();
        }
        return o.toString();
    }
}

