/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFGroupBatches;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.ptf.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorPTFEvaluatorBase {
    final WindowFrameDef windowFrameDef;
    final VectorExpression inputVecExpr;
    protected int inputColumnNum;
    protected final int outputColumnNum;
    private boolean nullsLast;
    private boolean respectNulls = true;
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public VectorPTFEvaluatorBase(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        this.windowFrameDef = windowFrameDef;
        if (inputVecExpr == null) {
            this.inputColumnNum = -1;
            this.inputVecExpr = null;
        } else {
            this.inputColumnNum = inputVecExpr.getOutputColumnNum();
            this.inputVecExpr = inputVecExpr instanceof IdentityExpression ? null : inputVecExpr;
        }
        this.outputColumnNum = outputColumnNum;
    }

    public VectorPTFEvaluatorBase(WindowFrameDef windowFrameDef, int outputColumnNum) {
        this.windowFrameDef = windowFrameDef;
        this.inputVecExpr = null;
        this.inputColumnNum = -1;
        this.outputColumnNum = outputColumnNum;
    }

    public boolean getNullsLast() {
        return this.nullsLast;
    }

    public void setNullsLast(boolean nullsLast) {
        this.nullsLast = nullsLast;
    }

    public void evaluateInputExpr(VectorizedRowBatch batch) throws HiveException {
        if (this.inputVecExpr != null) {
            this.inputVecExpr.evaluate(batch);
        }
    }

    public abstract void evaluateGroupBatch(VectorizedRowBatch var1) throws HiveException;

    public void doLastBatchWork() {
    }

    public abstract boolean streamsResult();

    public int getOutputColumnNum() {
        return this.outputColumnNum;
    }

    public boolean isGroupResultNull() {
        throw new RuntimeException("Not implemented isGroupResultNull for " + this.getClass().getName());
    }

    public abstract ColumnVector.Type getResultColumnVectorType();

    public Object getGroupResult() {
        throw new RuntimeException("No generic group result evaluator implementation " + this.getClass().getName());
    }

    public abstract void resetEvaluator();

    public boolean canRunOptimizedCalculation(int rowNum, Range range) {
        return false;
    }

    public Object runOnRange(int rowNum, Range range, VectorPTFGroupBatches batches) throws HiveException {
        if (this.canRunOptimizedCalculation(rowNum, range)) {
            throw new RuntimeException("No optimized runOnRange is implemented for " + this.getClass().getName());
        }
        return null;
    }

    public void onResultCalculated(Object result, Range range) {
    }

    public void onPartitionEnd() {
    }

    public boolean isCacheableForRange() {
        return true;
    }

    public void mapCustomColumns(int[] bufferedColumnMap) {
    }

    public boolean doesRespectNulls() {
        return this.respectNulls;
    }

    public void setRespectNulls(boolean respectNulls) {
        this.respectNulls = respectNulls;
    }
}

