/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk;

import java.io.Serializable;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.Algorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.Requirement;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.shaded.jcip.Immutable;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.JSONStringUtils;

@Immutable
public final class KeyType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Requirement requirement;
    public static final KeyType EC = new KeyType("EC", Requirement.RECOMMENDED);
    public static final KeyType RSA = new KeyType("RSA", Requirement.REQUIRED);
    public static final KeyType OCT = new KeyType("oct", Requirement.OPTIONAL);
    public static final KeyType OKP = new KeyType("OKP", Requirement.OPTIONAL);

    public KeyType(String value, Requirement req) {
        if (value == null) {
            throw new IllegalArgumentException("The key type value must not be null");
        }
        this.value = value;
        this.requirement = req;
    }

    public String getValue() {
        return this.value;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof KeyType && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.value;
    }

    public String toJSONString() {
        return JSONStringUtils.toJSONString(this.value);
    }

    public static KeyType parse(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("The key type to parse must not be null");
        }
        if (s2.equals(EC.getValue())) {
            return EC;
        }
        if (s2.equals(RSA.getValue())) {
            return RSA;
        }
        if (s2.equals(OCT.getValue())) {
            return OCT;
        }
        if (s2.equals(OKP.getValue())) {
            return OKP;
        }
        return new KeyType(s2, null);
    }

    public static KeyType forAlgorithm(Algorithm alg) {
        if (alg == null) {
            return null;
        }
        if (JWSAlgorithm.Family.RSA.contains(alg)) {
            return RSA;
        }
        if (JWSAlgorithm.Family.EC.contains(alg)) {
            return EC;
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains(alg)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.RSA.contains(alg)) {
            return RSA;
        }
        if (JWEAlgorithm.Family.ECDH_ES.contains(alg)) {
            return EC;
        }
        if (JWEAlgorithm.DIR.equals(alg)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.AES_GCM_KW.contains(alg)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.AES_KW.contains(alg)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.PBES2.contains(alg)) {
            return OCT;
        }
        if (JWSAlgorithm.Family.ED.contains(alg)) {
            return OKP;
        }
        return null;
    }
}

