/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.Secret;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client.ClientCredentialsParser;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client.ClientType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Immutable
public class ClientInformation {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final ClientID id;
    private final Date issueDate;
    private final ClientMetadata metadata;
    private final Secret secret;
    private final URI registrationURI;
    private final BearerAccessToken accessToken;

    public ClientInformation(ClientID id, ClientMetadata metadata) {
        this(id, null, metadata, null);
    }

    public ClientInformation(ClientID id, Date issueDate, ClientMetadata metadata, Secret secret) {
        this(id, issueDate, metadata, secret, null, null);
    }

    public ClientInformation(ClientID id, Date issueDate, ClientMetadata metadata, Secret secret, URI registrationURI, BearerAccessToken accessToken) {
        this.id = Objects.requireNonNull(id);
        this.issueDate = issueDate;
        this.metadata = Objects.requireNonNull(metadata);
        this.secret = secret;
        this.registrationURI = registrationURI;
        this.accessToken = accessToken;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ClientID getID() {
        return this.id;
    }

    public Date getIDIssueDate() {
        return this.issueDate;
    }

    public ClientMetadata getMetadata() {
        return this.metadata;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public ClientType inferClientType() {
        return this.secret == null && ClientAuthenticationMethod.NONE.equals(this.getMetadata().getTokenEndpointAuthMethod()) && this.getMetadata().getJWKSetURI() == null && this.getMetadata().getJWKSet() == null ? ClientType.PUBLIC : ClientType.CONFIDENTIAL;
    }

    public URI getRegistrationURI() {
        return this.registrationURI;
    }

    public BearerAccessToken getRegistrationAccessToken() {
        return this.accessToken;
    }

    public JSONObject toJSONObject() {
        JSONObject o = this.metadata.toJSONObject();
        o.put("client_id", this.id.getValue());
        if (this.issueDate != null) {
            o.put("client_id_issued_at", this.issueDate.getTime() / 1000L);
        }
        if (this.secret != null) {
            o.put("client_secret", this.secret.getValue());
            if (this.secret.getExpirationDate() != null) {
                o.put("client_secret_expires_at", this.secret.getExpirationDate().getTime() / 1000L);
            } else {
                o.put("client_secret_expires_at", 0L);
            }
        }
        if (this.registrationURI != null) {
            o.put("registration_client_uri", this.registrationURI.toString());
        }
        if (this.accessToken != null) {
            o.put("registration_access_token", this.accessToken.getValue());
        }
        return o;
    }

    public static ClientInformation parse(JSONObject jsonObject) throws ParseException {
        return new ClientInformation(ClientCredentialsParser.parseID(jsonObject), ClientCredentialsParser.parseIDIssueDate(jsonObject), ClientMetadata.parse(jsonObject), ClientCredentialsParser.parseSecret(jsonObject), ClientCredentialsParser.parseRegistrationURI(jsonObject), ClientCredentialsParser.parseRegistrationAccessToken(jsonObject));
    }

    static {
        HashSet<String> p = new HashSet<String>(ClientMetadata.getRegisteredParameterNames());
        p.add("client_id");
        p.add("client_id_issued_at");
        p.add("client_secret");
        p.add("client_secret_expires_at");
        p.add("registration_access_token");
        p.add("registration_client_uri");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

