/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;

final class ReadCursor {
    private final long beginning;
    private long offset;
    private final long limit;

    ReadCursor(long beginning, long limit) {
        this.limit = limit;
        this.beginning = beginning;
        this.offset = beginning;
    }

    public boolean hasRemaining() {
        return this.limit - this.offset > 0L;
    }

    public void advance(long incr) {
        Preconditions.checkArgument(incr >= 0L);
        this.offset += incr;
    }

    public long read() {
        return this.offset - this.beginning;
    }

    public String toString() {
        return String.format("ReadCursor{begin=%d, offset=%d, limit=%d}", this.beginning, this.offset, this.limit);
    }
}

