/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.est;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.X509CertificateHolder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTRequest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.Source;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Store;

public class EnrollmentResponse {
    private final Store<X509CertificateHolder> store;
    private final long notBefore;
    private final ESTRequest requestToRetry;
    private final Source source;
    private final PrivateKeyInfo privateKeyInfo;

    public EnrollmentResponse(Store<X509CertificateHolder> store, long l, ESTRequest eSTRequest, Source source) {
        this.store = store;
        this.notBefore = l;
        this.requestToRetry = eSTRequest;
        this.source = source;
        this.privateKeyInfo = null;
    }

    public EnrollmentResponse(Store<X509CertificateHolder> store, long l, ESTRequest eSTRequest, Source source, PrivateKeyInfo privateKeyInfo) {
        this.store = store;
        this.notBefore = l;
        this.requestToRetry = eSTRequest;
        this.source = source;
        this.privateKeyInfo = privateKeyInfo;
    }

    public boolean canRetry() {
        return this.notBefore < System.currentTimeMillis();
    }

    public Store<X509CertificateHolder> getStore() {
        return this.store;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public ESTRequest getRequestToRetry() {
        return this.requestToRetry;
    }

    public Object getSession() {
        return this.source.getSession();
    }

    public Source getSource() {
        return this.source;
    }

    public boolean isCompleted() {
        return this.requestToRetry == null;
    }

    public PrivateKeyInfo getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }
}

