/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CopyBackupRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.util.Timestamps;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

public final class CopyBackupRequest {
    private final CopyBackupRequest.Builder requestBuilder = com.google.bigtable.admin.v2.CopyBackupRequest.newBuilder();
    private final String sourceBackupId;
    private final String sourceClusterId;
    private String sourceInstanceId;
    private String sourceProjectId;
    private String destClusterId;

    public static CopyBackupRequest of(String sourceClusterId, String sourceBackupId) {
        CopyBackupRequest request = new CopyBackupRequest(sourceClusterId, sourceBackupId);
        return request;
    }

    private CopyBackupRequest(@Nonnull String sourceClusterId, @Nonnull String sourceBackupId) {
        Preconditions.checkNotNull((Object)sourceClusterId);
        Preconditions.checkNotNull((Object)sourceBackupId);
        this.sourceClusterId = sourceClusterId;
        this.sourceBackupId = sourceBackupId;
    }

    public CopyBackupRequest setSourceInstance(String instanceId) {
        Preconditions.checkNotNull((Object)instanceId);
        this.sourceInstanceId = instanceId;
        return this;
    }

    public CopyBackupRequest setSourceInstance(String projectId, String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        this.sourceProjectId = projectId;
        this.sourceInstanceId = instanceId;
        return this;
    }

    public CopyBackupRequest setDestination(String clusterId, String backupId) {
        Preconditions.checkNotNull((Object)backupId);
        Preconditions.checkNotNull((Object)clusterId);
        this.requestBuilder.setBackupId(backupId);
        this.destClusterId = clusterId;
        return this;
    }

    public CopyBackupRequest setExpireTime(Instant expireTime) {
        Preconditions.checkNotNull((Object)expireTime);
        this.requestBuilder.setExpireTime(Timestamps.fromMillis((long)expireTime.toEpochMilli()));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyBackupRequest that = (CopyBackupRequest)o;
        return Objects.equal((Object)this.requestBuilder.getBackupId(), (Object)that.requestBuilder.getBackupId()) && Objects.equal((Object)this.sourceBackupId, (Object)that.sourceBackupId) && Objects.equal((Object)this.sourceClusterId, (Object)that.sourceClusterId) && Objects.equal((Object)this.sourceInstanceId, (Object)that.sourceInstanceId) && Objects.equal((Object)this.sourceProjectId, (Object)that.sourceProjectId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.getBackupId(), this.sourceBackupId, this.sourceClusterId, this.sourceInstanceId, this.sourceProjectId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CopyBackupRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        return this.requestBuilder.setParent(NameUtil.formatClusterName(projectId, instanceId, this.destClusterId)).setSourceBackup(NameUtil.formatBackupName(this.sourceProjectId == null ? projectId : this.sourceProjectId, this.sourceInstanceId == null ? instanceId : this.sourceInstanceId, this.sourceClusterId, this.sourceBackupId)).build();
    }
}

