/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import java.io.Serializable;
import java.util.Vector;

public class FloatFieldDescription
extends FieldDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    private int decimalPositions_;
    private String floatPrecision_ = "";

    public FloatFieldDescription() {
    }

    public FloatFieldDescription(AS400Float8 dataType, String name) {
        super(dataType, name);
        this.length_ = 9;
    }

    public FloatFieldDescription(AS400Float8 dataType, String name, String ddsName, int length) {
        super(dataType, name, ddsName);
        if (length < 1) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.length_ = length;
    }

    public FloatFieldDescription(AS400Float8 dataType, String name, String ddsName, int length, int decimalPositions) {
        super(dataType, name, ddsName);
        if (length < 1) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (decimalPositions < 0) {
            throw new ExtendedIllegalArgumentException("decimalPositions", 2);
        }
        this.length_ = length;
        this.decimalPositions_ = decimalPositions;
    }

    public FloatFieldDescription(AS400Float4 dataType, String name) {
        super(dataType, name);
        this.length_ = 9;
    }

    public FloatFieldDescription(AS400Float4 dataType, String name, String ddsName, int length) {
        super(dataType, name, ddsName);
        if (length < 1) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.length_ = length;
    }

    public FloatFieldDescription(AS400Float4 dataType, String name, String ddsName, int length, int decimalPositions) {
        super(dataType, name, ddsName);
        if (length < 1) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (decimalPositions < 0) {
            throw new ExtendedIllegalArgumentException("decimalPositions", 2);
        }
        this.length_ = length;
        this.decimalPositions_ = decimalPositions;
    }

    @Override
    String[] getDDSDescription() {
        Vector<String> v = new Vector<String>();
        StringBuilder desc = new StringBuilder(this.ddsName_);
        while (desc.length() < 10) {
            desc.append(" ");
        }
        if (!this.refFld_.equals("")) {
            desc.append("R");
        } else {
            desc.append(" ");
        }
        String len = String.valueOf(this.length_);
        int numSpaces = 5 - len.length();
        for (int i = 0; i < numSpaces; ++i) {
            desc.append(' ');
        }
        desc.append(len);
        desc.append("F");
        StringBuilder decPos = new StringBuilder(Integer.toString(this.decimalPositions_));
        if (decPos.length() == 1) {
            decPos.insert(0, " ");
        }
        desc.append(decPos.toString());
        desc.append("       ");
        v.addElement(desc.toString());
        String[] keywords = super.getFieldFunctions();
        if (keywords != null) {
            for (int i = 0; i < keywords.length; ++i) {
                v.addElement(keywords[i]);
            }
        }
        if (!this.floatPrecision_.equals("")) {
            v.addElement("FLTPCN(" + this.floatPrecision_ + ") ");
        }
        if (this.defaultValue_ != null) {
            v.addElement("DFT(" + this.defaultValue_.toString() + ") ");
        } else if (this.isDFTNull_) {
            v.addElement("DFT(*NULL) ");
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public int getDecimalPositions() {
        return this.decimalPositions_;
    }

    public String getFLTPCN() {
        return this.floatPrecision_;
    }

    public void setDataType(AS400Float4 dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = 9;
    }

    public void setDataType(AS400Float8 dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = 17;
    }

    public void setDecimalPositions(int decimalPositions) {
        if (decimalPositions < 0) {
            throw new ExtendedIllegalArgumentException("decimalPositions (" + String.valueOf(decimalPositions) + ")", 2);
        }
        this.decimalPositions_ = decimalPositions;
    }

    public void setFLTPCN(String floatPrecision) {
        if (floatPrecision == null) {
            throw new NullPointerException("floatPrecision");
        }
        if (!floatPrecision.equalsIgnoreCase("*SINGLE") && !floatPrecision.equalsIgnoreCase("*DOUBLE")) {
            throw new ExtendedIllegalArgumentException("floatPrecision (" + floatPrecision + ")", 2);
        }
        this.floatPrecision_ = floatPrecision;
    }

    public void setDFT(Double defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = defaultValue;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFT(Float defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = defaultValue;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setLength(int length) {
        if (length < 1) {
            throw new ExtendedIllegalArgumentException("length (" + String.valueOf(length) + ")", 2);
        }
        this.length_ = length;
    }
}

