/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stanford.nlp.simple;

import java.util.Collection;
import java.util.Set;

public enum PennTreebankPartOfSpeech {
    CC("Coordinating conjunction"),
    CD("Cardinal number"),
    DT("Determiner"),
    EX("Existential there"),
    FW("Foreign word"),
    IN("Preposition or subordinating conjunction"),
    JJ("Adjective"),
    JJR("Adjective, comparative"),
    JJS("Adjective, superlative"),
    LS("List item marker"),
    MD("Modal"),
    NN("Noun, singular or mass"),
    NNS("Noun, plural"),
    NNP("Proper noun, singular"),
    NNPS("Proper noun, plural"),
    PDT("Predeterminer"),
    POS("Possessive ending"),
    PRP("Personal pronoun"),
    PRP$("Possessive pronoun"),
    RB("Adverb"),
    RBR("Adverb, comparative"),
    RBS("Adverb, superlative"),
    RP("Particle"),
    SYM("Symbol"),
    TO("to"),
    UH("Interjection"),
    VB("Verb, base form"),
    VBD("Verb, past tense"),
    VBG("Verb, gerund or present participle"),
    VBN("Verb, past participle"),
    VBP("Verb, non-3rd person singular present"),
    VBZ("Verb, 3rd person singular present"),
    WDT("Wh-determiner"),
    WP("Wh-pronoun"),
    WP$("Possessive wh-pronoun"),
    WRB("Wh-adverb"),
    AFX("Affix"),
    GW("Additional word in multi-word expression");

    public static final Collection<PennTreebankPartOfSpeech> NOUNS;
    public static final Collection<PennTreebankPartOfSpeech> VERBS;
    public static final Collection<PennTreebankPartOfSpeech> ADVERBS;
    public static final Collection<PennTreebankPartOfSpeech> ADJECTIVES;
    private final String description;

    private PennTreebankPartOfSpeech(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        NOUNS = Set.of(NN, NNP, NNPS, NNS);
        VERBS = Set.of(VB, VBD, VBG, VBN, VBP, VBZ);
        ADVERBS = Set.of(RB, RBR, RBS, WRB);
        ADJECTIVES = Set.of(JJ, JJR, JJS);
    }
}

