/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.expr;

import io.github.spannm.jackcess.impl.expr.FormatUtil;
import io.github.spannm.jackcess.impl.expr.NumberFormatter;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class NumericConfig {
    public static final NumericConfig US_NUMERIC_CONFIG = new NumericConfig(2, true, false, true, 3, Locale.US);
    private final int mnumDecDigits;
    private final boolean mincLeadingDigit;
    private final boolean museNegParens;
    private final boolean museNegCurrencyParens;
    private final int mnumGroupDigits;
    private final DecimalFormatSymbols msymbols;
    private final NumberFormatter mnumFmt;
    private final String mcurrencyFormat;
    private final String mfixedFormat;
    private final String mstandardFormat;
    private final String mpercentFormat;
    private final String mscientificFormat;
    private final String meuroFormat;

    public NumericConfig(int numDecDigits, boolean incLeadingDigit, boolean useNegParens, boolean useNegCurrencyParens, int numGroupDigits, Locale locale) {
        this.mnumDecDigits = numDecDigits;
        this.mincLeadingDigit = incLeadingDigit;
        this.museNegParens = useNegParens;
        this.museNegCurrencyParens = useNegCurrencyParens;
        this.mnumGroupDigits = numGroupDigits;
        this.msymbols = DecimalFormatSymbols.getInstance(locale);
        this.mnumFmt = new NumberFormatter(this.msymbols);
        this.mcurrencyFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.CURRENCY, this.mnumDecDigits, this.mincLeadingDigit, this.museNegCurrencyParens, this.mnumGroupDigits);
        this.mfixedFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.GENERAL, this.mnumDecDigits, true, this.museNegParens, 0);
        this.mstandardFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.GENERAL, this.mnumDecDigits, this.mincLeadingDigit, this.museNegParens, this.mnumGroupDigits);
        this.mpercentFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.PERCENT, this.mnumDecDigits, this.mincLeadingDigit, this.museNegParens, 0);
        this.mscientificFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.SCIENTIFIC, this.mnumDecDigits, true, false, 0);
        this.meuroFormat = FormatUtil.createNumberFormatPattern(FormatUtil.NumPatternType.EURO, this.mnumDecDigits, this.mincLeadingDigit, this.museNegCurrencyParens, this.mnumGroupDigits);
    }

    public int getNumDecimalDigits() {
        return this.mnumDecDigits;
    }

    public boolean includeLeadingDigit() {
        return this.mincLeadingDigit;
    }

    public boolean useParensForNegatives() {
        return this.museNegParens;
    }

    public boolean useParensForCurrencyNegatives() {
        return this.museNegCurrencyParens;
    }

    public int getNumGroupingDigits() {
        return this.mnumGroupDigits;
    }

    public String getNumberFormat(Type type) {
        switch (type) {
            case CURRENCY: {
                return this.mcurrencyFormat;
            }
            case FIXED: {
                return this.mfixedFormat;
            }
            case STANDARD: {
                return this.mstandardFormat;
            }
            case PERCENT: {
                return this.mpercentFormat;
            }
            case SCIENTIFIC: {
                return this.mscientificFormat;
            }
            case EURO: {
                return this.meuroFormat;
            }
        }
        throw new IllegalArgumentException("unknown number type " + type);
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.msymbols;
    }

    public String format(float f) {
        return this.mnumFmt.format(f);
    }

    public String format(double d) {
        return this.mnumFmt.format(d);
    }

    public String format(BigDecimal bd) {
        return this.mnumFmt.format(bd);
    }

    public static enum Type {
        CURRENCY,
        FIXED,
        STANDARD,
        PERCENT,
        SCIENTIFIC,
        EURO;

    }
}

