/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.sqs.SqsIO;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;

final class AutoValue_SqsIO_Read
extends SqsIO.Read {
    private final ClientConfiguration clientConfiguration;
    private final @Nullable String queueUrl;
    private final long maxNumRecords;
    private final @Nullable Duration maxReadTime;

    private AutoValue_SqsIO_Read(ClientConfiguration clientConfiguration, @Nullable String queueUrl, long maxNumRecords, @Nullable Duration maxReadTime) {
        this.clientConfiguration = clientConfiguration;
        this.queueUrl = queueUrl;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
    }

    @Override
    ClientConfiguration clientConfiguration() {
        return this.clientConfiguration;
    }

    @Override
    @Nullable String queueUrl() {
        return this.queueUrl;
    }

    @Override
    long maxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Pure
    @Nullable Duration maxReadTime() {
        return this.maxReadTime;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SqsIO.Read) {
            SqsIO.Read that = (SqsIO.Read)((Object)o);
            return this.clientConfiguration.equals(that.clientConfiguration()) && (this.queueUrl == null ? that.queueUrl() == null : this.queueUrl.equals(that.queueUrl())) && this.maxNumRecords == that.maxNumRecords() && (this.maxReadTime == null ? that.maxReadTime() == null : this.maxReadTime.equals((Object)that.maxReadTime()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clientConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.queueUrl == null ? 0 : this.queueUrl.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h$ *= 1000003;
        return h$ ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
    }

    @Override
    SqsIO.Read.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends SqsIO.Read.Builder {
        private ClientConfiguration clientConfiguration;
        private @Nullable String queueUrl;
        private Long maxNumRecords;
        private @Nullable Duration maxReadTime;

        Builder() {
        }

        private Builder(SqsIO.Read source) {
            this.clientConfiguration = source.clientConfiguration();
            this.queueUrl = source.queueUrl();
            this.maxNumRecords = source.maxNumRecords();
            this.maxReadTime = source.maxReadTime();
        }

        @Override
        SqsIO.Read.Builder setClientConfiguration(ClientConfiguration clientConfiguration) {
            if (clientConfiguration == null) {
                throw new NullPointerException("Null clientConfiguration");
            }
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        @Override
        SqsIO.Read.Builder setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        @Override
        SqsIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        SqsIO.Read.Builder setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        SqsIO.Read build() {
            if (this.clientConfiguration == null || this.maxNumRecords == null) {
                StringBuilder missing = new StringBuilder();
                if (this.clientConfiguration == null) {
                    missing.append(" clientConfiguration");
                }
                if (this.maxNumRecords == null) {
                    missing.append(" maxNumRecords");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SqsIO_Read(this.clientConfiguration, this.queueUrl, this.maxNumRecords, this.maxReadTime);
        }
    }
}

