/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Meter;
import org.apache.cassandra.exceptions.ReadAbortException;
import org.apache.cassandra.exceptions.ReadSizeAbortException;
import org.apache.cassandra.exceptions.TombstoneAbortException;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.LatencyMetrics;

public class ClientRequestMetrics
extends LatencyMetrics {
    public final Meter timeouts;
    public final Meter unavailables;
    public final Meter failures;
    public final Meter aborts;
    public final Meter tombstoneAborts;
    public final Meter readSizeAborts;
    public final Meter localRequests;
    public final Meter remoteRequests;

    public ClientRequestMetrics(String scope) {
        super("ClientRequest", scope);
        this.timeouts = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Timeouts"));
        this.unavailables = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Unavailables"));
        this.failures = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Failures"));
        this.aborts = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Aborts"));
        this.tombstoneAborts = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("TombstoneAborts"));
        this.readSizeAborts = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("ReadSizeAborts"));
        this.localRequests = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("LocalRequests"));
        this.remoteRequests = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("RemoteRequests"));
    }

    public void markAbort(Throwable cause) {
        this.aborts.mark();
        if (!(cause instanceof ReadAbortException)) {
            return;
        }
        if (cause instanceof TombstoneAbortException) {
            this.tombstoneAborts.mark();
        } else if (cause instanceof ReadSizeAbortException) {
            this.readSizeAborts.mark();
        }
    }

    @Override
    public void release() {
        super.release();
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("Timeouts"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("Unavailables"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("Failures"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("Aborts"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("TombstoneAborts"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("ReadSizeAborts"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LocalRequests"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("RemoteRequests"));
    }
}

