/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.util;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.util.jackson.JacksonMapperFactory;

public class RestMapperUtils {
    private static final ObjectMapper strictObjectMapper = JacksonMapperFactory.createObjectMapper();
    private static final ObjectMapper flexibleObjectMapper;

    public static ObjectMapper getStrictObjectMapper() {
        return strictObjectMapper;
    }

    public static ObjectMapper getFlexibleObjectMapper() {
        return flexibleObjectMapper;
    }

    static {
        strictObjectMapper.enable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY});
        strictObjectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        flexibleObjectMapper = strictObjectMapper.copy();
        flexibleObjectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

